/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.extensions;

import cloud.filibuster.exceptions.filibuster.FilibusterAnalysisFileResourcePathException;
import cloud.filibuster.exceptions.filibuster.FilibusterUnsupportedCustomAnalysisFileException;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.FilibusterSearchStrategy;
import cloud.filibuster.junit.TestWithFilibuster;
import cloud.filibuster.junit.configuration.FilibusterAnalysisConfigurationFile;
import cloud.filibuster.junit.configuration.FilibusterConfiguration;
import cloud.filibuster.junit.configuration.FilibusterCustomAnalysisConfigurationFile;
import cloud.filibuster.junit.formatters.FilibusterTestDisplayNameFormatter;
import cloud.filibuster.junit.interceptors.FilibusterTestInvocationContext;
import cloud.filibuster.junit.server.FilibusterServerBackend;
import cloud.filibuster.junit.server.latency.FilibusterLatencyProfile;
import cloud.filibuster.junit.server.latency.FilibusterNoLatencyProfile;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

public class FilibusterTestExtension
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationUtils.isAnnotated((Optional)context.getTestMethod(), TestWithFilibuster.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        FilibusterSearchStrategy searchStrategy;
        boolean failIfFaultNotInjectedAndATrackedMethodIsInvoked;
        boolean failIfFaultInjected;
        boolean failIfFaultInjectionMismatch;
        boolean suppressCombinations;
        boolean failOnOrganicFailures;
        boolean avoidInjectionsOnOrganicFailures;
        boolean avoidRedundantInjections;
        String analysisFile;
        URL analysisFileResourcePath;
        String analysisResourceFile;
        Method testMethod = context.getRequiredTestMethod();
        String className = context.getTestClass().map(Class::getName).orElse("");
        String displayName = context.getDisplayName();
        Preconditions.condition((boolean)AnnotationUtils.findAnnotation((AnnotatedElement)testMethod, TestWithFilibuster.class).isPresent(), () -> "Configuration error: @FilibusterTest must be used on any methods extended with FilibusterTestExtension.'.");
        TestWithFilibuster testWithFilibuster = (TestWithFilibuster)AnnotationUtils.findAnnotation((AnnotatedElement)testMethod, TestWithFilibuster.class).get();
        int specifiedMaxIterations = FilibusterTestExtension.maxIterations(testWithFilibuster, testMethod);
        int maxIterations = specifiedMaxIterations + 1;
        FilibusterTestDisplayNameFormatter formatter = FilibusterTestExtension.displayNameFormatter(testWithFilibuster, testMethod, displayName);
        if (!testWithFilibuster.analysisResourceFile().isEmpty()) {
            analysisResourceFile = testWithFilibuster.analysisResourceFile();
            analysisFileResourcePath = FilibusterTestExtension.class.getClassLoader().getResource(analysisResourceFile);
            if (analysisFileResourcePath == null) {
                throw new FilibusterAnalysisFileResourcePathException("Analysis resource file property is set, but file does not exist.");
            }
            analysisFile = analysisFileResourcePath.getPath();
        } else if (!testWithFilibuster.analysisFile().isEmpty()) {
            analysisFile = testWithFilibuster.analysisFile();
        } else if (!Property.getTestAnalysisResourceFileProperty().isEmpty()) {
            analysisResourceFile = Property.getTestAnalysisResourceFileProperty();
            analysisFileResourcePath = FilibusterTestExtension.class.getClassLoader().getResource(analysisResourceFile);
            if (analysisFileResourcePath == null) {
                throw new FilibusterAnalysisFileResourcePathException("Analysis resource file property is set, but file does not exist.");
            }
            analysisFile = analysisFileResourcePath.getPath();
        } else {
            analysisFile = "/tmp/filibuster-analysis-file";
            FilibusterTestExtension.classToCustomAnalysisConfigurationFile(testWithFilibuster, analysisFile);
        }
        String dockerImageName = !testWithFilibuster.dockerImageName().isEmpty() ? testWithFilibuster.dockerImageName() : Property.getServerBackendDockerImageNameProperty();
        boolean dataNondeterminism = testWithFilibuster.dataNondeterminism();
        if (!dataNondeterminism) {
            dataNondeterminism = Property.getTestDataNondeterminismProperty();
        }
        if (!(avoidRedundantInjections = testWithFilibuster.avoidRedundantInjections())) {
            avoidRedundantInjections = Property.getTestAvoidRedundantInjectionsProperty();
        }
        if (!(avoidInjectionsOnOrganicFailures = testWithFilibuster.avoidInjectionsOnOrganicFailures())) {
            avoidInjectionsOnOrganicFailures = Property.getTestAvoidInjectionsOnOrganicFailuresProperty();
        }
        if (!(failOnOrganicFailures = testWithFilibuster.failOnOrganicFailures())) {
            failOnOrganicFailures = Property.getTestFailOnOrganicFailuresProperty();
        }
        if (!(suppressCombinations = testWithFilibuster.suppressCombinations())) {
            suppressCombinations = Property.getTestSuppressCombinationsProperty();
        }
        if (!(failIfFaultInjectionMismatch = testWithFilibuster.failIfFaultInjectionMismatch())) {
            failIfFaultInjectionMismatch = Property.getFailIfFaultNotInjectedProperty();
        }
        if (!(failIfFaultInjected = testWithFilibuster.failIfFaultNotInjected())) {
            failIfFaultInjected = Property.getFailIfFaultNotInjectedProperty();
        }
        if (!(failIfFaultNotInjectedAndATrackedMethodIsInvoked = testWithFilibuster.failIfFaultNotInjectedAndATrackedMethodIsInvoked())) {
            failIfFaultNotInjectedAndATrackedMethodIsInvoked = Property.getFailIfFaultNotInjectedAndATrackedMethodIsInvokedProperty();
        }
        if ((searchStrategy = testWithFilibuster.searchStrategy()).equals((Object)FilibusterSearchStrategy.DEFAULT)) {
            FilibusterServerBackend filibusterServerBackend = FilibusterConfiguration.backendToBackendClass(testWithFilibuster.serverBackend());
            searchStrategy = filibusterServerBackend.defaultSearchStrategy();
        }
        FilibusterConfiguration filibusterConfiguration = new FilibusterConfiguration.Builder().abortOnFirstFailure(testWithFilibuster.abortOnFirstFailure()).dynamicReduction(testWithFilibuster.dynamicReduction()).suppressCombinations(suppressCombinations).dataNondeterminism(dataNondeterminism).avoidRedundantInjections(avoidRedundantInjections).avoidInjectionsOnOrganicFailures(avoidInjectionsOnOrganicFailures).failOnOrganicFailures(failOnOrganicFailures).serverBackend(testWithFilibuster.serverBackend()).searchStrategy(searchStrategy).dockerImageName(dockerImageName).analysisFile(analysisFile).degradeWhenServerInitializationFails(testWithFilibuster.degradeWhenServerInitializationFails()).expected(testWithFilibuster.expected()).faultInjectionFilter(testWithFilibuster.faultInjectionFilter()).latencyProfile(testWithFilibuster.latencyProfile()).serviceProfilesPath(testWithFilibuster.serviceProfilesPath()).serviceProfileBehavior(testWithFilibuster.serviceProfileBehavior()).testName(displayName).className(className).failIfFaultNotInjected(failIfFaultInjected).failIfFaultInjectionMismatch(failIfFaultInjectionMismatch).failIfFaultNotInjectedAndATrackedMethodIsInvoked(failIfFaultNotInjectedAndATrackedMethodIsInvoked).build();
        FilibusterTestExtension.validateSearchBackend(searchStrategy, filibusterConfiguration);
        FilibusterTestExtension.validateBackendSelection(testWithFilibuster, filibusterConfiguration);
        HashMap invocationCompletionMap = new HashMap();
        if (Property.getEnabledProperty()) {
            return IntStream.rangeClosed(1, maxIterations).mapToObj(iteration -> new FilibusterTestInvocationContext(iteration, maxIterations, formatter, filibusterConfiguration, invocationCompletionMap));
        }
        return IntStream.rangeClosed(1, 1).mapToObj(iteration -> new FilibusterTestInvocationContext(iteration, maxIterations, formatter, filibusterConfiguration, invocationCompletionMap));
    }

    private static void classToCustomAnalysisConfigurationFile(TestWithFilibuster testWithFilibuster, String analysisFile) {
        FilibusterAnalysisConfigurationFile analysisConfigurationFile;
        Class<? extends FilibusterAnalysisConfigurationFile> clazz = testWithFilibuster.analysisConfigurationFile();
        try {
            analysisConfigurationFile = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FilibusterUnsupportedCustomAnalysisFileException("Class doesn't match expected contract: " + e);
        }
        FilibusterCustomAnalysisConfigurationFile filibusterAnalysisConfigurationFile = analysisConfigurationFile.toFilibusterCustomAnalysisConfigurationFile();
        filibusterAnalysisConfigurationFile.writeToDisk(analysisFile);
    }

    private static int maxIterations(TestWithFilibuster testWithFilibuster, Method method) {
        int repetitions = testWithFilibuster.maxIterations();
        if (repetitions == 99) {
            repetitions = Property.getTestMaxIterationsProperty();
        }
        Preconditions.condition((repetitions > 0 ? 1 : 0) != 0, () -> String.format("Configuration error: @FilibusterTest on method [%s] must be declared with a positive 'maxIterations'.", method));
        return repetitions;
    }

    private static void validateSearchBackend(FilibusterSearchStrategy filibusterSearchStrategy, FilibusterConfiguration filibusterConfiguration) {
        FilibusterServerBackend filibusterServerBackend = filibusterConfiguration.getServerBackend();
        List<FilibusterSearchStrategy> supportedSearchStrategies = filibusterServerBackend.supportedSearchStrategies();
        Preconditions.condition((boolean)supportedSearchStrategies.contains((Object)filibusterSearchStrategy), () -> String.format("Configuration error: @FilibusterTest on method [%s] must be declared a supported search strategy by the chosen backend.", filibusterServerBackend));
    }

    private static void validateBackendSelection(TestWithFilibuster testWithFilibuster, FilibusterConfiguration filibusterConfiguration) {
        FilibusterServerBackend filibusterServerBackend = filibusterConfiguration.getServerBackend();
        FilibusterLatencyProfile filibusterLatencyProfile = filibusterConfiguration.getLatencyProfile();
        if (!(filibusterLatencyProfile instanceof FilibusterNoLatencyProfile)) {
            Preconditions.condition((boolean)filibusterServerBackend.latencyProfileSupported(), () -> String.format("Configuration error: @FilibusterTest on method [%s] is using a custom latency profile but the chosen backend does not support it.", filibusterServerBackend));
        }
    }

    private static FilibusterTestDisplayNameFormatter displayNameFormatter(TestWithFilibuster testWithFilibuster, Method method, String displayName) {
        String initialName = Preconditions.notBlank((String)testWithFilibuster.initialName().trim(), () -> String.format("Configuration error: @FilibusterTest on method [%s] must be declared with a non-empty name.", method));
        String generatedName = Preconditions.notBlank((String)testWithFilibuster.name().trim(), () -> String.format("Configuration error: @FilibusterTest on method [%s] must be declared with a non-empty name.", method));
        return new FilibusterTestDisplayNameFormatter(initialName, generatedName, displayName);
    }
}

