/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.interceptors;

import cloud.filibuster.exceptions.filibuster.FilibusterNoopException;
import cloud.filibuster.instrumentation.datatypes.FilibusterExecutor;
import cloud.filibuster.instrumentation.helpers.Networking;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.FilibusterSystemProperties;
import cloud.filibuster.junit.configuration.FilibusterConfiguration;
import cloud.filibuster.junit.interceptors.FilibusterInvocationInterceptorHelpers;
import cloud.filibuster.junit.server.FilibusterServerAPI;
import cloud.filibuster.junit.server.FilibusterServerLifecycle;
import com.linecorp.armeria.client.WebClient;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import junit.framework.AssertionFailedError;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class FilibusterInvocationInterceptor
implements InvocationInterceptor {
    private static final Logger logger = Logger.getLogger(FilibusterInvocationInterceptor.class.getName());
    public static boolean shouldInitializeFilibusterServer = true;
    private final FilibusterConfiguration filibusterConfiguration;
    private final Map<Integer, Boolean> invocationCompletionMap;
    private final int currentIteration;
    public static boolean previousIterationFailed = false;
    private final int maxIterations;
    @Nullable
    private static WebClient privateWebClient;

    private static boolean hasWebClient() {
        return privateWebClient != null;
    }

    @Nullable
    public static WebClient getWebClient() {
        return privateWebClient;
    }

    private static void setWebClient(@Nullable WebClient webClient) {
        privateWebClient = webClient;
    }

    private static WebClient getNewWebClient() {
        String filibusterBaseUri = "http://" + Networking.getFilibusterHost() + ":" + Networking.getFilibusterPort() + "/";
        return WebClient.builder((String)filibusterBaseUri).factory(FilibusterExecutor.getNewClientFactory(1)).build();
    }

    public FilibusterInvocationInterceptor(FilibusterConfiguration filibusterConfiguration, int currentIteration, int maxIterations, Map<Integer, Boolean> invocationCompletionMap) {
        this.currentIteration = currentIteration;
        this.maxIterations = maxIterations;
        this.invocationCompletionMap = invocationCompletionMap;
        this.filibusterConfiguration = filibusterConfiguration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (FilibusterServerLifecycle.didServerInitializationFail()) {
            if (this.filibusterConfiguration.getDegradeWhenServerInitializationFails()) {
                if (this.currentIteration == 1) {
                    invocation.proceed();
                    return;
                } else {
                    invocation.skip();
                }
                return;
            } else if (this.currentIteration == 1) {
                Throwable t = FilibusterServerLifecycle.getInitializationFailedException();
                Class<? extends Throwable> expectedExceptionClass = this.filibusterConfiguration.getExpected();
                if (expectedExceptionClass == FilibusterNoopException.class) throw FilibusterServerLifecycle.getInitializationFailedException();
                if (!expectedExceptionClass.isInstance(t)) throw new AssertionFailedError("Expected instance of " + expectedExceptionClass + ", but received " + t);
                invocation.skip();
                return;
            } else {
                invocation.skip();
            }
            return;
        } else {
            Property.setInstrumentationEnabledProperty(true);
            if (this.currentIteration == 1) {
                FilibusterInvocationInterceptorHelpers.proceedAndLogException(this, invocation, this.currentIteration, FilibusterInvocationInterceptor.getWebClient(), this.filibusterConfiguration);
            } else if (this.currentIteration == this.maxIterations) {
                invocation.skip();
            } else if (FilibusterInvocationInterceptorHelpers.shouldBypassExecution(FilibusterInvocationInterceptor.getWebClient(), this.currentIteration, "testTemplate", this.filibusterConfiguration.getAbortOnFirstFailure(), previousIterationFailed)) {
                invocation.skip();
            } else {
                FilibusterInvocationInterceptorHelpers.proceedAndLogException(this, invocation, this.currentIteration, FilibusterInvocationInterceptor.getWebClient(), this.filibusterConfiguration);
            }
            Property.setInstrumentationEnabledProperty(false);
        }
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.currentIteration == 1) {
            if (shouldInitializeFilibusterServer) {
                FilibusterInvocationInterceptor.setWebClient(FilibusterServerLifecycle.startServer(this.filibusterConfiguration));
            } else {
                FilibusterInvocationInterceptor.setWebClient(FilibusterInvocationInterceptor.getNewWebClient());
            }
            if (FilibusterInvocationInterceptor.hasWebClient()) {
                FilibusterServerAPI.analysisFile(FilibusterInvocationInterceptor.getWebClient(), this.filibusterConfiguration.readAnalysisFile());
            }
            FilibusterSystemProperties.setSystemPropertiesForFilibusterInstrumentation(this.filibusterConfiguration);
        }
        if (FilibusterInvocationInterceptor.hasWebClient()) {
            FilibusterInvocationInterceptorHelpers.conditionallyMarkTeardownComplete(this.invocationCompletionMap, this.currentIteration, FilibusterInvocationInterceptor.getWebClient());
        }
        this.interceptTestMethod(invocation, invocationContext, extensionContext);
        if (this.currentIteration == this.maxIterations) {
            FilibusterSystemProperties.unsetSystemPropertiesForFilibusterInstrumentation();
            if (FilibusterInvocationInterceptor.hasWebClient()) {
                FilibusterServerAPI.terminate(FilibusterInvocationInterceptor.getWebClient());
            }
            if (shouldInitializeFilibusterServer) {
                if (FilibusterInvocationInterceptor.hasWebClient()) {
                    FilibusterInvocationInterceptor.setWebClient(FilibusterServerLifecycle.stopServer(this.filibusterConfiguration, FilibusterInvocationInterceptor.getWebClient()));
                }
            } else {
                FilibusterInvocationInterceptor.setWebClient(null);
            }
            System.gc();
        }
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (FilibusterServerLifecycle.didServerInitializationFail()) {
            if (this.filibusterConfiguration.getDegradeWhenServerInitializationFails()) {
                if (this.currentIteration == 1) {
                    invocation.proceed();
                } else {
                    invocation.skip();
                }
            } else if (this.currentIteration == 1) {
                invocation.proceed();
            } else {
                invocation.skip();
            }
        } else if (this.currentIteration == 1) {
            invocation.proceed();
        } else if (this.currentIteration == this.maxIterations) {
            invocation.skip();
        } else {
            FilibusterInvocationInterceptorHelpers.conditionallyMarkTeardownComplete(this.invocationCompletionMap, this.currentIteration, FilibusterInvocationInterceptor.getWebClient());
            if (FilibusterInvocationInterceptorHelpers.shouldBypassExecution(FilibusterInvocationInterceptor.getWebClient(), this.currentIteration, "beforeEach", this.filibusterConfiguration.getAbortOnFirstFailure(), previousIterationFailed)) {
                invocation.skip();
            } else {
                invocation.proceed();
            }
        }
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (FilibusterServerLifecycle.didServerInitializationFail()) {
            if (this.filibusterConfiguration.getDegradeWhenServerInitializationFails()) {
                if (this.currentIteration == 1) {
                    invocation.proceed();
                } else {
                    invocation.skip();
                }
            } else if (this.currentIteration == 1) {
                invocation.proceed();
            } else {
                invocation.skip();
            }
        } else if (this.currentIteration == 1) {
            FilibusterInvocationInterceptorHelpers.proceedAndLogException(this, invocation, this.currentIteration, FilibusterInvocationInterceptor.getWebClient(), this.filibusterConfiguration, false, false);
        } else if (this.currentIteration == this.maxIterations) {
            invocation.skip();
        } else if (FilibusterInvocationInterceptorHelpers.shouldBypassExecution(FilibusterInvocationInterceptor.getWebClient(), this.currentIteration, "afterEach", this.filibusterConfiguration.getAbortOnFirstFailure(), previousIterationFailed)) {
            invocation.skip();
        } else {
            FilibusterInvocationInterceptorHelpers.proceedAndLogException(this, invocation, this.currentIteration, FilibusterInvocationInterceptor.getWebClient(), this.filibusterConfiguration, false, false);
        }
    }
}

