/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.interceptors;

import cloud.filibuster.exceptions.filibuster.FilibusterFaultNotInjectedAndATrackedMethodInvokedException;
import cloud.filibuster.exceptions.filibuster.FilibusterFaultNotInjectedException;
import cloud.filibuster.exceptions.filibuster.FilibusterNoopException;
import cloud.filibuster.exceptions.filibuster.FilibusterOrganicFailuresPresentException;
import cloud.filibuster.exceptions.filibuster.FilibusterRuntimeException;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.configuration.FilibusterConfiguration;
import cloud.filibuster.junit.interceptors.FilibusterInvocationInterceptor;
import cloud.filibuster.junit.server.FilibusterServerAPI;
import cloud.filibuster.junit.server.core.FilibusterCore;
import com.linecorp.armeria.client.WebClient;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.InvocationInterceptor;

public class FilibusterInvocationInterceptorHelpers {
    private static final Logger logger = Logger.getLogger(FilibusterInvocationInterceptorHelpers.class.getName());

    private FilibusterInvocationInterceptorHelpers() {
    }

    public static boolean shouldBypassExecution(WebClient webClient, int currentIteration, String caller, boolean abortOnFirstFailure, boolean previousExecutionFailed) {
        try {
            boolean hasNextIteration = FilibusterServerAPI.hasNextIteration(webClient, currentIteration, caller);
            if (hasNextIteration) {
                return abortOnFirstFailure && previousExecutionFailed;
            }
            return true;
        }
        catch (Exception e) {
            throw new FilibusterRuntimeException("Filibuster server threw: " + e, e);
        }
    }

    public static void proceedAndLogException(FilibusterInvocationInterceptor filibusterInvocationInterceptor, InvocationInterceptor.Invocation<Void> invocation, int currentIteration, WebClient webClient, FilibusterConfiguration filibusterConfiguration) throws Throwable {
        FilibusterInvocationInterceptorHelpers.proceedAndLogException(filibusterInvocationInterceptor, invocation, currentIteration, webClient, filibusterConfiguration, true, true);
    }

    public static void proceedAndLogException(FilibusterInvocationInterceptor filibusterInvocationInterceptor, InvocationInterceptor.Invocation<Void> invocation, int currentIteration, WebClient webClient, FilibusterConfiguration filibusterConfiguration, boolean shouldWritePlaceholder, boolean shouldPrintRpcSummary) throws Throwable {
        try {
            if (Property.getServerBackendCanInvokeDirectlyProperty() && FilibusterCore.hasCurrentInstance() && shouldWritePlaceholder) {
                FilibusterCore.getCurrentInstance().writePlaceholderReport();
            }
            invocation.proceed();
            if (filibusterConfiguration.getFailOnOrganicFailures() && FilibusterCore.hasCurrentInstance() && FilibusterCore.getCurrentInstance().testContainsOrganicFailures()) {
                FilibusterOrganicFailuresPresentException t = new FilibusterOrganicFailuresPresentException("Organic failures present and test failed because failOnOrganicFailures = true!\na.) did you write stubs for all invoked RPCs?\nb.) are all downstream services running and able to respond to RPCs?\nc.) did a circuit breaker activate and prohibit testing?\n");
                FilibusterServerAPI.recordIterationComplete(webClient, currentIteration, true, t, shouldPrintRpcSummary);
                FilibusterInvocationInterceptor.previousIterationFailed = true;
                throw t;
            }
            FilibusterServerAPI.recordIterationComplete(webClient, currentIteration, false, null, shouldPrintRpcSummary);
        }
        catch (Throwable t) {
            Class<? extends Throwable> expectedExceptionClass = filibusterConfiguration.getExpected();
            if (expectedExceptionClass != FilibusterNoopException.class && expectedExceptionClass.isInstance(t)) {
                if (!expectedExceptionClass.equals(FilibusterFaultNotInjectedException.class) && !expectedExceptionClass.equals(FilibusterFaultNotInjectedAndATrackedMethodInvokedException.class)) {
                    FilibusterServerAPI.recordIterationComplete(webClient, currentIteration, false, null, shouldPrintRpcSummary);
                }
            }
            FilibusterServerAPI.recordIterationComplete(webClient, currentIteration, true, t, shouldPrintRpcSummary);
            FilibusterInvocationInterceptor.previousIterationFailed = true;
            throw t;
        }
    }

    public static void conditionallyMarkTeardownComplete(Map<Integer, Boolean> invocationCompletionMap, int currentIteration, WebClient webClient) {
        int previousIteration = currentIteration - 1;
        if (!invocationCompletionMap.containsKey(previousIteration) && previousIteration != 0) {
            try {
                FilibusterServerAPI.teardownsCompleted(webClient, previousIteration);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.log(Level.SEVERE, "Could not notify Filibuster of teardown completed; this is fatal error: " + e);
            }
            invocationCompletionMap.put(previousIteration, true);
        }
    }
}

