/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.resolvers;

import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.ToStringBuilder;

public class FilibusterIterationInfoParameterResolver
implements ParameterResolver {
    private final int currentIteration;
    private final int maxIterations;

    public FilibusterIterationInfoParameterResolver(int currentIteration, int maxIterations) {
        this.currentIteration = currentIteration;
        this.maxIterations = maxIterations;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == RepetitionInfo.class;
    }

    public RepetitionInfo resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return new DefaultRepetitionInfo(this.currentIteration, this.maxIterations);
    }

    private static class DefaultRepetitionInfo
    implements RepetitionInfo {
        private final int currentIteration;
        private final int maxIterations;

        DefaultRepetitionInfo(int currentIteration, int maxIterations) {
            this.currentIteration = currentIteration;
            this.maxIterations = maxIterations;
        }

        public int getCurrentRepetition() {
            return this.currentIteration;
        }

        public int getTotalRepetitions() {
            return this.maxIterations;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("currentIteration", (Object)this.currentIteration).append("maxIterations", (Object)this.maxIterations).toString();
        }
    }
}

