/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server;

import cloud.filibuster.exceptions.filibuster.FilibusterRuntimeException;
import cloud.filibuster.exceptions.filibuster.FilibusterServerBadResponseException;
import cloud.filibuster.instrumentation.datatypes.FilibusterExecutor;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.instrumentation.helpers.Response;
import cloud.filibuster.junit.server.core.FilibusterCore;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.json.JSONObject;

public class FilibusterServerAPI {
    public static boolean healthCheck(WebClient webClient) throws ExecutionException, InterruptedException {
        CompletableFuture<Boolean> healthCheck = CompletableFuture.supplyAsync(() -> {
            RequestHeaders getJson = RequestHeaders.of((HttpMethod)HttpMethod.GET, (String)"/health-check", (CharSequence)HttpHeaderNames.ACCEPT, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true");
            AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(getJson).aggregate().join();
            ResponseHeaders headers = response.headers();
            String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
            if (statusCode == null) {
                FilibusterServerBadResponseException.logAndThrow("healthCheck, statusCode: null");
                return false;
            }
            if (!Objects.equals(statusCode, "200")) {
                FilibusterServerBadResponseException.logAndThrow("healthCheck, statusCode: " + statusCode);
                return false;
            }
            if (statusCode.equals("200")) {
                return true;
            }
            return false;
        }, FilibusterExecutor.getExecutorService());
        return healthCheck.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void analysisFile(WebClient webClient, JSONObject jsonAnalysisConfiguration) throws ExecutionException, InterruptedException {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (!FilibusterCore.hasCurrentInstance()) throw new FilibusterRuntimeException("No current filibuster core instance, this could indicate a problem.");
            FilibusterCore.getCurrentInstance().analysisFile(jsonAnalysisConfiguration);
            return;
        } else {
            CompletableFuture<Void> analysisFileFuture = CompletableFuture.supplyAsync(() -> {
                RequestHeaders postJson = RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)"/filibuster/analysis-file", (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true");
                AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(postJson, jsonAnalysisConfiguration.toString()).aggregate().join();
                ResponseHeaders headers = response.headers();
                String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
                if (statusCode == null) {
                    FilibusterServerBadResponseException.logAndThrow("analysisFile, statusCode: null");
                }
                if (!Objects.equals(statusCode, "200")) {
                    FilibusterServerBadResponseException.logAndThrow("analysisFile, statusCode: " + statusCode);
                }
                return null;
            }, FilibusterExecutor.getExecutorService());
            analysisFileFuture.get();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void terminate(WebClient webClient) throws ExecutionException, InterruptedException {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (!FilibusterCore.hasCurrentInstance()) throw new FilibusterRuntimeException("No current filibuster core instance, this could indicate a problem.");
            FilibusterCore.getCurrentInstance().terminateFilibuster();
            return;
        } else {
            CompletableFuture<Void> terminateFuture = CompletableFuture.supplyAsync(() -> {
                RequestHeaders getJson = RequestHeaders.of((HttpMethod)HttpMethod.GET, (String)"/filibuster/terminate", (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true");
                AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(getJson).aggregate().join();
                ResponseHeaders headers = response.headers();
                String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
                if (statusCode == null) {
                    FilibusterServerBadResponseException.logAndThrow("terminate, statusCode: null");
                }
                if (!Objects.equals(statusCode, "200")) {
                    FilibusterServerBadResponseException.logAndThrow("terminate, statusCode: " + statusCode);
                }
                return null;
            }, FilibusterExecutor.getExecutorService());
            terminateFuture.get();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void teardownsCompleted(WebClient webClient, int currentIteration) throws ExecutionException, InterruptedException {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (!FilibusterCore.hasCurrentInstance()) throw new FilibusterRuntimeException("No current filibuster core instance, this could indicate a problem.");
            FilibusterCore.getCurrentInstance().teardownsCompleted(currentIteration);
            return;
        } else {
            CompletableFuture<Void> teardownsCompletedFuture = CompletableFuture.supplyAsync(() -> {
                RequestHeaders getJson = RequestHeaders.of((HttpMethod)HttpMethod.GET, (String)("/filibuster/teardowns-completed/" + currentIteration), (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true");
                AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(getJson).aggregate().join();
                ResponseHeaders headers = response.headers();
                String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
                if (statusCode == null) {
                    FilibusterServerBadResponseException.logAndThrow("teardownsCompleted, statusCode: null");
                }
                if (!Objects.equals(statusCode, "200")) {
                    FilibusterServerBadResponseException.logAndThrow("teardownsCompleted, statusCode: " + statusCode);
                }
                return null;
            }, FilibusterExecutor.getExecutorService());
            teardownsCompletedFuture.get();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void recordIterationComplete(WebClient webClient, int currentIteration, boolean exceptionOccurred, Throwable throwable, boolean shouldPrintRpcSummary) throws ExecutionException, InterruptedException {
        int exceptionOccurredInt = exceptionOccurred ? 1 : 0;
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (!FilibusterCore.hasCurrentInstance()) throw new FilibusterRuntimeException("No current filibuster core instance, this could indicate a problem.");
            FilibusterCore.getCurrentInstance().completeIteration(currentIteration, exceptionOccurredInt, throwable, shouldPrintRpcSummary);
            return;
        } else {
            CompletableFuture<Void> updateFuture = CompletableFuture.supplyAsync(() -> {
                RequestHeaders postJson = RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)("/filibuster/complete-iteration/" + currentIteration + "/exception/" + exceptionOccurredInt), (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true");
                AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(postJson).aggregate().join();
                ResponseHeaders headers = response.headers();
                String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
                if (statusCode == null) {
                    FilibusterServerBadResponseException.logAndThrow("recordIterationComplete, statusCode: null");
                }
                if (!Objects.equals(statusCode, "200")) {
                    FilibusterServerBadResponseException.logAndThrow("recordIterationComplete, statusCode: " + statusCode);
                }
                return null;
            }, FilibusterExecutor.getExecutorService());
            updateFuture.get();
        }
    }

    public static boolean hasNextIteration(WebClient webClient, int currentIteration, String caller) throws ExecutionException, InterruptedException {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().hasNextIteration(currentIteration, caller);
            }
            throw new FilibusterRuntimeException("No current filibuster core instance, this could indicate a problem.");
        }
        CompletableFuture<Boolean> hasNextIteration = CompletableFuture.supplyAsync(() -> {
            RequestHeaders getJson = RequestHeaders.of((HttpMethod)HttpMethod.GET, (String)("/filibuster/has-next-iteration/" + currentIteration + "/" + caller), (CharSequence)HttpHeaderNames.ACCEPT, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true");
            AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(getJson).aggregate().join();
            ResponseHeaders headers = response.headers();
            String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
            if (statusCode == null) {
                FilibusterServerBadResponseException.logAndThrow("hasNextIteration, statusCode: null");
            }
            if (!Objects.equals(statusCode, "200")) {
                FilibusterServerBadResponseException.logAndThrow("hasNextIteration, statusCode: " + statusCode);
            }
            JSONObject jsonObject = Response.aggregatedHttpResponseToJsonObject(response);
            return jsonObject.getBoolean("has-next-iteration");
        }, FilibusterExecutor.getExecutorService());
        return hasNextIteration.get();
    }
}

