/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server;

import cloud.filibuster.instrumentation.datatypes.FilibusterExecutor;
import cloud.filibuster.instrumentation.exceptions.FilibusterServerUnavailabilityException;
import cloud.filibuster.instrumentation.helpers.Networking;
import cloud.filibuster.junit.configuration.FilibusterConfiguration;
import cloud.filibuster.junit.server.FilibusterServerAPI;
import cloud.filibuster.junit.server.FilibusterServerBackend;
import com.linecorp.armeria.client.WebClient;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class FilibusterServerLifecycle {
    private static boolean started = false;
    private static boolean initializationFailed = false;
    @Nullable
    private static Throwable initializationFailedException = null;
    private static final Logger logger = Logger.getLogger(FilibusterServerLifecycle.class.getName());

    public static boolean didServerInitializationFail() {
        return initializationFailed;
    }

    public static Throwable getInitializationFailedException() {
        return initializationFailedException;
    }

    private static WebClient getNewWebClient() {
        String filibusterBaseUri = "http://" + Networking.getFilibusterHost() + ":" + Networking.getFilibusterPort() + "/";
        return WebClient.builder((String)filibusterBaseUri).factory(FilibusterExecutor.getNewClientFactory(1)).build();
    }

    @Nullable
    public static synchronized WebClient startServer(FilibusterConfiguration filibusterConfiguration) {
        initializationFailed = false;
        initializationFailedException = null;
        if (!started) {
            FilibusterServerBackend filibusterServerBackend = filibusterConfiguration.getServerBackend();
            try {
                filibusterServerBackend.start(filibusterConfiguration);
                WebClient webClient = FilibusterServerLifecycle.getNewWebClient();
                boolean online = false;
                for (int i = 0; i < 10; ++i) {
                    logger.log(Level.INFO, "Waiting for FilibusterServer to come online...");
                    try {
                        online = FilibusterServerAPI.healthCheck(webClient);
                        if (online) {
                            break;
                        }
                    }
                    catch (RuntimeException | ExecutionException exception) {
                        // empty catch block
                    }
                    logger.log(Level.INFO, "Sleeping one second...");
                    Thread.sleep(1000L);
                }
                if (!online) {
                    logger.log(Level.INFO, "FilibusterServer never came online!");
                    throw new FilibusterServerUnavailabilityException();
                }
                started = true;
                return webClient;
            }
            catch (Throwable t) {
                initializationFailed = true;
                initializationFailedException = t;
                return null;
            }
        }
        return FilibusterServerLifecycle.getNewWebClient();
    }

    @Nullable
    public static synchronized WebClient stopServer(FilibusterConfiguration filibusterConfiguration, WebClient webClient) throws Throwable {
        if (started) {
            FilibusterServerBackend filibusterServerBackend = filibusterConfiguration.getServerBackend();
            filibusterServerBackend.stop(filibusterConfiguration);
            while (true) {
                logger.log(Level.INFO, "Waiting for FilibusterServer to stop...");
                try {
                    FilibusterServerAPI.healthCheck(webClient);
                }
                catch (RuntimeException | ExecutionException e) {
                    break;
                }
                logger.log(Level.INFO, "Sleeping one second until offline.");
                Thread.sleep(1000L);
            }
            logger.log(Level.INFO, "Filibuster server stopped!");
            initializationFailedException = null;
            initializationFailed = false;
            started = false;
        }
        return null;
    }
}

