/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.backends;

import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.FilibusterSearchStrategy;
import cloud.filibuster.junit.configuration.FilibusterConfiguration;
import cloud.filibuster.junit.server.FilibusterServerBackend;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class FilibusterDockerServerBackend
implements FilibusterServerBackend {
    private GenericContainer<?> container;
    private static final int EXPOSED_PORT = 5005;

    @Override
    public synchronized boolean start(FilibusterConfiguration filibusterConfiguration) throws Throwable {
        String fullImageName = filibusterConfiguration.getDockerImageName();
        this.container = new GenericContainer(DockerImageName.parse((String)fullImageName)).withExposedPorts(new Integer[]{5005}).waitingFor((WaitStrategy)new HttpWaitStrategy().forPort(5005)).withStartupTimeout(Duration.ofMinutes(5L));
        if (filibusterConfiguration.getSuppressCombinations()) {
            this.container = this.container.withEnv("SHOULD_SUPPRESS_COMBINATIONS", "True");
        }
        if (!filibusterConfiguration.getDynamicReduction()) {
            this.container = this.container.withEnv("DISABLE_DYNAMIC_REDUCTION", "True");
        }
        this.container.start();
        Property.setServerHostProperty(this.container.getHost());
        Property.setServerPortProperty(this.container.getMappedPort(5005));
        return true;
    }

    @Override
    public synchronized boolean stop(FilibusterConfiguration filibusterConfiguration) {
        this.container.stop();
        Property.setServerHostProperty("localhost");
        Property.setServerPortProperty(5005);
        return true;
    }

    @Override
    public List<FilibusterSearchStrategy> supportedSearchStrategies() {
        return Arrays.asList(FilibusterSearchStrategy.DFS);
    }

    @Override
    public FilibusterSearchStrategy defaultSearchStrategy() {
        return FilibusterSearchStrategy.DFS;
    }

    @Override
    public boolean latencyProfileSupported() {
        return false;
    }
}

