/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core;

import cloud.filibuster.RpcType;
import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.dei.implementations.DistributedExecutionIndexV1;
import cloud.filibuster.exceptions.filibuster.FilibusterCoreLogicException;
import cloud.filibuster.exceptions.filibuster.FilibusterFaultInjectionException;
import cloud.filibuster.exceptions.filibuster.FilibusterFaultInjectionMismatchException;
import cloud.filibuster.exceptions.filibuster.FilibusterFaultNotInjectedAndATrackedMethodInvokedException;
import cloud.filibuster.exceptions.filibuster.FilibusterFaultNotInjectedException;
import cloud.filibuster.exceptions.filibuster.FilibusterLatencyInjectionException;
import cloud.filibuster.exceptions.filibuster.FilibusterRuntimeException;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.FilibusterSearchStrategy;
import cloud.filibuster.junit.assertions.BlockType;
import cloud.filibuster.junit.configuration.FilibusterAnalysisConfiguration;
import cloud.filibuster.junit.configuration.FilibusterConfiguration;
import cloud.filibuster.junit.configuration.FilibusterCustomAnalysisConfigurationFile;
import cloud.filibuster.junit.filters.FilibusterFaultInjectionFilter;
import cloud.filibuster.junit.server.core.FilibusterCoreTransformerExtension;
import cloud.filibuster.junit.server.core.TestExecutionCollection;
import cloud.filibuster.junit.server.core.TestExecutionQueue;
import cloud.filibuster.junit.server.core.TestExecutionStack;
import cloud.filibuster.junit.server.core.profiles.ServiceProfile;
import cloud.filibuster.junit.server.core.profiles.ServiceProfileBehavior;
import cloud.filibuster.junit.server.core.profiles.ServiceRequestAndResponse;
import cloud.filibuster.junit.server.core.reports.ServerInvocationAndResponseReport;
import cloud.filibuster.junit.server.core.reports.TestExecutionReport;
import cloud.filibuster.junit.server.core.reports.TestReport;
import cloud.filibuster.junit.server.core.reports.TestSuiteReport;
import cloud.filibuster.junit.server.core.test_executions.AbstractTestExecution;
import cloud.filibuster.junit.server.core.test_executions.ConcreteTestExecution;
import cloud.filibuster.junit.server.core.test_executions.TestExecution;
import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import cloud.filibuster.junit.server.latency.FilibusterLatencyProfile;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.linecorp.armeria.common.HttpMethod;
import io.grpc.Status;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class FilibusterCore {
    private static final Logger logger = Logger.getLogger(FilibusterCore.class.getName());
    @Nullable
    private static FilibusterCore currentInstance;
    private final UUID testUuid = UUID.randomUUID();
    private int numBypassedExecutions = 0;
    private boolean faultInjectionEnabled = true;
    private final TestReport testReport;
    private final FilibusterConfiguration filibusterConfiguration;
    private final TestExecutionCollection<AbstractTestExecution> unexploredTestExecutions;
    private final TestExecutionCollection<TestExecution> exploredTestExecutions;
    @Nullable
    private AbstractTestExecution currentAbstractTestExecution;
    @Nullable
    private ConcreteTestExecution currentConcreteTestExecution;
    @Nullable
    private FilibusterCustomAnalysisConfigurationFile filibusterCustomAnalysisConfigurationFile;
    private int numberOfAbstractExecutionsAttempted = 0;
    private int numberOfAbstractExecutionsExecuted = 0;
    private int numberOfConcreteExecutionsExecuted = 0;
    private static TestExecutionReport mostRecentInitialTestExecutionReport;

    public static synchronized FilibusterCore getCurrentInstance() {
        if (currentInstance == null) {
            throw new FilibusterCoreLogicException("Current instance is null, this indicates a problem!");
        }
        return currentInstance;
    }

    public static synchronized boolean hasCurrentInstance() {
        return currentInstance != null;
    }

    public synchronized int getNumBypassedExecutions() {
        return this.numBypassedExecutions;
    }

    public static void removeCurrentInstance() {
        currentInstance = null;
    }

    public FilibusterCore(FilibusterConfiguration filibusterConfiguration) {
        currentInstance = this;
        String testName = filibusterConfiguration.getTestName();
        String className = filibusterConfiguration.getClassName();
        this.currentConcreteTestExecution = new ConcreteTestExecution(testName, this.testUuid, className);
        this.filibusterConfiguration = filibusterConfiguration;
        if (filibusterConfiguration.getSearchStrategy() == FilibusterSearchStrategy.DFS) {
            this.exploredTestExecutions = new TestExecutionStack<TestExecution>();
            this.unexploredTestExecutions = new TestExecutionStack<AbstractTestExecution>();
        } else if (filibusterConfiguration.getSearchStrategy() == FilibusterSearchStrategy.BFS) {
            this.exploredTestExecutions = new TestExecutionQueue<TestExecution>();
            this.unexploredTestExecutions = new TestExecutionQueue<AbstractTestExecution>();
        } else {
            throw new FilibusterCoreLogicException("Unsupported search strategy: " + (Object)((Object)filibusterConfiguration.getSearchStrategy()));
        }
        TestSuiteReport.getInstance();
        this.testReport = new TestReport(testName, this.testUuid, className);
        this.testReport.writeOutPlaceholder();
    }

    public static synchronized TestExecutionReport getMostRecentInitialTestExecutionReport() {
        return mostRecentInitialTestExecutionReport;
    }

    public static synchronized void setMostRecentInitialTestExecutionReport(TestExecutionReport report) {
        mostRecentInitialTestExecutionReport = report;
    }

    public synchronized void enableFaultInjection() {
        this.faultInjectionEnabled = true;
    }

    public synchronized void disableFaultInjection() {
        this.faultInjectionEnabled = false;
    }

    public synchronized void writePlaceholderReport() {
        logger.info("[FILIBUSTER-CORE]: writePlaceholderReport called");
        if (this.currentConcreteTestExecution == null) {
            throw new FilibusterCoreLogicException("currentConcreteTestExecution should not be null at this point, something fatal occurred.");
        }
        this.currentConcreteTestExecution.writePlaceHolderTestExecutionReport();
        logger.info("[FILIBUSTER-CORE]: writePlaceholderReport returning");
    }

    public synchronized void incrementTestScopeCounter() {
        if (this.currentConcreteTestExecution != null) {
            this.currentConcreteTestExecution.incrementTestScopeCounter();
        }
    }

    public synchronized void incrementTestScopeCounter(BlockType blockType) {
        if (this.currentConcreteTestExecution != null) {
            this.currentConcreteTestExecution.incrementTestScopeCounter(blockType);
        }
    }

    public synchronized int getTestScopeCounter() {
        if (this.currentConcreteTestExecution != null) {
            return this.currentConcreteTestExecution.getTestScopeCounter();
        }
        return 0;
    }

    public synchronized BlockType getLastTestScopeBlockType() {
        if (this.currentConcreteTestExecution != null) {
            return this.currentConcreteTestExecution.getLastTestScopeBlockType();
        }
        return BlockType.DEFAULT;
    }

    public synchronized JSONObject beginInvocation(JSONObject payload) {
        logger.info("[FILIBUSTER-CORE]: beginInvocation called, payload: " + payload.toString(4));
        if (this.currentConcreteTestExecution == null) {
            throw new FilibusterCoreLogicException("currentConcreteTestExecution should not be null at this point, something fatal occurred.");
        }
        boolean hasSeenRpcUnderSameOrDifferentDistributedExecutionIndex = this.currentConcreteTestExecution.hasSeenRpcUnderSameOrDifferentDistributedExecutionIndex(payload);
        String distributedExecutionIndexString = payload.getString("execution_index");
        DistributedExecutionIndex distributedExecutionIndex = new DistributedExecutionIndexV1().deserialize(distributedExecutionIndexString);
        logger.info("[FILIBUSTER-CORE]: beginInvocation called, distributedExecutionIndex: " + distributedExecutionIndex);
        this.currentConcreteTestExecution.addDistributedExecutionIndexWithRequestPayload(distributedExecutionIndex, payload, hasSeenRpcUnderSameOrDifferentDistributedExecutionIndex && this.filibusterConfiguration.getAvoidRedundantInjections());
        int generatedId = this.currentConcreteTestExecution.incrementGeneratedId();
        if (this.filibusterCustomAnalysisConfigurationFile != null) {
            boolean shouldGenerateNewAbstractExecutions;
            JSONObject payloadMetadata;
            String moduleName = payload.getString("module");
            String methodName = payload.getString("method");
            RpcType rpcType = null;
            if (payload.has("metadata") && (payloadMetadata = payload.getJSONObject("metadata")).has("rpc_type")) {
                String sRpcType = payloadMetadata.getString("rpc_type");
                rpcType = FilibusterCore.toRpcType(sRpcType);
            }
            if (this.currentAbstractTestExecution == null) {
                shouldGenerateNewAbstractExecutions = true;
            } else {
                boolean bl = shouldGenerateNewAbstractExecutions = !this.currentAbstractTestExecution.sawInConcreteTestExecution(distributedExecutionIndex);
            }
            if (shouldGenerateNewAbstractExecutions && this.faultInjectionEnabled) {
                if (this.filibusterConfiguration.getAvoidRedundantInjections()) {
                    if (!hasSeenRpcUnderSameOrDifferentDistributedExecutionIndex) {
                        this.generateFaultsUsingAnalysisConfiguration(this.filibusterConfiguration, distributedExecutionIndex, rpcType, moduleName, methodName);
                    }
                } else {
                    this.generateFaultsUsingAnalysisConfiguration(this.filibusterConfiguration, distributedExecutionIndex, rpcType, moduleName, methodName);
                }
            }
        }
        JSONObject response = new JSONObject();
        if (this.currentAbstractTestExecution != null && this.currentAbstractTestExecution.shouldFault(distributedExecutionIndex)) {
            JSONObject faultObject = this.currentAbstractTestExecution.getFault(distributedExecutionIndex);
            if (faultObject.has("forced_exception")) {
                JSONObject forcedExceptionFaultObject = faultObject.getJSONObject("forced_exception");
                logger.info("[FILIBUSTER-CORE]: beginInvocation, injecting faults using forced_exception: " + forcedExceptionFaultObject.toString(4));
                response.put("forced_exception", (Object)forcedExceptionFaultObject);
            } else if (faultObject.has("failure_metadata")) {
                JSONObject failureMetadataFaultObject = faultObject.getJSONObject("failure_metadata");
                logger.info("[FILIBUSTER-CORE]: beginInvocation, injecting faults using failure_metadata: " + failureMetadataFaultObject.toString(4));
                response.put("failure_metadata", (Object)failureMetadataFaultObject);
            } else if (faultObject.has("transformer_fault")) {
                JSONObject transformerFaultObject = faultObject.getJSONObject("transformer_fault");
                Transformer transformationResult = FilibusterCoreTransformerExtension.getTransformerResult(transformerFaultObject);
                if (transformationResult.hasNext()) {
                    JSONObject newFaultObject = new JSONObject(faultObject.toMap());
                    FilibusterCoreTransformerExtension.setNextAccumulator(newFaultObject.getJSONObject("transformer_fault"), transformationResult.getNextAccumulator());
                    FilibusterCoreTransformerExtension.generateAndSetTransformerValue(newFaultObject.getJSONObject("transformer_fault"));
                    this.createAndScheduleAbstractTestExecution(this.filibusterConfiguration, distributedExecutionIndex, newFaultObject);
                }
                logger.info("[FILIBUSTER-CORE]: beginInvocation, injecting faults using transformer_fault: " + transformerFaultObject.toString(4));
                FilibusterCoreTransformerExtension.setTransformerValue(transformerFaultObject, transformationResult.getResult());
                response.put("transformer_fault", (Object)transformerFaultObject);
            } else if (faultObject.has("latency")) {
                JSONObject latencyObject = faultObject.getJSONObject("latency");
                logger.info("[FILIBUSTER-CORE]: beginInvocation, injecting faults using latency: " + latencyObject.toString(4));
                int millisecondsToDelay = latencyObject.getInt("milliseconds");
                try {
                    Thread.sleep(millisecondsToDelay);
                }
                catch (InterruptedException e) {
                    throw new FilibusterFaultInjectionException("Failed to inject latency for call: ", e);
                }
            } else {
                logger.info("[FILIBUSTER-CORE]: beginInvocation, failing to inject unknown fault: " + faultObject.toString(4));
                throw new FilibusterFaultInjectionException("Unknown fault configuration: " + faultObject);
            }
        }
        response.put("generated_id", generatedId);
        FilibusterLatencyProfile filibusterLatencyProfile = this.filibusterConfiguration.getLatencyProfile();
        if (filibusterLatencyProfile != null) {
            int totalSleepMs = 0;
            int serviceSleepMs = filibusterLatencyProfile.getMsLatencyForService(payload.getString("module"));
            int methodSleepMs = filibusterLatencyProfile.getMsLatencyForMethod(payload.getString("method"));
            totalSleepMs += serviceSleepMs;
            logger.info("\n[FILIBUSTER-CORE]: sleep based on latency profile: \nserviceSleepMs: " + serviceSleepMs + "\nmethodSleepMs: " + methodSleepMs + "\ntotalSleepMs: " + (totalSleepMs += methodSleepMs) + "\n");
            try {
                Thread.sleep(totalSleepMs);
            }
            catch (InterruptedException e) {
                throw new FilibusterLatencyInjectionException("Failed to inject latency for call: ", e);
            }
        }
        logger.info("[FILIBUSTER-CORE]: beginInvocation returning, response: " + response.toString(4));
        return response;
    }

    public synchronized JSONObject endInvocation(JSONObject payload, boolean isUpdate) {
        logger.info("[FILIBUSTER-CORE]: endInvocation called");
        String distributedExecutionIndexString = payload.getString("execution_index");
        DistributedExecutionIndex distributedExecutionIndex = new DistributedExecutionIndexV1().deserialize(distributedExecutionIndexString);
        logger.info("[FILIBUSTER-CORE]: endInvocation called, distributedExecutionIndex: " + distributedExecutionIndex);
        if (this.currentConcreteTestExecution == null) {
            throw new FilibusterCoreLogicException("currentConcreteTestExecution should not be null at this point, something fatal occurred.");
        }
        this.currentConcreteTestExecution.addDistributedExecutionIndexWithResponsePayload(distributedExecutionIndex, payload);
        if (!isUpdate) {
            this.scheduleTransformerFaults(payload, distributedExecutionIndex);
        }
        JSONObject response = new JSONObject();
        response.put("execution_index", (Object)payload.getString("execution_index"));
        logger.info("[FILIBUSTER-CORE]: endInvocation returning: " + response.toString(4));
        return response;
    }

    private void scheduleTransformerFaults(JSONObject payload, DistributedExecutionIndex distributedExecutionIndex) {
        boolean shouldGenerateNewAbstractExecutions;
        if (this.currentAbstractTestExecution == null) {
            shouldGenerateNewAbstractExecutions = true;
        } else {
            boolean bl = shouldGenerateNewAbstractExecutions = !this.currentAbstractTestExecution.sawInConcreteTestExecution(distributedExecutionIndex);
        }
        if (this.currentConcreteTestExecution == null) {
            throw new FilibusterCoreLogicException("currentConcreteTestExecution should not be null at this point, something fatal occurred.");
        }
        boolean hasSeenRpcUnderSameOrDifferentDistributedExecutionIndex = this.currentConcreteTestExecution.hasSeenRpcUnderSameOrDifferentDistributedExecutionIndex(payload);
        if (shouldGenerateNewAbstractExecutions && this.faultInjectionEnabled) {
            if (this.filibusterConfiguration.getAvoidRedundantInjections()) {
                if (!hasSeenRpcUnderSameOrDifferentDistributedExecutionIndex) {
                    this.generateTransformerFaults(payload, distributedExecutionIndex);
                }
            } else {
                this.generateTransformerFaults(payload, distributedExecutionIndex);
            }
        }
    }

    private void generateTransformerFaults(JSONObject payload, DistributedExecutionIndex distributedExecutionIndex) {
        if (payload.has("instrumentation_type") && payload.getString("instrumentation_type").equals("request_received")) {
            return;
        }
        if (!payload.has("module") || !payload.has("method")) {
            throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: generateTransformerFaults, payload missing module or method: " + payload.toString(4));
        }
        String moduleName = payload.getString("module");
        String methodName = payload.getString("method");
        if (this.filibusterCustomAnalysisConfigurationFile != null) {
            for (FilibusterAnalysisConfiguration filibusterAnalysisConfiguration : this.filibusterCustomAnalysisConfigurationFile.getFilibusterAnalysisConfigurations()) {
                if (!filibusterAnalysisConfiguration.isPatternMatch(methodName) && !filibusterAnalysisConfiguration.isPatternMatch(moduleName + "." + methodName)) continue;
                List<JSONObject> transformerFaults = filibusterAnalysisConfiguration.getTransformerFaultObjects();
                for (JSONObject transformer : transformerFaults) {
                    if (!transformer.has("transformer_fault") || !payload.has("return_value") || !payload.getJSONObject("return_value").has("value") || payload.getJSONObject("return_value").getString("value").isEmpty() || payload.getJSONObject("return_value").getString("value").equals(JSONObject.NULL)) continue;
                    try {
                        JSONObject handledTransformer = FilibusterCoreTransformerExtension.handleGatewayTransformer(transformer, payload.getJSONObject("return_value").getString("value"), payload.getJSONObject("return_value").getString("__class__"));
                        Accumulator<?, ?> initialAccumulator = FilibusterCoreTransformerExtension.getInitialAccumulator(handledTransformer.getJSONObject("transformer_fault"), payload.getJSONObject("return_value").getString("value"));
                        FilibusterCoreTransformerExtension.setNextAccumulator(handledTransformer.getJSONObject("transformer_fault"), initialAccumulator);
                        FilibusterCoreTransformerExtension.generateAndSetTransformerValue(handledTransformer.getJSONObject("transformer_fault"));
                        this.createAndScheduleAbstractTestExecution(this.filibusterConfiguration, distributedExecutionIndex, new JSONObject(handledTransformer.toMap()));
                    }
                    catch (Throwable e) {
                        logger.warning("[FILIBUSTER-CORE]: generateTransformerFaults, an exception occurred in generateTransformerFaults: " + e);
                        throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: generateTransformerFaults: " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    public synchronized boolean isNewTestExecution(String serviceName) {
        logger.info("[FILIBUSTER-CORE]: isNewTestExecution called, serviceName: " + serviceName);
        boolean result = false;
        if (this.currentConcreteTestExecution == null) {
            result = false;
        } else if (!this.currentConcreteTestExecution.hasSeenFirstRequestFromService(serviceName)) {
            this.currentConcreteTestExecution.registerFirstRequestFromService(serviceName);
            result = true;
        } else {
            result = false;
        }
        logger.info("[FILIBUSTER-CORE]: isNewTestExecution returning: " + result);
        return result;
    }

    public synchronized void completeIteration(int currentIteration) {
        this.completeIteration(currentIteration, 0, null);
    }

    public synchronized void completeIteration(int currentIteration, int exceptionOccurred, @Nullable Throwable throwable) {
        this.completeIteration(currentIteration, exceptionOccurred, throwable, true);
    }

    public synchronized void completeIteration(int currentIteration, int exceptionOccurred, Throwable throwable, boolean shouldPrintRpcSummary) {
        logger.info("[FILIBUSTER-CORE]: completeIteration called, currentIteration: " + currentIteration + ", exceptionOccurred: " + exceptionOccurred);
        if (this.currentConcreteTestExecution != null) {
            MapDifference diff;
            Map<DistributedExecutionIndex, JSONObject> failedRpcs;
            Map<DistributedExecutionIndex, JSONObject> faultsToInject;
            if (shouldPrintRpcSummary) {
                this.currentConcreteTestExecution.printRpcs();
            }
            if (exceptionOccurred != 0) {
                this.currentConcreteTestExecution.writeTestExecutionReport(currentIteration, exceptionOccurred != 0, throwable);
            } else {
                this.currentConcreteTestExecution.writeTestExecutionReport(currentIteration, exceptionOccurred != 0, null);
            }
            if (this.filibusterConfiguration.getFailIfFaultInjectionMismatch() && (throwable == null || !throwable.getClass().equals(FilibusterFaultNotInjectedException.class))) {
                faultsToInject = this.currentConcreteTestExecution.getFaultsToInject();
                failedRpcs = this.currentConcreteTestExecution.getFailedRpcs();
                for (Map.Entry<DistributedExecutionIndex, JSONObject> faultToInject : faultsToInject.entrySet()) {
                    JSONObject metadataObject;
                    JSONObject exceptionObject;
                    JSONObject failedRpc;
                    JSONObject forcedExceptionObject;
                    JSONObject faultToInjectObject = faultToInject.getValue();
                    if (!faultToInjectObject.has("forced_exception") || !(forcedExceptionObject = faultToInjectObject.getJSONObject("forced_exception")).has("metadata")) continue;
                    JSONObject forcedMetadataObject = forcedExceptionObject.getJSONObject("metadata");
                    if (!failedRpcs.containsKey(faultToInject.getKey()) || !(failedRpc = failedRpcs.get(faultToInject.getKey())).has("exception") || !(exceptionObject = failedRpc.getJSONObject("exception")).has("metadata") || (metadataObject = exceptionObject.getJSONObject("metadata")).similar((Object)forcedMetadataObject)) continue;
                    throw new FilibusterFaultInjectionMismatchException("Injected fault does not match the fault that occurred: does the application have resilience measures that were activated by repeated fault injection?  Expected: " + forcedMetadataObject + "; actual: " + metadataObject);
                }
            }
            if (this.filibusterConfiguration.getFailIfFaultNotInjected() && (throwable == null || !throwable.getClass().equals(FilibusterFaultNotInjectedException.class))) {
                faultsToInject = this.currentConcreteTestExecution.getFaultsToInject();
                failedRpcs = this.currentConcreteTestExecution.getFailedRpcs();
                if (failedRpcs.size() != faultsToInject.size()) {
                    diff = Maps.difference(faultsToInject, failedRpcs);
                    throw new FilibusterFaultNotInjectedException("One or more of the intended faults was not injected: " + diff.entriesOnlyOnLeft().values());
                }
            }
            if (this.filibusterConfiguration.getFailIfFaultNotInjectedAndATrackedMethodIsInvoked() && (throwable == null || !throwable.getClass().equals(FilibusterFaultNotInjectedException.class))) {
                faultsToInject = this.currentConcreteTestExecution.getFaultsToInject();
                failedRpcs = this.currentConcreteTestExecution.getFailedRpcs();
                if (failedRpcs.size() != faultsToInject.size()) {
                    diff = Maps.difference(faultsToInject, failedRpcs);
                    ArrayList<String> methodNames = new ArrayList<String>();
                    for (Map.Entry<DistributedExecutionIndex, JSONObject> dei : this.currentConcreteTestExecution.getTestExecutionReport().getResponses().entrySet()) {
                        JSONObject returnValue;
                        JSONObject responseObject = dei.getValue();
                        if (!responseObject.has("return_value") || !(returnValue = responseObject.getJSONObject("return_value")).has("trackedMethodInvoked") || !returnValue.getBoolean("trackedMethodInvoked")) continue;
                        methodNames.add(responseObject.getString("method"));
                    }
                    throw new FilibusterFaultNotInjectedAndATrackedMethodInvokedException("The following tracked method(s) was invoked: " + methodNames + ". However, one or more of the intended faults was not injected: " + diff.entriesOnlyOnLeft().values());
                }
            }
        } else {
            throw new FilibusterCoreLogicException("currentConcreteTestExecution should not be null at this point, something fatal occurred.");
        }
        if (shouldPrintRpcSummary) {
            this.printSummary();
        }
        logger.info("[FILIBUSTER-CORE]: completeIteration returning");
    }

    public synchronized int iterationsRemaining() {
        logger.info("[FILIBUSTER-CORE]: iterationsRemaining called");
        int iterationsRemaining = this.unexploredTestExecutions.size();
        logger.info("[FILIBUSTER-CORE]: iterationsRemaining returning: " + iterationsRemaining);
        return iterationsRemaining;
    }

    public synchronized boolean hasNextIteration(int currentIteration) {
        logger.info("[FILIBUSTER-CORE]: hasNextIteration called, currentIteration: " + currentIteration);
        boolean result = this.currentConcreteTestExecution != null;
        logger.info("[FILIBUSTER-CORE]: hasNextIteration returning: " + result);
        return result;
    }

    public synchronized boolean hasNextIteration(int currentIteration, String caller) {
        logger.info("[FILIBUSTER-CORE]: hasNextIteration called, currentIteration: " + currentIteration + ", caller: " + caller);
        boolean result = this.currentConcreteTestExecution != null;
        logger.info("[FILIBUSTER-CORE]: hasNextIteration returning: " + result);
        return result;
    }

    public synchronized boolean testContainsOrganicFailures() {
        boolean found = false;
        if (this.currentConcreteTestExecution != null) {
            for (Map.Entry<DistributedExecutionIndex, JSONObject> executedRpc : this.currentConcreteTestExecution.getExecutedRpcs().entrySet()) {
                DistributedExecutionIndex distributedExecutionIndex = executedRpc.getKey();
                boolean organicallyFailedInSourceConcreteTestExecution = TestExecution.organicallyFailedInSourceConcreteTestExecution(this.currentConcreteTestExecution, this.currentConcreteTestExecution, distributedExecutionIndex);
                boolean faultWasInjected = this.currentConcreteTestExecution.getFaultsToInject().containsKey(distributedExecutionIndex);
                if (!organicallyFailedInSourceConcreteTestExecution || faultWasInjected) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public synchronized void teardownsCompleted(int currentIteration) {
        logger.info("[FILIBUSTER-CORE]: teardownsCompleted called, currentIteration: " + currentIteration);
        if (this.currentConcreteTestExecution != null) {
            TestExecutionReport testExecutionReport = this.currentConcreteTestExecution.getTestExecutionReport();
            if (currentIteration == 1) {
                FilibusterCore.setMostRecentInitialTestExecutionReport(testExecutionReport);
            }
            this.testReport.addTestExecutionReport(testExecutionReport);
            if (this.currentAbstractTestExecution != null) {
                ++this.numberOfAbstractExecutionsAttempted;
                if (!this.exploredTestExecutions.containsTestExecution(this.currentAbstractTestExecution)) {
                    ++this.numberOfAbstractExecutionsExecuted;
                    this.exploredTestExecutions.addTestExecution(this.currentAbstractTestExecution);
                } else {
                    logger.severe("[FILIBUSTER-CORE]: teardownsCompleted called, currentAbstractTestExecution already exists in the explored queue, this could indicate a problem in Filibuster.");
                }
            }
            if (!this.exploredTestExecutions.containsTestExecution(this.currentConcreteTestExecution)) {
                this.exploredTestExecutions.addTestExecution(this.currentConcreteTestExecution);
            }
            ++this.numberOfConcreteExecutionsExecuted;
            this.currentAbstractTestExecution = null;
            this.currentConcreteTestExecution = null;
            if (!this.unexploredTestExecutions.isEmpty()) {
                AbstractTestExecution nextAbstractTestExecution;
                logger.info("[FILIBUSTER-CORE]: teardownsCompleted, scheduling next test execution.");
                do {
                    nextAbstractTestExecution = this.unexploredTestExecutions.removeAndReturnNextTestExecution();
                    if (!this.filibusterConfiguration.getAvoidInjectionsOnOrganicFailures() || !nextAbstractTestExecution.shoulBypassForOrganicFailure()) continue;
                    ++this.numBypassedExecutions;
                    nextAbstractTestExecution = null;
                } while (nextAbstractTestExecution == null && !this.unexploredTestExecutions.isEmpty());
                if (nextAbstractTestExecution != null) {
                    this.currentAbstractTestExecution = nextAbstractTestExecution;
                    this.currentConcreteTestExecution = new ConcreteTestExecution(nextAbstractTestExecution, this.filibusterConfiguration.getTestName(), this.testUuid, this.filibusterConfiguration.getClassName());
                }
            }
        }
        logger.info("[FILIBUSTER-CORE]: teardownsCompleted returning.");
    }

    @Nullable
    public synchronized Map<DistributedExecutionIndex, JSONObject> faultsInjected() {
        logger.info("[FILIBUSTER-CORE]: faultsInjected called");
        if (this.currentConcreteTestExecution == null) {
            return null;
        }
        Map<DistributedExecutionIndex, JSONObject> result = this.currentConcreteTestExecution.getFaultsToInject();
        logger.info("[FILIBUSTER-CORE]: faultsInjected returning: " + result);
        return result;
    }

    @Nullable
    public synchronized Map<DistributedExecutionIndex, JSONObject> executedRpcs() {
        logger.info("[FILIBUSTER-CORE]: executedRPCs called");
        if (this.currentConcreteTestExecution == null) {
            return null;
        }
        Map<DistributedExecutionIndex, JSONObject> result = this.currentConcreteTestExecution.getExecutedRpcs();
        logger.info("[FILIBUSTER-CORE]: executedRPCs returning: " + result);
        return result;
    }

    @Nullable
    public synchronized Map<DistributedExecutionIndex, JSONObject> failedRpcs() {
        logger.info("[FILIBUSTER-CORE]: failedRPCs called");
        if (this.currentConcreteTestExecution == null) {
            return null;
        }
        Map<DistributedExecutionIndex, JSONObject> result = this.currentConcreteTestExecution.getFailedRpcs();
        logger.info("[FILIBUSTER-CORE]: failedRPCs returning: " + result);
        return result;
    }

    public synchronized boolean wasFaultInjected() {
        logger.info("[FILIBUSTER-CORE]: wasFaultInjected called");
        if (this.currentConcreteTestExecution == null) {
            return false;
        }
        boolean result = this.currentConcreteTestExecution.wasFaultInjected();
        logger.info("[FILIBUSTER-CORE]: wasFaultInjected returning: " + result);
        return result;
    }

    public synchronized boolean wasFaultInjectedOnService(String serviceName) {
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnService called, serviceName: " + serviceName);
        if (this.currentConcreteTestExecution == null) {
            return false;
        }
        boolean result = this.currentConcreteTestExecution.wasFaultInjectedOnService(serviceName);
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnService returning: " + result);
        return result;
    }

    public synchronized boolean wasFaultInjectedOnHttpMethod(HttpMethod httpMethod, String uriPattern) {
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnHttpMethod called, httpMethod: " + httpMethod + ", uriPattern: " + uriPattern);
        if (this.currentConcreteTestExecution == null) {
            return false;
        }
        boolean result = this.currentConcreteTestExecution.wasFaultInjectedOnHttpMethod(httpMethod, uriPattern);
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnHttpMethod returning: " + result);
        return result;
    }

    public synchronized boolean wasFaultInjectedOnMethod(String serviceName, String methodName) {
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnMethod called, serviceName: " + serviceName + ", methodName: " + methodName);
        if (this.currentConcreteTestExecution == null) {
            return false;
        }
        boolean result = this.currentConcreteTestExecution.wasFaultInjectedOnMethod(serviceName, methodName);
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnMethod returning: " + result);
        return result;
    }

    public synchronized boolean wasFaultInjectedOnHttpRequest(HttpMethod httpMethod, String uriPattern, String serializedRequestPattern) {
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnHttpRequest called, httpMethod: " + httpMethod + ", uriPattern: " + uriPattern + ", serializedRequestPattern: " + serializedRequestPattern);
        if (this.currentConcreteTestExecution == null) {
            return false;
        }
        boolean result = this.currentConcreteTestExecution.wasFaultInjectedOnHttpRequest(httpMethod, uriPattern, serializedRequestPattern);
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnHttpRequest returning: " + result);
        return result;
    }

    public synchronized boolean wasFaultInjectedOnRequest(String serializedRequest) {
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnRequest called, serializedRequest: " + serializedRequest);
        if (this.currentConcreteTestExecution == null) {
            return false;
        }
        boolean result = this.currentConcreteTestExecution.wasFaultInjectedOnRequest(serializedRequest);
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnRequest returning: " + result);
        return result;
    }

    public synchronized boolean wasFaultInjectedOnMethodWhereRequestContains(String serviceName, String methodName, String contains) {
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnMethodWherePayloadContains called, serviceName: " + serviceName + ", methodName: " + methodName + ", contains: " + contains);
        if (this.currentConcreteTestExecution == null) {
            return false;
        }
        boolean result = this.currentConcreteTestExecution.wasFaultInjectedOnMethodWhereRequestContains(serviceName, methodName, contains);
        logger.info("[FILIBUSTER-CORE]: wasFaultInjectedOnMethodWherePayloadContains returning: " + result);
        return result;
    }

    public synchronized void terminateFilibuster() {
        logger.info("[FILIBUSTER-CORE]: terminate called.");
        if (this.testReport != null) {
            this.testReport.setIterationsRemaining(this.iterationsRemaining());
            this.testReport.setNumBypassedExecutions(this.getNumBypassedExecutions());
            this.testReport.writeTestReport();
            if (Property.getReportsTestSuiteReportEnabledProperty()) {
                TestSuiteReport.getInstance().addTestReport(this.testReport);
            }
        }
        ServerInvocationAndResponseReport.writeServerInvocationReport();
        ServerInvocationAndResponseReport.writeServiceProfile();
        logger.info("[FILIBUSTER-CORE]: terminate returning.");
    }

    public synchronized void analysisFile(JSONObject analysisFile) {
        logger.info("[FILIBUSTER-CORE]: analysisFile called, payload: " + analysisFile.toString(4));
        FilibusterCustomAnalysisConfigurationFile.Builder filibusterCustomAnalysisConfigurationFileBuilder = new FilibusterCustomAnalysisConfigurationFile.Builder();
        for (String name : analysisFile.keySet()) {
            JSONObject errorObject;
            Object obj;
            JSONArray jsonArray;
            String sRpcType;
            Object rpcType;
            FilibusterAnalysisConfiguration.Builder filibusterAnalysisConfigurationBuilder = new FilibusterAnalysisConfiguration.Builder();
            filibusterAnalysisConfigurationBuilder.name(name);
            JSONObject nameObject = analysisFile.getJSONObject(name);
            if (nameObject.has("pattern")) {
                filibusterAnalysisConfigurationBuilder.pattern(nameObject.getString("pattern"));
            }
            if (nameObject.has("rpc_type") && (rpcType = FilibusterCore.toRpcType(sRpcType = nameObject.getString("rpc_type"))) != null) {
                filibusterAnalysisConfigurationBuilder.rpcType((RpcType)((Object)rpcType));
            }
            if (nameObject.has("latencies")) {
                jsonArray = nameObject.getJSONArray("latencies");
                rpcType = jsonArray.iterator();
                while (rpcType.hasNext()) {
                    obj = rpcType.next();
                    JSONObject latencyObject = (JSONObject)obj;
                    FilibusterAnalysisConfiguration.MatcherType matcherType = FilibusterAnalysisConfiguration.MatcherType.valueOf(latencyObject.getString("type"));
                    String matcher = latencyObject.getString("matcher");
                    int milliseconds = latencyObject.getInt("milliseconds");
                    filibusterAnalysisConfigurationBuilder.latency(matcherType, matcher, milliseconds);
                    logger.info("[FILIBUSTER-CORE]: analysisFile, found new configuration, matcherType: " + (Object)((Object)matcherType) + ", matcher: " + matcher + ", milliseconds: " + milliseconds);
                }
            }
            if (nameObject.has("exceptions")) {
                jsonArray = nameObject.getJSONArray("exceptions");
                rpcType = jsonArray.iterator();
                while (rpcType.hasNext()) {
                    obj = rpcType.next();
                    JSONObject exceptionObject = (JSONObject)obj;
                    String exceptionName = exceptionObject.getString("name");
                    JSONObject exceptionMetadata = exceptionObject.getJSONObject("metadata");
                    HashMap<String, String> exceptionMetadataMap = new HashMap<String, String>();
                    for (String metadataObjectKey : exceptionMetadata.keySet()) {
                        exceptionMetadataMap.put(metadataObjectKey, exceptionMetadata.getString(metadataObjectKey));
                    }
                    filibusterAnalysisConfigurationBuilder.exception(exceptionName, exceptionMetadataMap);
                    logger.info("[FILIBUSTER-CORE]: analysisFile, found new configuration, exceptionName: " + exceptionName + ", exceptionMetadataMap: " + exceptionMetadataMap);
                }
            }
            if (nameObject.has("errors")) {
                jsonArray = nameObject.getJSONArray("errors");
                rpcType = jsonArray.iterator();
                while (rpcType.hasNext()) {
                    obj = rpcType.next();
                    errorObject = (JSONObject)obj;
                    String errorServiceName = errorObject.getString("service_name");
                    JSONArray errorTypes = errorObject.getJSONArray("types");
                    ArrayList<JSONObject> errorTypesList = new ArrayList<JSONObject>();
                    for (Object errorType : errorTypes) {
                        errorTypesList.add((JSONObject)errorType);
                    }
                    filibusterAnalysisConfigurationBuilder.error(errorServiceName, errorTypesList);
                    logger.info("[FILIBUSTER-CORE]: analysisFile, found new configuration, errorServiceName: " + errorServiceName + ", errorTypesList: " + errorTypesList);
                }
            }
            if (nameObject.has("transformers")) {
                jsonArray = nameObject.getJSONArray("transformers");
                try {
                    rpcType = jsonArray.iterator();
                    while (rpcType.hasNext()) {
                        obj = rpcType.next();
                        errorObject = (JSONObject)obj;
                        if (errorObject.has("transformerClassName")) {
                            String transformerClassName = errorObject.getString("transformerClassName");
                            try {
                                Class<?> transformerClass = Class.forName(transformerClassName);
                                filibusterAnalysisConfigurationBuilder.transformer(transformerClass);
                            }
                            catch (ClassNotFoundException e) {
                                logger.warning("[FILIBUSTER-CORE]: analysisFile/transformers: Could not find transformer class: " + transformerClassName);
                                throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: analysisFile/transformers, could not find transformer class: " + transformerClassName, e);
                            }
                            logger.info("[FILIBUSTER-CORE]: analysisFile/transformers, found new configuration, transformerClassName: " + transformerClassName);
                            continue;
                        }
                        logger.warning("[FILIBUSTER-CORE]: analysisFile/transformers: Either the key 'transformer', 'transformerClassName' does not exist.");
                        throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: analysisFile/transformers, either the key 'transformer', 'transformerClassName' does not exist.");
                    }
                }
                catch (RuntimeException e) {
                    logger.warning("[FILIBUSTER-CORE]: analysisFile, could not process transformer fault object.");
                    throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: analysisFile, could not process transformer fault object.", e);
                }
            }
            FilibusterAnalysisConfiguration filibusterAnalysisConfiguration = filibusterAnalysisConfigurationBuilder.build();
            filibusterCustomAnalysisConfigurationFileBuilder.analysisConfiguration(filibusterAnalysisConfiguration);
        }
        this.filibusterCustomAnalysisConfigurationFile = filibusterCustomAnalysisConfigurationFileBuilder.build();
        logger.info("[FILIBUSTER-CORE]: analysisFile, set instance variable, returning.");
    }

    private static boolean matchesFaultInjectionPattern(FilibusterAnalysisConfiguration filibusterAnalysisConfiguration, RpcType rpcType, String moduleName, String methodName) {
        boolean patternMatchFound;
        boolean matchesMethodName = filibusterAnalysisConfiguration.isPatternMatch(methodName);
        boolean matchesModuleAndMethodName = filibusterAnalysisConfiguration.isPatternMatch(moduleName + "." + methodName);
        boolean bl = patternMatchFound = matchesMethodName || matchesModuleAndMethodName;
        if (rpcType == null) {
            if (filibusterAnalysisConfiguration.hasRpcType()) {
                return false;
            }
            return patternMatchFound;
        }
        boolean isTypeMatch = filibusterAnalysisConfiguration.isRpcTypeMatch(rpcType);
        return patternMatchFound && isTypeMatch;
    }

    private void generateFaultsUsingSpecificAnalysisConfiguration(FilibusterCustomAnalysisConfigurationFile customAnalysisConfigurationFile, DistributedExecutionIndex distributedExecutionIndex, RpcType rpcType, String moduleName, String methodName) {
        FilibusterFaultInjectionFilter filibusterFaultInjectionFilter;
        logger.info("[FILIBUSTER-CORE]: generateFaultsUsingSpecificAnalysisConfiguration called.");
        Class<? extends FilibusterFaultInjectionFilter> filibusterFaultInjectionFilterClass = this.filibusterConfiguration.getFaultInjectionFilter();
        try {
            filibusterFaultInjectionFilter = filibusterFaultInjectionFilterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FilibusterRuntimeException(e);
        }
        if (customAnalysisConfigurationFile != null) {
            for (FilibusterAnalysisConfiguration filibusterAnalysisConfiguration : customAnalysisConfigurationFile.getFilibusterAnalysisConfigurations()) {
                Matcher matcher;
                Pattern faultServiceNamePattern;
                if (!FilibusterCore.matchesFaultInjectionPattern(filibusterAnalysisConfiguration, rpcType, moduleName, methodName)) continue;
                List<JSONObject> latencyFaultObjects = filibusterAnalysisConfiguration.getLatencyFaultObjects();
                for (JSONObject jSONObject : latencyFaultObjects) {
                    JSONObject latencyObject = jSONObject.getJSONObject("latency");
                    String latencyObjectMatcherType = latencyObject.getString("type");
                    FilibusterAnalysisConfiguration.MatcherType matcherType = FilibusterAnalysisConfiguration.MatcherType.valueOf(latencyObjectMatcherType);
                    String latencyObjectMatcher = latencyObject.getString("matcher");
                    faultServiceNamePattern = Pattern.compile(latencyObjectMatcher, 2);
                    switch (matcherType) {
                        case SERVICE: {
                            matcher = faultServiceNamePattern.matcher(moduleName);
                            break;
                        }
                        case METHOD: {
                            matcher = faultServiceNamePattern.matcher(methodName);
                            break;
                        }
                        default: {
                            throw new FilibusterFaultInjectionException("Unknown latency injection type: " + (Object)((Object)matcherType));
                        }
                    }
                    if (!matcher.find()) continue;
                    this.createAndScheduleAbstractTestExecution(this.filibusterConfiguration, distributedExecutionIndex, jSONObject);
                }
                List<JSONObject> exceptionFaultObjects = filibusterAnalysisConfiguration.getExceptionFaultObjects();
                for (JSONObject faultObject3 : exceptionFaultObjects) {
                    if (!filibusterFaultInjectionFilter.shouldInjectFault(methodName)) continue;
                    this.createAndScheduleAbstractTestExecution(this.filibusterConfiguration, distributedExecutionIndex, faultObject3);
                }
                List<JSONObject> list = filibusterAnalysisConfiguration.getErrorFaultObjects();
                for (JSONObject faultObject4 : list) {
                    JSONObject failureMetadataObject = faultObject4.getJSONObject("failure_metadata");
                    String faultServiceName = failureMetadataObject.getString("service_name");
                    faultServiceNamePattern = Pattern.compile(faultServiceName, 2);
                    matcher = faultServiceNamePattern.matcher(moduleName);
                    List faultTypesArray = failureMetadataObject.getJSONArray("types").toList();
                    if (!matcher.find()) continue;
                    for (Object obj : faultTypesArray) {
                        HashMap faultTypeMap = (HashMap)obj;
                        JSONObject faultTypeObject = new JSONObject();
                        faultTypeObject.put("failure_metadata", (Map)faultTypeMap);
                        this.createAndScheduleAbstractTestExecution(this.filibusterConfiguration, distributedExecutionIndex, faultTypeObject);
                    }
                }
            }
        }
        logger.info("[FILIBUSTER-CORE]: generateFaultsUsingSpecificAnalysisConfiguration returning.");
    }

    private void generateFaultsUsingAnalysisConfiguration(FilibusterConfiguration filibusterConfiguration, DistributedExecutionIndex distributedExecutionIndex, RpcType rpcType, String moduleName, String methodName) {
        List<ServiceProfile> serviceProfiles;
        logger.info("[FILIBUSTER-CORE]: generateFaultsUsingAnalysisConfiguration called.");
        ArrayList<FilibusterCustomAnalysisConfigurationFile> customAnalysisConfigurationFiles = new ArrayList<FilibusterCustomAnalysisConfigurationFile>();
        if (filibusterConfiguration.getServiceProfileBehavior().equals((Object)ServiceProfileBehavior.FAULT) && (serviceProfiles = filibusterConfiguration.getServiceProfiles()) != null) {
            for (ServiceProfile serviceProfile : serviceProfiles) {
                if (!serviceProfile.sawMethod(methodName)) continue;
                FilibusterAnalysisConfiguration.Builder filibusterAnalysisConfigurationBuilder = new FilibusterAnalysisConfiguration.Builder().name("java.grpc." + methodName).pattern("(" + methodName + ")").rpcType(RpcType.GRPC);
                List<ServiceRequestAndResponse> serviceRequestAndResponseList = serviceProfile.getServiceRequestAndResponsesForMethod(methodName);
                if (serviceRequestAndResponseList != null) {
                    for (ServiceRequestAndResponse serviceRequestAndResponse : serviceRequestAndResponseList) {
                        if (serviceRequestAndResponse.isSuccess()) continue;
                        Status status = serviceRequestAndResponse.getStatus();
                        Status.Code code = status.getCode();
                        String description = status.getDescription();
                        HashMap<String, String> errorMap = new HashMap<String, String>();
                        errorMap.put("cause", "");
                        errorMap.put("code", code.toString());
                        errorMap.put("description", description);
                        filibusterAnalysisConfigurationBuilder.exception("io.grpc.StatusRuntimeException", errorMap);
                    }
                }
                FilibusterAnalysisConfiguration filibusterAnalysisConfiguration = filibusterAnalysisConfigurationBuilder.build();
                FilibusterCustomAnalysisConfigurationFile filibusterServiceProfileConfigurationFile = new FilibusterCustomAnalysisConfigurationFile.Builder().analysisConfiguration(filibusterAnalysisConfiguration).build();
                customAnalysisConfigurationFiles.add(filibusterServiceProfileConfigurationFile);
            }
        }
        customAnalysisConfigurationFiles.add(this.filibusterCustomAnalysisConfigurationFile);
        for (FilibusterCustomAnalysisConfigurationFile customAnalysisConfigurationFile : customAnalysisConfigurationFiles) {
            this.generateFaultsUsingSpecificAnalysisConfiguration(customAnalysisConfigurationFile, distributedExecutionIndex, rpcType, moduleName, methodName);
        }
        logger.info("[FILIBUSTER-CORE]: generateFaultsUsingAnalysisConfiguration returning.");
    }

    private void createAndScheduleAbstractTestExecution(FilibusterConfiguration filibusterConfiguration, DistributedExecutionIndex distributedExecutionIndex, JSONObject faultObject) {
        logger.info("[FILIBUSTER-CORE]: createAndScheduleAbstractTestExecution called.");
        if (this.currentConcreteTestExecution != null) {
            boolean abstractIsCurrentExecution;
            AbstractTestExecution abstractTestExecution = this.currentConcreteTestExecution.toAbstractTestExecution();
            abstractTestExecution.addFaultToInject(distributedExecutionIndex, faultObject);
            boolean abstractIsExploredExecution = this.exploredTestExecutions.containsAbstractTestExecution(abstractTestExecution);
            boolean abstractIsScheduledExecution = this.unexploredTestExecutions.containsAbstractTestExecution(abstractTestExecution);
            boolean bl = abstractIsCurrentExecution = this.currentAbstractTestExecution != null && this.currentAbstractTestExecution.matchesAbstractTestExecution(abstractTestExecution);
            if (!(abstractIsExploredExecution || abstractIsScheduledExecution || abstractIsCurrentExecution)) {
                if (filibusterConfiguration.getSuppressCombinations()) {
                    if (abstractTestExecution.getFaultsToInjectSize() <= 1) {
                        this.unexploredTestExecutions.addTestExecution(abstractTestExecution);
                        logger.info("[FILIBUSTER-CORE]: createAndScheduleAbstractTestExecution, adding new execution to the queue.");
                    } else {
                        logger.info("[FILIBUSTER-CORE]: createAndScheduleAbstractTestExecution, not scheduling test execution because it contains > 1 fault.");
                    }
                } else {
                    logger.info("[FILIBUSTER-CORE]: createAndScheduleAbstractTestExecution, adding new execution to the queue.");
                    this.unexploredTestExecutions.addTestExecution(abstractTestExecution);
                }
            }
        }
        logger.info("[FILIBUSTER-CORE]: createAndScheduleAbstractTestExecution returning.");
    }

    private void printSummary() {
        logger.info("\n[FILIBUSTER-CORE]: Filibuster In-Progress Summary\n\n[FILIBUSTER-CORE]: Queue Statistics: \n[FILIBUSTER-CORE]: * unexploredTestExecutions.size():           " + this.unexploredTestExecutions.size() + "\n[FILIBUSTER-CORE]: * exploredTestExecutions.size():             " + this.exploredTestExecutions.size() + " (+1, =" + (this.exploredTestExecutions.size() + 1) + ")\n\n[FILIBUSTER-CORE]: Test Summary: \n[FILIBUSTER-CORE]: * numberOfAbstractExecutionsAttempted:       " + this.numberOfAbstractExecutionsAttempted + (this.currentAbstractTestExecution == null ? "" : " (+1, =" + (this.numberOfAbstractExecutionsAttempted + 1) + ")") + "\n[FILIBUSTER-CORE]: * numberOfAbstractExecutionsExecuted:        " + this.numberOfAbstractExecutionsExecuted + (this.currentAbstractTestExecution == null ? "" : " (+1, =" + (this.numberOfAbstractExecutionsExecuted + 1) + ")") + "\n[FILIBUSTER-CORE]: * numberOfConcreteExecutionsExecuted:        " + this.numberOfConcreteExecutionsExecuted + " (+1, =" + (this.numberOfConcreteExecutionsExecuted + 1) + ")\n");
    }

    @Nullable
    private static RpcType toRpcType(String sRpcType) {
        if (!sRpcType.equals("")) {
            try {
                return RpcType.valueOf(sRpcType);
            }
            catch (IllegalArgumentException iae) {
                throw new FilibusterCoreLogicException("could not figure out the rpc type: " + sRpcType + ", " + iae);
            }
        }
        return null;
    }
}

