/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core;

import cloud.filibuster.exceptions.filibuster.FilibusterFaultInjectionException;
import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import cloud.filibuster.junit.server.core.transformers.selector.GatewayTransformer;
import com.google.gson.Gson;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.json.JSONObject;

public final class FilibusterCoreTransformerExtension {
    private static final Logger logger = Logger.getLogger(FilibusterCoreTransformerExtension.class.getName());

    public static <PAYLOAD, CONTEXT> Transformer<PAYLOAD, CONTEXT> getTransformerResult(@Nonnull JSONObject transformer) {
        try {
            if (transformer.has("accumulator") && transformer.has("transformerClassName")) {
                Transformer<?, ?> transformerObject = FilibusterCoreTransformerExtension.getTransformerInstance(transformer.getString("transformerClassName"));
                Method transformMethod = transformerObject.getClass().getMethod("transform", (Class)transformerObject.getPayloadType(), Accumulator.class);
                Type accumulatorType = transformerObject.getAccumulatorType();
                Accumulator accumulator = (Accumulator)new Gson().fromJson(String.valueOf(transformer.get("accumulator")), accumulatorType);
                Object referenceValue = ((Class)transformerObject.getPayloadType()).cast(accumulator.getReferenceValue());
                Transformer transformationResult = (Transformer)transformMethod.invoke(transformerObject, referenceValue, accumulator);
                return transformationResult;
            }
            logger.warning("[FILIBUSTER-CORE]: getTransformerResult, transformer is missing required keys, either 'accumulator', 'referenceValue' or 'transformerClassName'.");
            throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: getTransformerResult, transformer is missing required keys, either 'accumulator', 'referenceValue' or 'transformerClassName': " + transformer);
        }
        catch (Exception e) {
            logger.warning("[FILIBUSTER-CORE]: getTransformerResult, an exception occurred: " + e);
            throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: getTransformerResult, an exception occurred: " + e);
        }
    }

    public static void setNextAccumulator(JSONObject transformer, Accumulator<?, ?> accumulator) {
        if (transformer.has("transformerClassName")) {
            Transformer<?, ?> transformerObject = FilibusterCoreTransformerExtension.getTransformerInstance(transformer.getString("transformerClassName"));
            Type accumulatorType = transformerObject.getAccumulatorType();
            transformer.put("accumulator", (Object)new Gson().toJson(accumulator, accumulatorType));
        }
    }

    public static void generateAndSetTransformerValue(JSONObject transformer) {
        Transformer transformerResult = FilibusterCoreTransformerExtension.getTransformerResult(transformer);
        Object result = transformerResult.getResult();
        FilibusterCoreTransformerExtension.setTransformerValue(transformer, result);
    }

    public static void setTransformerValue(JSONObject transformer, Object value) {
        if (value == null) {
            transformer.put("value", JSONObject.NULL);
        } else {
            transformer.put("value", value);
        }
    }

    public static JSONObject handleGatewayTransformer(JSONObject transformer, String referenceValue, String referenceValueType) {
        JSONObject transformerFault = transformer.getJSONObject("transformer_fault");
        if (transformerFault.has("transformerClassName") && transformerFault.getString("transformerClassName").equals(GatewayTransformer.class.getName())) {
            JSONObject newTransformer = new JSONObject(transformer.toMap());
            String transformerClassName = GatewayTransformer.getTransformerClassNameFromReferenceValue(referenceValueType, referenceValue);
            newTransformer.getJSONObject("transformer_fault").put("transformerClassName", (Object)transformerClassName);
            return newTransformer;
        }
        return transformer;
    }

    public static Accumulator<?, ?> getInitialAccumulator(JSONObject transformer, String referenceValue) {
        if (transformer.has("transformerClassName")) {
            String transformerClassName = transformer.getString("transformerClassName");
            Transformer<?, ?> transformerObject = FilibusterCoreTransformerExtension.getTransformerInstance(transformerClassName);
            return transformerObject.getInitialAccumulator(new Gson().fromJson(referenceValue, transformerObject.getPayloadType()));
        }
        throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: getInitialAccumulator, transformerClassName not found in transformer: " + transformer.toString(4));
    }

    public static Transformer<?, ?> getTransformerInstance(String transformerClassName) {
        try {
            Class<?> transformerClass = Class.forName(transformerClassName);
            Constructor<?> ctr = transformerClass.getConstructor(new Class[0]);
            return (Transformer)ctr.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warning("[FILIBUSTER-CORE]: getTransformerInstance, an exception occurred in getTransformerInstance: " + e);
            throw new FilibusterFaultInjectionException("[FILIBUSTER-CORE]: getTransformerInstance, an exception occurred in getTransformerInstance: " + e);
        }
    }
}

