/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.instrumentation.datatypes.Pair;
import cloud.filibuster.junit.server.core.lint.analyzers.LCS;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.TestExecutionReportAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.warnings.MultipleInvocationsForIndividualMutationsWarning;
import cloud.filibuster.junit.server.core.reports.TestExecutionReport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class MultipleInvocationsForIndividualMutationsAnalyzer
extends TestExecutionReportAnalyzer {
    private final List<Map.Entry<Integer, Map.Entry<DistributedExecutionIndex, JSONObject>>> previousRpcInvocations = new ArrayList<Map.Entry<Integer, Map.Entry<DistributedExecutionIndex, JSONObject>>>();
    private static final int threshold = 10;

    public MultipleInvocationsForIndividualMutationsAnalyzer(TestExecutionReport testExecutionReport) {
        super(testExecutionReport);
    }

    @Override
    void rpc(boolean testPassed, int RPC, DistributedExecutionIndex distributedExecutionIndex, JSONObject invocation, JSONObject fault, JSONObject response) {
        for (Map.Entry<Integer, Map.Entry<DistributedExecutionIndex, JSONObject>> previousInvocation : this.previousRpcInvocations) {
            int previousResponseInvocationNumber = previousInvocation.getKey();
            DistributedExecutionIndex previousDistributedExecutionIndex = previousInvocation.getValue().getKey();
            JSONObject previousInvocationObject = previousInvocation.getValue().getValue();
            String lcs = LCS.computeLcs(invocation.getJSONObject("args").getString("toString"), previousInvocationObject.getJSONObject("args").getString("toString"));
            String previousRequestInvocationMethod = previousInvocationObject.getString("method");
            boolean lcsAboveThreshold = lcs.length() >= 10;
            boolean previousInvocationDirectlyBeforeRpc = previousResponseInvocationNumber + 1 == RPC;
            boolean sameMethodAsTarget = previousInvocationObject.getString("method").equals(invocation.getString("method"));
            boolean sameArguments = previousInvocationObject.getJSONObject("args").similar((Object)invocation.getJSONObject("args"));
            if (!lcsAboveThreshold || !previousInvocationDirectlyBeforeRpc || !sameMethodAsTarget || sameArguments) continue;
            this.addWarning(new MultipleInvocationsForIndividualMutationsWarning(distributedExecutionIndex, "The following string (" + lcs + ") was used in a request to " + previousRequestInvocationMethod + " and used again to the same method in this test execution."));
        }
        this.previousRpcInvocations.add(Pair.of(RPC, Pair.of(distributedExecutionIndex, invocation)));
    }
}

