/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.exceptions.filibuster.FilibusterAnalysisFailureException;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.TestExecutionReportAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.warnings.RedundantRPCWarning;
import cloud.filibuster.junit.server.core.reports.TestExecutionReport;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class RedundantRPCAnalyzer
extends TestExecutionReportAnalyzer {
    private final TestExecutionReport testExecutionReport;
    private final List<String> seenRpcs = new ArrayList<String>();

    public RedundantRPCAnalyzer(TestExecutionReport testExecutionReport) {
        super(testExecutionReport);
        this.testExecutionReport = testExecutionReport;
    }

    @Override
    void rpc(boolean testPassed, int RPC, DistributedExecutionIndex distributedExecutionIndex, JSONObject invocation, JSONObject fault, JSONObject response) {
        String deiKey = distributedExecutionIndex.projectionLastKeyWithOnlyMetadataAndSignature();
        JSONObject invocationArgsObject = invocation.getJSONObject("args");
        String invocationArgs = invocationArgsObject.getString("toString");
        String responseToEncode = "";
        if (response != null) {
            if (response.has("return_value")) {
                responseToEncode = response.getJSONObject("return_value").toString();
            } else if (response.has("exception")) {
                responseToEncode = response.getJSONObject("exception").toString();
            } else if (response.has("transformer_fault")) {
                responseToEncode = response.getJSONObject("transformer_fault").toString();
            } else {
                throw new FilibusterAnalysisFailureException("Response did not contain either a return value or an exception.");
            }
            String key = deiKey + invocationArgs + responseToEncode;
            String method = invocation.getString("method");
            if (this.seenRpcs.contains(key)) {
                if (Property.getTestAvoidRedundantInjectionsProperty()) {
                    List<DistributedExecutionIndex> cachedRpcs = this.testExecutionReport.getCachedRpcs();
                    if (!cachedRpcs.contains(distributedExecutionIndex)) {
                        this.addWarning(new RedundantRPCWarning(distributedExecutionIndex, method));
                    }
                } else {
                    this.addWarning(new RedundantRPCWarning(distributedExecutionIndex, method));
                }
            } else {
                this.seenRpcs.add(key);
            }
        }
    }
}

