/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.instrumentation.datatypes.Pair;
import cloud.filibuster.junit.server.core.lint.analyzers.LCS;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.TestExecutionReportAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.warnings.ResponseBecomesRequestWarning;
import cloud.filibuster.junit.server.core.reports.TestExecutionReport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class ResponseBecomesRequestAnalyzer
extends TestExecutionReportAnalyzer {
    private final List<Map.Entry<Integer, Map.Entry<JSONObject, JSONObject>>> previousRpcs = new ArrayList<Map.Entry<Integer, Map.Entry<JSONObject, JSONObject>>>();
    private static final int threshold = 10;

    public ResponseBecomesRequestAnalyzer(TestExecutionReport testExecutionReport) {
        super(testExecutionReport);
    }

    @Override
    void rpc(boolean testPassed, int RPC, DistributedExecutionIndex distributedExecutionIndex, JSONObject invocation, JSONObject fault, JSONObject response) {
        for (Map.Entry<Integer, Map.Entry<JSONObject, JSONObject>> previousRpc : this.previousRpcs) {
            int previousResponseInvocationNumber = previousRpc.getKey();
            JSONObject invocationArgsObject = invocation.getJSONObject("args");
            String invocationArgs = invocationArgsObject.getString("toString");
            JSONObject previousRpcInvocation = previousRpc.getValue().getKey();
            String previousResponseInvocationMethod = previousRpcInvocation.getString("method");
            String currentRequestInvocationMethod = invocation.getString("method");
            JSONObject previousRpcResponseObject = previousRpc.getValue().getValue();
            if (previousRpcResponseObject == null || !previousRpcResponseObject.has("return_value")) continue;
            JSONObject previousResponseObjectReturnValue = previousRpcResponseObject.getJSONObject("return_value");
            String lcs = LCS.computeLcs(invocationArgs, previousResponseObjectReturnValue.toString());
            boolean lcsAboveThreshold = lcs.length() >= 10;
            boolean previousInvocationDirectlyBeforeRpc = previousResponseInvocationNumber + 1 == RPC;
            boolean sameServiceAsTarget = previousRpcInvocation.getString("module").equals(invocation.getString("module"));
            if (!lcsAboveThreshold || !previousInvocationDirectlyBeforeRpc || !sameServiceAsTarget) continue;
            this.addWarning(new ResponseBecomesRequestWarning(distributedExecutionIndex, "The following string (" + lcs + ") used in a request to " + currentRequestInvocationMethod + " was found in a previous response from " + previousResponseInvocationMethod));
        }
        this.previousRpcs.add(Pair.of(RPC, Pair.of(invocation, response)));
    }
}

