/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.exceptions.filibuster.FilibusterAnalysisFailureException;
import cloud.filibuster.junit.server.core.lint.analyzers.warnings.FilibusterAnalyzerWarning;
import cloud.filibuster.junit.server.core.reports.TestExecutionReport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.json.JSONObject;

public abstract class TestExecutionReportAnalyzer {
    private final TestExecutionReport testExecutionReport;
    private final List<FilibusterAnalyzerWarning> warnings = new ArrayList<FilibusterAnalyzerWarning>();

    public TestExecutionReportAnalyzer(TestExecutionReport testExecutionReport) {
        this.testExecutionReport = testExecutionReport;
    }

    abstract void rpc(boolean var1, int var2, DistributedExecutionIndex var3, JSONObject var4, @Nullable JSONObject var5, @Nullable JSONObject var6);

    public List<FilibusterAnalyzerWarning> getWarnings() {
        return this.warnings;
    }

    void addWarning(FilibusterAnalyzerWarning warning) {
        this.warnings.add(warning);
    }

    public List<FilibusterAnalyzerWarning> analyze(boolean testPassed) {
        int i = 0;
        Iterator<DistributedExecutionIndex> it = this.testExecutionReport.getInvocationOrderIterator();
        while (it.hasNext()) {
            DistributedExecutionIndex distributedExecutionIndex = it.next();
            JSONObject invocationObject = this.testExecutionReport.getInvocationObject(distributedExecutionIndex);
            JSONObject faultObject = this.testExecutionReport.getFaultObject(distributedExecutionIndex);
            JSONObject responseObject = this.testExecutionReport.getResponseObject(distributedExecutionIndex);
            try {
                this.rpc(testPassed, i, distributedExecutionIndex, invocationObject, faultObject, responseObject);
            }
            catch (RuntimeException e) {
                throw new FilibusterAnalysisFailureException("Analyzer " + this.getClass() + " failed with exception: " + e);
            }
            ++i;
        }
        return this.getWarnings();
    }
}

