/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.TestExecutionReportAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.warnings.UnimplementedFailuresWarning;
import cloud.filibuster.junit.server.core.reports.TestExecutionReport;
import org.json.JSONObject;

public class UnimplementedFailuresAnalyzer
extends TestExecutionReportAnalyzer {
    public UnimplementedFailuresAnalyzer(TestExecutionReport testExecutionReport) {
        super(testExecutionReport);
    }

    @Override
    void rpc(boolean testPassed, int RPC, DistributedExecutionIndex distributedExecutionIndex, JSONObject invocation, JSONObject fault, JSONObject response) {
        String code;
        JSONObject metadata;
        JSONObject exception;
        if (response != null && response.has("exception") && (exception = response.getJSONObject("exception")).has("metadata") && (metadata = exception.getJSONObject("metadata")).has("code") && (code = metadata.getString("code")).equals("UNIMPLEMENTED")) {
            JSONObject forcedExceptionMetadata;
            String faultCode;
            JSONObject forcedException;
            String method = invocation.getString("method");
            boolean injectedUnimplementedFault = false;
            if (fault != null && fault.has("forced_exception") && (forcedException = fault.getJSONObject("forced_exception")).has("metadata") && (faultCode = (forcedExceptionMetadata = forcedException.getJSONObject("metadata")).getString("code")).equals(code)) {
                injectedUnimplementedFault = true;
            }
            if (!injectedUnimplementedFault && testPassed) {
                this.addWarning(new UnimplementedFailuresWarning(distributedExecutionIndex, method));
            }
        }
    }
}

