/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.profiles;

import cloud.filibuster.exceptions.filibuster.FilibusterServiceProfileReaderException;
import cloud.filibuster.exceptions.filibuster.FilibusterServiceProfileWriterException;
import cloud.filibuster.junit.server.core.profiles.ServiceRequestAndResponse;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;

public class ServiceProfile {
    private final HashMap<String, List<ServiceRequestAndResponse>> profile = new HashMap();

    public boolean sawMethod(String method) {
        return this.profile.containsKey(method);
    }

    public List<String> seenMethods() {
        return new ArrayList<String>(this.profile.keySet());
    }

    @Nullable
    public List<ServiceRequestAndResponse> getServiceRequestAndResponsesForMethod(String method) {
        if (!this.sawMethod(method)) {
            return null;
        }
        return this.profile.get(method);
    }

    public void addToProfile(String method, GeneratedMessageV3 request, Status status, @Nullable GeneratedMessageV3 response) {
        ServiceRequestAndResponse serviceRequestAndResponse = new ServiceRequestAndResponse(request, status, response);
        this.addToProfile(method, serviceRequestAndResponse);
    }

    private void addToProfile(String method, ServiceRequestAndResponse serviceRequestAndResponse) {
        if (!this.profile.containsKey(method)) {
            this.profile.put(method, new ArrayList());
        }
        this.profile.get(method).add(serviceRequestAndResponse);
    }

    public JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, List<ServiceRequestAndResponse>> entry : this.profile.entrySet()) {
            ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
            for (ServiceRequestAndResponse srr : entry.getValue()) {
                jsonObjectList.add(srr.toJsonObject());
            }
            jsonObject.put(entry.getKey(), jsonObjectList);
        }
        return jsonObject;
    }

    public static ServiceProfile fromJsonObject(JSONObject jsonObject) {
        ServiceProfile serviceProfile = new ServiceProfile();
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            JSONArray jsonArray = jsonObject.getJSONArray(key);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                ServiceRequestAndResponse srr = ServiceRequestAndResponse.fromJsonObject(obj);
                serviceProfile.addToProfile(key, srr);
            }
        }
        return serviceProfile;
    }

    public void writeServiceProfile() {
        Path rootDirectory = Paths.get("/tmp/filibuster", new String[0]);
        try {
            Files.createDirectory(rootDirectory, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new FilibusterServiceProfileWriterException("Filibuster failed to write out the service profile: ", e);
        }
        Path directory = Paths.get("/tmp/filibuster/fsp", new String[0]);
        try {
            Files.createDirectory(directory, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new FilibusterServiceProfileWriterException("Filibuster failed to write out the service profile: ", e);
        }
        Path fspFile = Paths.get(directory + "/latest.fsp", new String[0]);
        try {
            Files.write(fspFile, this.toJsonObject().toString(4).getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FilibusterServiceProfileWriterException("Filibuster failed to write out the service profile: ", e);
        }
    }

    public static ServiceProfile readServiceProfile(String fileName) {
        try {
            String content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
            JSONObject contentObject = new JSONObject(content);
            ServiceProfile serviceProfile = ServiceProfile.fromJsonObject(contentObject);
            return serviceProfile;
        }
        catch (IOException e) {
            throw new FilibusterServiceProfileReaderException("Filibuster failed to read the service profile at " + fileName, e);
        }
    }

    public static List<ServiceProfile> loadFromDirectory(Path directory) {
        ArrayList<ServiceProfile> serviceProfiles = new ArrayList<ServiceProfile>();
        Iterator it = FileUtils.iterateFiles((File)directory.toFile(), null, (boolean)false);
        while (it.hasNext()) {
            File nextFile = (File)it.next();
            Path nextFilePath = nextFile.toPath();
            if (!Files.isRegularFile(nextFilePath, new LinkOption[0])) continue;
            ServiceProfile serviceProfile = ServiceProfile.loadFromFile(nextFilePath);
            serviceProfiles.add(serviceProfile);
        }
        return serviceProfiles;
    }

    public static ServiceProfile loadFromFile(Path path) {
        try {
            String content = new String(Files.readAllBytes(path), Charset.defaultCharset());
            JSONObject jsonObject = new JSONObject(content);
            return ServiceProfile.fromJsonObject(jsonObject);
        }
        catch (IOException e) {
            throw new FilibusterServiceProfileReaderException("Cannot load service profile from file " + path + ": " + e, e);
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServiceProfile)) {
            return false;
        }
        ServiceProfile sp = (ServiceProfile)o;
        return Objects.equals(this.profile, sp.profile);
    }

    public int hashCode() {
        return Objects.hash(this.profile);
    }
}

