/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.reports;

import cloud.filibuster.junit.server.core.serializers.GeneratedMessageV3Serializer;
import cloud.filibuster.junit.server.core.serializers.StatusSerializer;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class ServerInvocationAndResponse {
    private final String requestId;
    private final String fullMethodName;
    private final GeneratedMessageV3 requestMessage;
    private final Status responseStatus;
    @Nullable
    private final GeneratedMessageV3 responseMessage;

    public ServerInvocationAndResponse(String requestId, String fullMethodName, GeneratedMessageV3 requestMessage, Status responseStatus, GeneratedMessageV3 responseMessage) {
        this.requestId = requestId;
        this.fullMethodName = fullMethodName;
        this.requestMessage = requestMessage;
        this.responseStatus = responseStatus;
        this.responseMessage = responseMessage;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getFullMethodName() {
        return this.fullMethodName;
    }

    public GeneratedMessageV3 getRequestMessage() {
        return this.requestMessage;
    }

    public Status getResponseStatus() {
        return this.responseStatus;
    }

    @Nullable
    public GeneratedMessageV3 getResponseMessage() {
        return this.responseMessage;
    }

    public JSONObject toJsonObject() {
        JSONObject result = new JSONObject();
        result.put("request_id", (Object)this.requestId);
        result.put("method", (Object)this.fullMethodName);
        if (this.requestMessage != null) {
            result.put("request", (Object)GeneratedMessageV3Serializer.toJsonObject(this.requestMessage));
        } else {
            result.put("request", (Object)new JSONObject());
        }
        if (this.responseStatus != null) {
            result.put("status", (Object)StatusSerializer.toJsonObject(this.responseStatus));
        } else {
            result.put("status", (Object)new JSONObject());
        }
        if (this.responseMessage != null) {
            result.put("response", (Object)GeneratedMessageV3Serializer.toJsonObject(this.responseMessage));
        } else {
            result.put("response", (Object)new JSONObject());
        }
        return result;
    }

    static class Keys {
        public static final String REQUEST_ID_KEY = "request_id";
        public static final String METHOD_KEY = "method";
        public static final String REQUEST_KEY = "request";
        public static final String STATUS_KEY = "status";
        public static final String RESPONSE_KEY = "response";

        Keys() {
        }
    }
}

