/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.reports;

import cloud.filibuster.daikon.ppt.DaikonGrpcProgramPointRecord;
import cloud.filibuster.daikon.traces.DaikonGrpcDataTraceRecord;
import cloud.filibuster.exceptions.filibuster.FilibusterDaikonRuntimeException;
import cloud.filibuster.exceptions.filibuster.FilibusterTestReportWriterException;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.server.core.FilibusterCore;
import cloud.filibuster.junit.server.core.profiles.ServiceProfile;
import cloud.filibuster.junit.server.core.reports.ReportUtilities;
import cloud.filibuster.junit.server.core.reports.ServerInvocationAndResponse;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class ServerInvocationAndResponseReport {
    private static final List<Integer> seenCoreHashCodes = new ArrayList<Integer>();
    private static final List<String> grpcMethodsWithWarnings = new ArrayList<String>();
    private static final List<String> grpcMethods = new ArrayList<String>();
    private static final TreeMap<String, Integer> grpcMethodInvokedByTests = new TreeMap();
    private static final TreeMap<String, Integer> grpcMethodInvokedByFilibusterTests = new TreeMap();
    private static final TreeMap<String, Integer> grpcMethodInvokedByUniqueFilibusterTests = new TreeMap();
    private static final List<DaikonGrpcDataTraceRecord> daikonGrpcDataTraceRecords = new ArrayList<DaikonGrpcDataTraceRecord>();
    private static final List<DaikonGrpcProgramPointRecord> daikonGrpcDataDeclRecords = new ArrayList<DaikonGrpcProgramPointRecord>();
    private static final Logger logger = Logger.getLogger(ServerInvocationAndResponseReport.class.getName());
    private static List<ServerInvocationAndResponse> serverInvocationAndResponses = new ArrayList<ServerInvocationAndResponse>();
    private static HashMap<String, GeneratedMessageV3> incompleteServerInvocationAndResponses = new HashMap();

    private static void addGrpcMethod(String grpcMethod) {
        if (!grpcMethods.contains(grpcMethod)) {
            grpcMethods.add(grpcMethod);
            grpcMethodInvokedByTests.put(grpcMethod, 0);
            grpcMethodInvokedByFilibusterTests.put(grpcMethod, 0);
            grpcMethodInvokedByUniqueFilibusterTests.put(grpcMethod, 0);
        }
    }

    private static void incrementGrpcMethodByTestInvocation(String grpcMethod) {
        int currentValue = grpcMethodInvokedByTests.get(grpcMethod);
        grpcMethodInvokedByTests.put(grpcMethod, currentValue + 1);
    }

    private static void incrementGrpcMethodByFilibusterTestInvocation(String grpcMethod) {
        int currentValue = grpcMethodInvokedByFilibusterTests.get(grpcMethod);
        grpcMethodInvokedByFilibusterTests.put(grpcMethod, currentValue + 1);
    }

    private static void incrementGrpcMethodByUniqueFilibusterTestInvocation(String grpcMethod) {
        int currentValue = grpcMethodInvokedByUniqueFilibusterTests.get(grpcMethod);
        grpcMethodInvokedByUniqueFilibusterTests.put(grpcMethod, currentValue + 1);
    }

    public static void loadGrpcEndpoints(Class<?> c) {
        try {
            Method[] methods;
            Field serviceNameField = c.getField("SERVICE_NAME");
            String serviceName = (String)serviceNameField.get(null);
            for (Method method : methods = c.getDeclaredMethods()) {
                Pattern pattern = Pattern.compile("get(.*)Method");
                Matcher matcher = pattern.matcher(method.getName());
                if (!matcher.find()) continue;
                String strippedMethodName = matcher.group(1);
                String fullMethodName = serviceName + "/" + strippedMethodName;
                ServerInvocationAndResponseReport.addGrpcMethod(fullMethodName);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warning("Cannot populate Filibuster server invocation report, cannot determine service name for class " + c.getName() + " : " + e);
        }
    }

    public static void loadGrpcEndpoints(String packageName) {
        Set<Class> allClassesInNamespace = ServerInvocationAndResponseReport.findAllClassesUsingClassLoader(packageName);
        HashSet<Class> grpcClasses = new HashSet<Class>();
        for (Class clazz : allClassesInNamespace) {
            if (!clazz.getName().endsWith("Grpc")) continue;
            grpcClasses.add(clazz);
        }
        for (Class<Object> clazz : grpcClasses) {
            ServerInvocationAndResponseReport.loadGrpcEndpoints(clazz);
        }
    }

    private ServerInvocationAndResponseReport() {
    }

    public static void clear() {
        serverInvocationAndResponses = new ArrayList<ServerInvocationAndResponse>();
        incompleteServerInvocationAndResponses = new HashMap();
    }

    public static void beginServerInvocation(String requestId, GeneratedMessageV3 message) {
        incompleteServerInvocationAndResponses.put(requestId, message);
    }

    public static void endServerInvocation(String requestId, String fullMethodName, Status status, @Nullable GeneratedMessageV3 responseMessage) {
        GeneratedMessageV3 requestMessage = incompleteServerInvocationAndResponses.get(requestId);
        if (responseMessage != null && Property.getDaikonEnabledProperty()) {
            try {
                List<DaikonGrpcDataTraceRecord> traceRecords = DaikonGrpcDataTraceRecord.onRequestAndResponse(fullMethodName, requestMessage, responseMessage);
                daikonGrpcDataTraceRecords.addAll(traceRecords);
                List<DaikonGrpcProgramPointRecord> declRecords = DaikonGrpcProgramPointRecord.onRequestAndResponse(fullMethodName, requestMessage, responseMessage);
                daikonGrpcDataDeclRecords.addAll(declRecords);
            }
            catch (RuntimeException re) {
                throw new FilibusterDaikonRuntimeException("could not generate Daikon trace files due to runtime exception: " + re, re);
            }
        }
        ServerInvocationAndResponse serverInvocationAndResponse = new ServerInvocationAndResponse(requestId, fullMethodName, requestMessage, status, responseMessage);
        serverInvocationAndResponses.add(serverInvocationAndResponse);
        if (!grpcMethods.contains(fullMethodName)) {
            ServerInvocationAndResponseReport.addGrpcMethod(fullMethodName);
            grpcMethodsWithWarnings.add(fullMethodName);
        }
        if (FilibusterCore.hasCurrentInstance()) {
            ServerInvocationAndResponseReport.incrementGrpcMethodByFilibusterTestInvocation(fullMethodName);
            int filibusterCoreHashCode = FilibusterCore.getCurrentInstance().hashCode();
            if (!seenCoreHashCodes.contains(filibusterCoreHashCode)) {
                ServerInvocationAndResponseReport.incrementGrpcMethodByUniqueFilibusterTestInvocation(fullMethodName);
                seenCoreHashCodes.add(FilibusterCore.getCurrentInstance().hashCode());
            }
        } else {
            ServerInvocationAndResponseReport.incrementGrpcMethodByTestInvocation(fullMethodName);
        }
    }

    private static ServiceProfile toServiceProfile() {
        ServiceProfile serviceProfile = new ServiceProfile();
        for (ServerInvocationAndResponse sir : serverInvocationAndResponses) {
            serviceProfile.addToProfile(sir.getFullMethodName(), sir.getRequestMessage(), sir.getResponseStatus(), sir.getResponseMessage());
        }
        return serviceProfile;
    }

    public static void writeServiceProfile() {
        ServerInvocationAndResponseReport.toServiceProfile().writeServiceProfile();
    }

    public static void writeServerInvocationReport() {
        Path reportDirectory = Paths.get("/tmp/filibuster/", new String[0]);
        try {
            Files.createDirectory(reportDirectory, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the server invocation report: ", e);
        }
        Path scriptFile = Paths.get(reportDirectory + "/server.js", new String[0]);
        try {
            Files.write(scriptFile, ServerInvocationAndResponseReport.toJavascript().getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the server invocation report: ", e);
        }
        if (Property.getDaikonEnabledProperty()) {
            try {
                Path daikonDeclsFile = Paths.get(reportDirectory + "/filibuster.decls", new String[0]);
                Files.write(daikonDeclsFile, ServerInvocationAndResponseReport.toDaikonDecls().getBytes(Charset.defaultCharset()), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new FilibusterTestReportWriterException("Filibuster failed to write out the server invocation report: ", e);
            }
            try {
                Path daikonTraceFile = Paths.get(reportDirectory + "/filibuster.dtrace", new String[0]);
                Files.write(daikonTraceFile, ServerInvocationAndResponseReport.toDaikonTrace().getBytes(Charset.defaultCharset()), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new FilibusterTestReportWriterException("Filibuster failed to write out the server invocation report: ", e);
            }
        }
        Path indexPath = Paths.get(reportDirectory + "/server.html", new String[0]);
        byte[] indexBytes = ReportUtilities.getResourceAsBytes(ServerInvocationAndResponseReport.class.getClassLoader(), "html/server_invocation_report/index.html");
        try {
            Files.write(indexPath, indexBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the server invocation report: ", e);
        }
        logger.info("\n[FILIBUSTER-CORE]: Server Invocation Reports written to file://" + indexPath + "\n");
    }

    private static JSONObject toServerInvocationReportJsonObject() {
        JSONObject result = new JSONObject();
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        for (ServerInvocationAndResponse sir : serverInvocationAndResponses) {
            results.add(sir.toJsonObject());
        }
        result.put("results", results);
        return result;
    }

    private static JSONObject toAccessedGrpcEndpointsJsonObject() {
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (String methodName : grpcMethods) {
            JSONObject methodJsonObject = new JSONObject();
            methodJsonObject.put("method", (Object)methodName);
            methodJsonObject.put("tests", (Object)grpcMethodInvokedByTests.get(methodName));
            methodJsonObject.put("filibuster_tests", (Object)grpcMethodInvokedByUniqueFilibusterTests.get(methodName));
            methodJsonObject.put("filibuster_executions", (Object)grpcMethodInvokedByFilibusterTests.get(methodName));
            if (grpcMethodsWithWarnings.contains(methodName)) {
                methodJsonObject.put("warning", true);
            } else {
                methodJsonObject.put("warning", false);
            }
            logger.log(Level.SEVERE, methodJsonObject.toString(4));
            jsonObjects.add(methodJsonObject);
        }
        jsonObject.put("methods", jsonObjects);
        return jsonObject;
    }

    private static String toJavascript() {
        String output = "";
        output = output + "var serverInvocationReports = " + ServerInvocationAndResponseReport.toServerInvocationReportJsonObject().toString(4) + ";\n";
        output = output + "var accessedGrpcEndpoints = " + ServerInvocationAndResponseReport.toAccessedGrpcEndpointsJsonObject().toString(4) + ";\n";
        return output;
    }

    private static String toDaikonTrace() {
        StringBuilder builder = new StringBuilder();
        for (DaikonGrpcDataTraceRecord record : daikonGrpcDataTraceRecords) {
            builder.append(record.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    private static String toDaikonDecls() {
        StringBuilder builder = new StringBuilder();
        builder.append("decl-version 2.0\n");
        builder.append("\n");
        for (DaikonGrpcProgramPointRecord record : daikonGrpcDataDeclRecords) {
            builder.append(record.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public static Set<Class> findAllClassesUsingClassLoader(String packageName) {
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        return reader.lines().filter(line -> line.endsWith(".class")).map(line -> ServerInvocationAndResponseReport.getClass(line, packageName)).collect(Collectors.toSet());
    }

    @Nullable
    private static Class<?> getClass(String className, String packageName) {
        try {
            return Class.forName(packageName + "." + className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class Keys {
        public static final String RESULTS_KEY = "results";

        Keys() {
        }
    }
}

