/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.reports;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.exceptions.filibuster.FilibusterAnalysisFailureException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcTestRuntimeException;
import cloud.filibuster.exceptions.filibuster.FilibusterTestReportWriterException;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.IncompleteRPCAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.MultipleInvocationsForIndividualMutationsAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.RedundantRPCAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.ResponseBecomesRequestAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.TestExecutionReportAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.test_execution_report.UnimplementedFailuresAnalyzer;
import cloud.filibuster.junit.server.core.lint.analyzers.warnings.FilibusterAnalyzerWarning;
import cloud.filibuster.junit.server.core.reports.MaterializedTestExecutionReportMetadata;
import cloud.filibuster.junit.server.core.reports.ReportUtilities;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.json.JSONObject;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;

public class TestExecutionReport {
    private static final Logger logger = Logger.getLogger(TestExecutionReport.class.getName());
    @Nullable
    private MaterializedTestExecutionReportMetadata materializedTestExecutionReportMetadata;
    private int testExecutionNumber = 0;
    private boolean hasReportBeenMaterialized = false;
    private boolean testExecutionPassed = true;
    private final List<FailureMetadata> failures = new ArrayList<FailureMetadata>();
    private final ArrayList<DistributedExecutionIndex> deiInvocationOrder = new ArrayList();
    private final HashMap<DistributedExecutionIndex, JSONObject> deiInvocations = new HashMap();
    private final HashMap<DistributedExecutionIndex, JSONObject> deiResponses = new HashMap();
    private final HashMap<DistributedExecutionIndex, JSONObject> deiFaultsInjected = new HashMap();
    private final List<FilibusterAnalyzerWarning> warnings = new ArrayList<FilibusterAnalyzerWarning>();
    private final UUID uuid = UUID.randomUUID();
    private final UUID testUuid;
    private final String testName;
    private final String className;
    private final List<DistributedExecutionIndex> cachedRpcs = new ArrayList<DistributedExecutionIndex>();
    public static ArrayList<Class<? extends TestExecutionReportAnalyzer>> testExecutionReportAnalyzers = new ArrayList();

    public TestExecutionReport(String testName, UUID testUuid, String className) {
        this.testName = testName;
        this.testUuid = testUuid;
        this.className = className;
    }

    private File getDirectoryPath() {
        return new File(ReportUtilities.getBaseDirectoryPath(), "filibuster-test-" + this.testUuid.toString());
    }

    private File getSubdirectoryPath() {
        return new File(this.getDirectoryPath(), "filibuster-test-execution-" + this.uuid);
    }

    public boolean isTestExecutionPassed() {
        return this.testExecutionPassed;
    }

    public List<FilibusterAnalyzerWarning> getWarnings() {
        return this.warnings;
    }

    public Iterator<DistributedExecutionIndex> getInvocationOrderIterator() {
        return this.deiInvocationOrder.iterator();
    }

    public JSONObject getInvocationObject(DistributedExecutionIndex distributedExecutionIndex) {
        return this.deiInvocations.get(distributedExecutionIndex);
    }

    public JSONObject getResponseObject(DistributedExecutionIndex distributedExecutionIndex) {
        return this.deiResponses.get(distributedExecutionIndex);
    }

    public Map<DistributedExecutionIndex, JSONObject> getResponses() {
        return this.deiResponses;
    }

    public JSONObject getFaultObject(DistributedExecutionIndex distributedExecutionIndex) {
        return this.deiFaultsInjected.get(distributedExecutionIndex);
    }

    public List<DistributedExecutionIndex> getCachedRpcs() {
        return this.cachedRpcs;
    }

    public void markRpcAsCached(DistributedExecutionIndex distributedExecutionIndex) {
        this.cachedRpcs.add(distributedExecutionIndex);
    }

    public void recordInvocation(DistributedExecutionIndex distributedExecutionIndex, JSONObject invocationJsonObject) {
        this.deiInvocationOrder.add(distributedExecutionIndex);
        this.deiInvocations.put(distributedExecutionIndex, invocationJsonObject);
    }

    public void recordInvocationComplete(DistributedExecutionIndex distributedExecutionIndex, JSONObject invocationJsonObject) {
        this.deiResponses.put(distributedExecutionIndex, invocationJsonObject);
    }

    public void setFaultsInjected(Map<DistributedExecutionIndex, JSONObject> faultsToInject) {
        this.deiFaultsInjected.putAll(faultsToInject);
    }

    public String getTestName() {
        return this.testName;
    }

    public UUID getTestUuid() {
        return this.testUuid;
    }

    public String getClassName() {
        return this.className;
    }

    public static void addAnalyzer(Class<? extends TestExecutionReportAnalyzer> clazz) {
        testExecutionReportAnalyzers.add(clazz);
    }

    private JSONObject toJSONObject() {
        for (Class<? extends TestExecutionReportAnalyzer> clazz : testExecutionReportAnalyzers) {
            try {
                TestExecutionReportAnalyzer testExecutionReportAnalyzer = clazz.getDeclaredConstructor(TestExecutionReport.class).newInstance(this);
                this.warnings.addAll(testExecutionReportAnalyzer.analyze(this.testExecutionPassed));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new FilibusterAnalysisFailureException("could not instantiate class " + clazz + " for analysis", e);
            }
        }
        ArrayList<JSONObject> RPCs = new ArrayList<JSONObject>();
        int generatedId = 0;
        for (DistributedExecutionIndex dei : this.deiInvocationOrder) {
            ArrayList<JSONObject> warningObjects = new ArrayList<JSONObject>();
            for (FilibusterAnalyzerWarning warning : this.warnings) {
                if (!warning.getDistributedExecutionIndex().equals(dei)) continue;
                JSONObject warningObject = new JSONObject();
                warningObject.put("dei", (Object)warning.getDistributedExecutionIndex().toString());
                warningObject.put("name", (Object)warning.getName());
                warningObject.put("recommendation", (Object)warning.getRecommendations());
                warningObject.put("impact", (Object)warning.getImpact());
                warningObject.put("description", (Object)warning.getDescription());
                warningObject.put("details", (Object)warning.getDetails());
                warningObjects.add(warningObject);
            }
            JSONObject RPC = new JSONObject();
            RPC.put("generated_id", (Object)String.valueOf(++generatedId));
            RPC.put("dei", (Object)dei.toString());
            RPC.put("group", (Object)dei.projectionLastKeyWithOnlyMetadata().toString());
            RPC.put("request", (Object)this.deiInvocations.getOrDefault(dei, new JSONObject()));
            RPC.put("response", (Object)this.deiResponses.getOrDefault(dei, new JSONObject()));
            RPC.put("fault", (Object)this.deiFaultsInjected.getOrDefault(dei, new JSONObject()));
            RPC.put("warnings", warningObjects);
            RPC.put("cached", this.cachedRpcs.contains(dei));
            RPCs.add(RPC);
        }
        JSONObject result = new JSONObject();
        result.put("iteration", this.testExecutionNumber);
        result.put("status", this.testExecutionPassed);
        Function<String, String> toEscapeForHtml = str -> StringUtils.replaceEach((String)str, (String[])new String[]{"&", "\"", "<", ">"}, (String[])new String[]{"&amp;", "&quot;", "&lt;", "&gt;"});
        result.put("failures", (Collection)this.failures.stream().map(f -> {
            JSONObject failure = new JSONObject();
            failure.put("assertion_failure_message", toEscapeForHtml.apply(((FailureMetadata)f).assertionFailureMessage));
            failure.put("assertion_failure_stacktrace", toEscapeForHtml.apply(((FailureMetadata)f).assertionFailureStackTrace));
            failure.put("assertion_failure_fix_message", (Object)((FailureMetadata)f).assertionFailureFixMessage);
            return failure;
        }).collect(Collectors.toList()));
        result.put("rpcs", RPCs);
        result.put("uuid", (Object)this.uuid);
        result.put("test_name", (Object)this.testName);
        return result;
    }

    private String toJavascript() {
        JSONObject jsonObject = this.toJSONObject();
        return "var analysis = " + jsonObject.toString(4) + ";";
    }

    public void writePlaceholderTestReport() {
        File directory = this.getSubdirectoryPath();
        try {
            directory.mkdirs();
            Path indexPath = Paths.get(directory + "/index.html", new String[0]);
            byte[] indexBytes = ReportUtilities.getResourceAsBytes(this.getClass().getClassLoader(), "html/test_execution_report/index.html");
            Files.write(indexPath, indexBytes, new OpenOption[0]);
            logger.info("\n[FILIBUSTER-CORE]: Placeholder Test Execution Report written to file://" + indexPath + "\n");
        }
        catch (IOException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out placeholder test execution report: ", e);
        }
    }

    public void writeTestReport(int currentIteration, boolean exceptionOccurred, @Nullable Throwable throwable) {
        this.testExecutionNumber = currentIteration;
        boolean bl = this.testExecutionPassed = this.testExecutionPassed && !exceptionOccurred;
        if (!this.hasReportBeenMaterialized || throwable != null) {
            if (throwable != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                throwable.printStackTrace(pw);
                String stackTrace = sw.toString();
                String assertionFailureMessage = throwable.getMessage();
                if (assertionFailureMessage == null || assertionFailureMessage.equals("")) {
                    assertionFailureMessage = throwable.getClass().getSimpleName();
                }
                if (throwable instanceof FilibusterGrpcTestRuntimeException) {
                    this.failures.add(new FailureMetadata(assertionFailureMessage, stackTrace, ((FilibusterGrpcTestRuntimeException)throwable).getFixMessage()));
                } else {
                    this.failures.add(new FailureMetadata(assertionFailureMessage, stackTrace));
                }
            }
            try {
                Path directory = this.getSubdirectoryPath().toPath();
                Path scriptPath = Paths.get(directory + "/analysis.js", new String[0]);
                Path indexPath = Paths.get(directory + "/index.html", new String[0]);
                if (!Files.exists(directory, new LinkOption[0])) {
                    logger.warning("\n[FILIBUSTER-CORE] Could not find placeholder directory");
                    Files.createDirectory(directory, new FileAttribute[0]);
                }
                if (!Files.exists(indexPath, new LinkOption[0])) {
                    logger.warning("\n[FILIBUSTER-CORE] Placeholder directory path doesn't have index.html");
                    byte[] indexBytes = ReportUtilities.getResourceAsBytes(this.getClass().getClassLoader(), "html/test_execution_report/index.html");
                    Files.write(indexPath, indexBytes, new OpenOption[0]);
                }
                Files.write(scriptPath, this.toJavascript().getBytes(Charset.defaultCharset()), new OpenOption[0]);
                this.hasReportBeenMaterialized = true;
                this.materializedTestExecutionReportMetadata = new MaterializedTestExecutionReportMetadata(this.testExecutionNumber, this.testExecutionPassed, indexPath, this.uuid);
                logger.info("\n[FILIBUSTER-CORE]: Test Execution Report written to file://" + indexPath + "\n");
                logger.info("\n[FILIBUSTER-CORE]: Click me for tool view: http://filibuster.local" + indexPath + "\n");
            }
            catch (IOException e) {
                throw new FilibusterTestReportWriterException("Filibuster failed to write out the test execution report: ", e);
            }
        }
    }

    public MaterializedTestExecutionReportMetadata getMaterializedReportMetadata() {
        return this.materializedTestExecutionReportMetadata;
    }

    public List<FailureMetadata> getFailures() {
        return this.failures;
    }

    public String getFaultsInjected() {
        ArrayList<String> faultsInjected = new ArrayList<String>();
        for (Map.Entry<DistributedExecutionIndex, JSONObject> entry : this.deiFaultsInjected.entrySet()) {
            JSONObject invocation = this.deiInvocations.get(entry.getKey());
            JSONObject faultInjected = entry.getValue();
            if (invocation == null || faultInjected == null || !invocation.has("method")) continue;
            if (invocation.has("module")) {
                String module = invocation.getString("module");
                faultInjected.put("module", (Object)module);
            }
            if (invocation.has("method")) {
                String method = invocation.getString("method");
                faultInjected.put("method", (Object)method);
            }
            faultsInjected.add(faultInjected.toString(4));
        }
        return faultsInjected.toString();
    }

    static {
        testExecutionReportAnalyzers.add(RedundantRPCAnalyzer.class);
        testExecutionReportAnalyzers.add(UnimplementedFailuresAnalyzer.class);
        testExecutionReportAnalyzers.add(ResponseBecomesRequestAnalyzer.class);
        testExecutionReportAnalyzers.add(MultipleInvocationsForIndividualMutationsAnalyzer.class);
        testExecutionReportAnalyzers.add(IncompleteRPCAnalyzer.class);
    }

    static class Keys {
        private static final String ITERATION_KEY = "iteration";
        private static final String STATUS_KEY = "status";
        private static final String DEI_KEY = "dei";
        private static final String GROUP_KEY = "group";
        private static final String REQUEST_KEY = "request";
        private static final String RESPONSE_KEY = "response";
        private static final String FAULT_KEY = "fault";
        private static final String RPCS_KEY = "rpcs";
        private static final String WARNINGS_KEY = "warnings";
        private static final String GENERATED_ID_KEY = "generated_id";
        private static final String UUID_KEY = "uuid";
        private static final String TEST_NAME = "test_name";
        private static final String FAILURES = "failures";
        private static final String CACHED_KEY = "cached";

        Keys() {
        }

        static class FailureKeys {
            private static final String ASSERTION_FAILURE_STACKTRACE = "assertion_failure_stacktrace";
            private static final String ASSERTION_FAILURE_MESSAGE = "assertion_failure_message";
            private static final String ASSERTION_FAILURE_FIX_MESSAGE = "assertion_failure_fix_message";

            FailureKeys() {
            }
        }
    }

    public static class FailureMetadata {
        private final String assertionFailureMessage;
        private final String assertionFailureStackTrace;
        private String assertionFailureFixMessage;

        private FailureMetadata(String assertionFailureMessage, String assertionFailureStackTrace) {
            this.assertionFailureMessage = assertionFailureMessage;
            this.assertionFailureStackTrace = assertionFailureStackTrace;
        }

        private FailureMetadata(String assertionFailureMessage, String assertionFailureStackTrace, String assertionFailureFixMessage) {
            this.assertionFailureMessage = assertionFailureMessage;
            this.assertionFailureStackTrace = assertionFailureStackTrace;
            this.assertionFailureFixMessage = assertionFailureFixMessage;
        }

        public String getAssertionFailureMessage() {
            return this.assertionFailureMessage;
        }

        public String getAssertionFailureStackTrace() {
            return this.assertionFailureStackTrace;
        }
    }
}

