/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.reports;

import cloud.filibuster.exceptions.filibuster.FilibusterTestReportWriterException;
import cloud.filibuster.junit.server.core.reports.MaterializedTestExecutionReportMetadata;
import cloud.filibuster.junit.server.core.reports.ReportUtilities;
import cloud.filibuster.junit.server.core.reports.TestExecutionReport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.json.JSONObject;

public class TestReport {
    private static final Logger logger = Logger.getLogger(TestReport.class.getName());
    private final ArrayList<TestExecutionReport> testExecutionReports = new ArrayList();
    private final UUID testUuid;
    private final String testName;
    private final String className;
    private int numBypassedExecutions = 0;
    private int iterationsRemaining = 0;

    public TestReport(String testName, UUID testUuid, String className) {
        this.testUuid = testUuid;
        this.testName = testName;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public UUID getTestUuid() {
        return this.testUuid;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setNumBypassedExecutions(int numBypassedExecutions) {
        this.numBypassedExecutions = numBypassedExecutions;
    }

    public void setIterationsRemaining(int iterationsRemaining) {
        this.iterationsRemaining = iterationsRemaining;
    }

    public void addTestExecutionReport(TestExecutionReport testExecutionReport) {
        this.testExecutionReports.add(testExecutionReport);
    }

    private File getDirectoryPath() {
        return new File(ReportUtilities.getBaseDirectoryPath(), "filibuster-test-" + this.testUuid.toString());
    }

    public File getReportPath() {
        File directory = this.getDirectoryPath();
        return new File(directory, "index.html");
    }

    public void writeOutPlaceholder() {
        File indexPath = this.getReportPath();
        try {
            indexPath.getParentFile().mkdirs();
        }
        catch (SecurityException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the test aggregate report: ", e);
        }
        try {
            byte[] indexBytes = ReportUtilities.getResourceAsBytes(this.getClass().getClassLoader(), "html/test_report/index.html");
            Files.write(indexPath.toPath(), indexBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the test aggregate report: ", e);
        }
    }

    public void writeTestReport() {
        File directory = this.getDirectoryPath();
        try {
            directory.mkdirs();
        }
        catch (SecurityException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the test execution report: ", e);
        }
        Path scriptFile = Paths.get(directory + "/summary.js", new String[0]);
        try {
            Files.write(scriptFile, this.toJavascript().getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the test execution report: ", e);
        }
        Path indexPath = Paths.get(directory + "/index.html", new String[0]);
        try {
            byte[] indexBytes = ReportUtilities.getResourceAsBytes(this.getClass().getClassLoader(), "html/test_report/index.html");
            Files.write(indexPath, indexBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the test execution report: ", e);
        }
        Path sidebarPath = Paths.get(directory + "/sidebar.html", new String[0]);
        try {
            byte[] sidebarBytes = ReportUtilities.getResourceAsBytes(this.getClass().getClassLoader(), "html/test_report/sidebar.html");
            Files.write(sidebarPath, sidebarBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FilibusterTestReportWriterException("Filibuster failed to write out the test execution report: ", e);
        }
        logger.info("\n[FILIBUSTER-CORE]: Test Execution Aggregate Report written to file://" + indexPath + "\n");
    }

    private JSONObject toJsonObject() {
        JSONObject result = new JSONObject();
        ArrayList<JSONObject> materializedReportMetadatas = new ArrayList<JSONObject>();
        for (TestExecutionReport ter : this.testExecutionReports) {
            MaterializedTestExecutionReportMetadata mrm = ter.getMaterializedReportMetadata();
            if (mrm == null) continue;
            materializedReportMetadatas.add(ter.getMaterializedReportMetadata().toJsonObject());
        }
        result.put("reports", materializedReportMetadatas);
        result.put("iterations_remaining", this.iterationsRemaining);
        result.put("num_bypassed_executions", this.numBypassedExecutions);
        return result;
    }

    private String toJavascript() {
        JSONObject jsonObject = this.toJsonObject();
        return "var summary = " + jsonObject.toString(4) + ";";
    }

    public List<TestExecutionReport> getTestExecutionReports() {
        return this.testExecutionReports;
    }
}

