/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.serializers;

import cloud.filibuster.exceptions.filibuster.FilibusterDeserializationError;
import cloud.filibuster.exceptions.filibuster.FilibusterMessageSerializationException;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class GeneratedMessageV3Serializer {
    private static final Logger logger = Logger.getLogger(GeneratedMessageV3Serializer.class.getName());

    public static JSONObject toJsonObjectWithOnlyPayload(GeneratedMessageV3 generatedMessageV3) {
        try {
            String serializedMessage = JsonFormat.printer().preservingProtoFieldNames().includingDefaultValueFields().print((MessageOrBuilder)generatedMessageV3);
            return new JSONObject(serializedMessage);
        }
        catch (InvalidProtocolBufferException e) {
            logger.log(Level.SEVERE, "[toJSONObjectWithOnlyGsonPayload]: Failed to serialize message using JsonFormat. Throwing... " + generatedMessageV3, e);
            throw new FilibusterMessageSerializationException("Failed to serialize message using JsonFormat: " + generatedMessageV3, e);
        }
    }

    public static JSONObject toJsonObjectWithClassIncluded(GeneratedMessageV3 generatedMessageV3) {
        JSONObject newJsonObject = new JSONObject();
        newJsonObject.put("class", (Object)generatedMessageV3.getClass().getName());
        newJsonObject.put("gson", (Object)GeneratedMessageV3Serializer.toJsonObjectWithOnlyPayload(generatedMessageV3));
        newJsonObject.put("toString", (Object)generatedMessageV3.toString());
        return newJsonObject;
    }

    public static JSONObject toJsonObject(GeneratedMessageV3 generatedMessageV3) {
        return GeneratedMessageV3Serializer.toJsonObjectWithClassIncluded(generatedMessageV3);
    }

    public static GeneratedMessageV3 fromJsonObject(JSONObject jsonObject) {
        String className = jsonObject.getString("class");
        JSONObject gsonPayload = jsonObject.getJSONObject("gson");
        String gsonPayloadString = gsonPayload.toString();
        try {
            Class<?> clazz = Class.forName(className);
            AbstractMessage.Builder messageBuilder = (AbstractMessage.Builder)clazz.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            JsonFormat.parser().merge(gsonPayloadString, (Message.Builder)messageBuilder);
            return (GeneratedMessageV3)messageBuilder.build();
        }
        catch (InvalidProtocolBufferException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new FilibusterDeserializationError("Failed to deserialize and instantiate information for the fake: " + e, e);
        }
    }

    static class Keys {
        public static final String CLASS_KEY = "class";
        public static final String GSON_KEY = "gson";
        public static final String TO_STRING_KEY = "toString";

        Keys() {
        }
    }
}

