/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.serializers;

import io.grpc.Status;
import org.json.JSONObject;

public class StatusSerializer {
    public static JSONObject toJsonObject(Status status) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("class", (Object)"io.grpc.Status");
        jsonObject.put("code", (Object)status.getCode().toString());
        Throwable cause = status.getCause();
        if (cause != null) {
            jsonObject.put("cause", (Object)status.getCause().toString());
        }
        jsonObject.put("description", (Object)status.getDescription());
        return jsonObject;
    }

    public static Status fromJsonObject(JSONObject jsonObject) {
        String codeStr = jsonObject.getString("code");
        Status.Code code = Status.Code.valueOf((String)codeStr);
        Status status = Status.fromCode((Status.Code)code);
        if (jsonObject.has("description")) {
            String descriptionStr = jsonObject.getString("description");
            status = Status.fromCode((Status.Code)code).withDescription(descriptionStr);
        }
        return status;
    }

    static class Keys {
        public static final String CLASS_KEY = "class";
        public static final String CODE_KEY = "code";
        public static final String CAUSE_KEY = "cause";
        public static final String DESCRIPTION_KEY = "description";

        Keys() {
        }
    }
}

