/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.test_executions;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.junit.assertions.BlockType;
import cloud.filibuster.junit.server.core.reports.TestExecutionReport;
import cloud.filibuster.junit.server.core.test_executions.AbstractTestExecution;
import cloud.filibuster.junit.server.core.test_executions.TestExecution;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class ConcreteTestExecution
extends TestExecution
implements Cloneable {
    private final TestExecutionReport testExecutionReport;
    private int testScopeCounter = 0;
    private BlockType lastTestScopeBlockType = BlockType.DEFAULT;

    public ConcreteTestExecution(String testName, UUID testUuid, String className) {
        this.testExecutionReport = new TestExecutionReport(testName, testUuid, className);
    }

    public ConcreteTestExecution(AbstractTestExecution abstractTestExecution, String testName, UUID testUuid, String className) {
        this.testExecutionReport = new TestExecutionReport(testName, testUuid, className);
        this.faultsToInject.putAll(abstractTestExecution.faultsToInject);
        this.testExecutionReport.setFaultsInjected(this.faultsToInject);
    }

    public Map<DistributedExecutionIndex, JSONObject> getFaultsToInject() {
        return this.faultsToInject;
    }

    public Map<DistributedExecutionIndex, JSONObject> getFailedRpcs() {
        return this.failedRpcs;
    }

    public Map<DistributedExecutionIndex, JSONObject> getExecutedRpcs() {
        return this.executedRpcs;
    }

    public void incrementTestScopeCounter() {
        ++this.testScopeCounter;
    }

    public void incrementTestScopeCounter(BlockType blockType) {
        ++this.testScopeCounter;
        this.lastTestScopeBlockType = blockType;
    }

    public int getTestScopeCounter() {
        return this.testScopeCounter;
    }

    public BlockType getLastTestScopeBlockType() {
        return this.lastTestScopeBlockType;
    }

    public AbstractTestExecution toAbstractTestExecution() {
        AbstractTestExecution abstractTestExecution = new AbstractTestExecution(this);
        abstractTestExecution.executedRpcs.putAll(this.executedRpcs);
        abstractTestExecution.nondeterministicExecutedRpcs.putAll(this.nondeterministicExecutedRpcs);
        abstractTestExecution.faultsToInject.putAll(this.faultsToInject);
        return abstractTestExecution;
    }

    public TestExecutionReport getTestExecutionReport() {
        return this.testExecutionReport;
    }

    public void writePlaceHolderTestExecutionReport() {
        if (this.testExecutionReport != null) {
            this.testExecutionReport.writePlaceholderTestReport();
        }
    }

    public void writeTestExecutionReport(int currentIteration, boolean exceptionOccurred, @Nullable Throwable throwable) {
        if (this.testExecutionReport != null) {
            this.testExecutionReport.writeTestReport(currentIteration, exceptionOccurred, throwable);
        }
    }

    protected Object clone() {
        ConcreteTestExecution concreteTestExecution = new ConcreteTestExecution(this.testExecutionReport.getTestName(), this.testExecutionReport.getTestUuid(), this.testExecutionReport.getClassName());
        concreteTestExecution.generatedId = this.generatedId;
        concreteTestExecution.firstRequestSeenByService.putAll(this.firstRequestSeenByService);
        concreteTestExecution.executedRpcs.putAll(this.executedRpcs);
        concreteTestExecution.nondeterministicExecutedRpcs.putAll(this.nondeterministicExecutedRpcs);
        concreteTestExecution.faultsToInject.putAll(this.faultsToInject);
        return concreteTestExecution;
    }

    @Override
    public void addDistributedExecutionIndexWithRequestPayload(DistributedExecutionIndex distributedExecutionIndex, JSONObject payload) {
        this.addDistributedExecutionIndexWithRequestPayload(distributedExecutionIndex, payload, false);
    }

    public void addDistributedExecutionIndexWithRequestPayload(DistributedExecutionIndex distributedExecutionIndex, JSONObject payload, boolean seen) {
        this.testExecutionReport.recordInvocation(distributedExecutionIndex, payload);
        super.addDistributedExecutionIndexWithRequestPayload(distributedExecutionIndex, payload);
        if (seen) {
            this.testExecutionReport.markRpcAsCached(distributedExecutionIndex);
        }
    }

    @Override
    public void addDistributedExecutionIndexWithResponsePayload(DistributedExecutionIndex distributedExecutionIndex, JSONObject payload) {
        this.testExecutionReport.recordInvocationComplete(distributedExecutionIndex, payload);
        super.addDistributedExecutionIndexWithResponsePayload(distributedExecutionIndex, payload);
    }
}

