/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.test_executions;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.junit.server.core.test_executions.ConcreteTestExecution;
import com.google.gson.JsonParser;
import com.linecorp.armeria.common.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONObject;

public abstract class TestExecution {
    private static final Logger logger = Logger.getLogger(TestExecution.class.getName());
    int generatedId = 0;
    HashMap<DistributedExecutionIndex, JSONObject> executedRpcs = new HashMap();
    HashMap<DistributedExecutionIndex, JSONObject> nondeterministicExecutedRpcs = new HashMap();
    HashMap<DistributedExecutionIndex, JSONObject> faultsToInject = new HashMap();
    HashMap<DistributedExecutionIndex, JSONObject> failedRpcs = new HashMap();
    HashMap<String, Boolean> firstRequestSeenByService = new HashMap();

    public boolean hasSeenFirstRequestFromService(String serviceName) {
        return this.firstRequestSeenByService.containsKey(serviceName);
    }

    public void registerFirstRequestFromService(String serviceName) {
        this.firstRequestSeenByService.put(serviceName, true);
    }

    public void printRpcs() {
        JSONObject value;
        String key;
        StringBuilder logMessage = new StringBuilder("\n");
        logMessage.append("[FILIBUSTER-CORE]: RPCs executed and interposed by Filibuster");
        logMessage.append("\n").append("\n");
        for (DistributedExecutionIndex name : this.executedRpcs.keySet()) {
            key = name.toString();
            value = this.executedRpcs.get(name);
            if (key == null || value == null) continue;
            logMessage.append(key).append(" => ").append(value.toString(4)).append("\n");
        }
        if (!this.faultsToInject.isEmpty()) {
            logMessage.append("[FILIBUSTER-CORE]: Faults injected by Filibuster");
            logMessage.append("\n").append("\n");
            for (DistributedExecutionIndex name : this.faultsToInject.keySet()) {
                key = name.toString();
                value = this.faultsToInject.get(name);
                JSONObject request = this.executedRpcs.getOrDefault(name, new JSONObject().put("error", (Object)"no request information found"));
                logMessage.append(key).append(" => ").append(value.toString(4)).append(" => ").append(request.toString(4)).append("\n");
            }
        } else {
            logMessage.append("[FILIBUSTER-CORE]: No faults injected by Filibuster.");
            logMessage.append("\n").append("\n");
        }
        logger.info(logMessage.toString());
    }

    public boolean hasSeenRpcUnderSameOrDifferentDistributedExecutionIndex(JSONObject payload) {
        JSONObject payloadCacheCleaned = TestExecution.cleanPayloadForCacheComparison(payload);
        for (Map.Entry<DistributedExecutionIndex, JSONObject> executedRpc : this.executedRpcs.entrySet()) {
            JSONObject seenPayload = executedRpc.getValue();
            JSONObject seenPayloadCacheCleaned = TestExecution.cleanPayloadForCacheComparison(seenPayload);
            if (!seenPayloadCacheCleaned.similar((Object)payloadCacheCleaned)) continue;
            return true;
        }
        return false;
    }

    public void addDistributedExecutionIndexWithRequestPayload(DistributedExecutionIndex distributedExecutionIndex, JSONObject payload) {
        JSONObject payloadWithoutInstrumentationType = TestExecution.cleanPayloadOfInstrumentationType(payload);
        this.executedRpcs.put(distributedExecutionIndex, payloadWithoutInstrumentationType);
        JSONObject deterministicPayload = TestExecution.cleanPayloadOfArguments(payload);
        this.nondeterministicExecutedRpcs.put(distributedExecutionIndex, deterministicPayload);
    }

    public void addDistributedExecutionIndexWithResponsePayload(DistributedExecutionIndex distributedExecutionIndex, JSONObject payload) {
        if (payload.has("exception")) {
            this.failedRpcs.put(distributedExecutionIndex, payload);
        }
    }

    public int incrementGeneratedId() {
        ++this.generatedId;
        return this.generatedId;
    }

    public boolean shouldFault(DistributedExecutionIndex distributedExecutionIndex) {
        return this.faultsToInject.containsKey(distributedExecutionIndex);
    }

    public JSONObject getFault(DistributedExecutionIndex distributedExecutionIndex) {
        return this.faultsToInject.get(distributedExecutionIndex);
    }

    public boolean wasFaultInjected() {
        return !this.faultsToInject.isEmpty();
    }

    public boolean wasFaultInjectedOnRequest(String serializedRequest) {
        for (Map.Entry<DistributedExecutionIndex, JSONObject> entry : this.executedRpcs.entrySet()) {
            DistributedExecutionIndex distributedExecutionIndex;
            JSONObject executedRpcObject = entry.getValue();
            if (!executedRpcObject.getJSONObject("args").getString("toString").equals(serializedRequest) || !this.faultsToInject.containsKey(distributedExecutionIndex = entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean wasFaultInjectedOnService(String serviceName) {
        return this.wasFaultInjectedMatcher("module", serviceName);
    }

    public boolean wasFaultInjectedOnHttpMethod(HttpMethod httpMethod, String uriPattern) {
        boolean wasCorrectHttpVerb = this.wasFaultInjectedMatcher("method", httpMethod.toString());
        Pattern pattern = Pattern.compile(uriPattern, 2);
        for (Map.Entry<DistributedExecutionIndex, JSONObject> entry : this.executedRpcs.entrySet()) {
            DistributedExecutionIndex distributedExecutionIndex;
            JSONObject executedRpcObject = entry.getValue();
            String argsToString = executedRpcObject.getJSONObject("args").getString("toString");
            Matcher matcher = pattern.matcher(argsToString);
            if (!matcher.find() || !this.faultsToInject.containsKey(distributedExecutionIndex = entry.getKey())) continue;
            return wasCorrectHttpVerb;
        }
        return false;
    }

    public boolean wasFaultInjectedOnHttpRequest(HttpMethod httpMethod, String uriPattern, String serializedRequestPattern) {
        boolean wasCorrectHttpVerb = this.wasFaultInjectedMatcher("method", httpMethod.toString());
        Pattern uriPatternPattern = Pattern.compile(uriPattern, 2);
        Pattern serializedRequestPatternPattern = Pattern.compile(uriPattern, 2);
        for (Map.Entry<DistributedExecutionIndex, JSONObject> entry : this.executedRpcs.entrySet()) {
            DistributedExecutionIndex distributedExecutionIndex;
            JSONObject executedRpcObject = entry.getValue();
            String argsToString = executedRpcObject.getJSONObject("args").getString("toString");
            Matcher uriPatternMatcher = uriPatternPattern.matcher(argsToString);
            Matcher serializedRequestPatternMatcher = serializedRequestPatternPattern.matcher(argsToString);
            if (!uriPatternMatcher.find() || !serializedRequestPatternMatcher.find() || !this.faultsToInject.containsKey(distributedExecutionIndex = entry.getKey())) continue;
            return wasCorrectHttpVerb;
        }
        return false;
    }

    public boolean wasFaultInjectedOnMethod(String serviceName, String methodName) {
        return this.wasFaultInjectedMatcher("method", serviceName + "/" + methodName);
    }

    public boolean wasFaultInjectedOnMethodWhereRequestContains(String serviceName, String methodName, String contains) {
        return this.wasFaultInjectedMatcher("method", serviceName + "/" + methodName, contains);
    }

    public boolean matchesAbstractTestExecution(Object o) {
        if (!(o instanceof TestExecution)) {
            return false;
        }
        TestExecution te = (TestExecution)o;
        if (!this.faultsToInject.keySet().equals(te.faultsToInject.keySet())) {
            return false;
        }
        return this.faultsToInject.entrySet().stream().allMatch(e -> JsonParser.parseString((String)((JSONObject)e.getValue()).toString()).equals(JsonParser.parseString((String)te.faultsToInject.get(e.getKey()).toString())));
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestExecution)) {
            return false;
        }
        TestExecution te = (TestExecution)o;
        if (!this.executedRpcs.keySet().equals(te.executedRpcs.keySet())) {
            return false;
        }
        boolean equalRpcsMap = this.executedRpcs.entrySet().stream().allMatch(e -> ((JSONObject)e.getValue()).similar((Object)te.executedRpcs.get(e.getKey())));
        if (!this.faultsToInject.keySet().equals(te.faultsToInject.keySet())) {
            return false;
        }
        boolean equalFaultToInjectMap = this.faultsToInject.entrySet().stream().allMatch(e -> ((JSONObject)e.getValue()).similar((Object)te.faultsToInject.get(e.getKey())));
        return equalRpcsMap && equalFaultToInjectMap;
    }

    public int hashCode() {
        return Objects.hash(this.executedRpcs, this.faultsToInject);
    }

    private boolean wasFaultInjectedMatcher(String searchField, String stringToFind) {
        return this.wasFaultInjectedMatcher(searchField, stringToFind, null);
    }

    private boolean wasFaultInjectedMatcher(String searchField, String stringToFind, @Nullable String contains) {
        for (Map.Entry<DistributedExecutionIndex, JSONObject> entry : this.executedRpcs.entrySet()) {
            DistributedExecutionIndex distributedExecutionIndex;
            String field;
            JSONObject jsonObject = entry.getValue();
            if (!jsonObject.has(searchField) || !(field = jsonObject.getString(searchField)).contains(stringToFind) || !this.faultsToInject.containsKey(distributedExecutionIndex = entry.getKey())) continue;
            if (contains == null) {
                return true;
            }
            JSONObject executedRpcObject = entry.getValue();
            if (!executedRpcObject.getJSONObject("args").getString("toString").contains(contains)) continue;
            return true;
        }
        return false;
    }

    private static JSONObject cleanPayloadForCacheComparison(JSONObject payload) {
        JSONObject jsonObject = new JSONObject(payload.toString());
        jsonObject.remove("execution_index");
        jsonObject.remove("vclock");
        jsonObject.remove("instrumentation_type");
        jsonObject.remove("full_traceback");
        jsonObject.remove("callsite_file");
        jsonObject.remove("callsite_line");
        return jsonObject;
    }

    private static JSONObject cleanPayloadOfInstrumentationType(JSONObject payload) {
        JSONObject jsonObject = new JSONObject(payload.toString());
        jsonObject.remove("instrumentation_type");
        return jsonObject;
    }

    private static JSONObject cleanPayloadOfArguments(JSONObject payload) {
        JSONObject jsonObject = new JSONObject(payload.toString());
        jsonObject.remove("args");
        return jsonObject;
    }

    public static boolean organicallyFailedInSourceConcreteTestExecution(ConcreteTestExecution sourceConcreteTestExecution, ConcreteTestExecution completedSourceConcreteTestExecution, DistributedExecutionIndex distributedExecutionIndex) {
        if (sourceConcreteTestExecution != null && completedSourceConcreteTestExecution != null) {
            boolean wasNotFaultInjected;
            boolean sawInConcreteTestExecution = TestExecution.sawInConcreteTestExecution(sourceConcreteTestExecution, distributedExecutionIndex);
            boolean failedInConcreteTestExecution = completedSourceConcreteTestExecution.failedRpcs.containsKey(distributedExecutionIndex);
            boolean bl = wasNotFaultInjected = !sourceConcreteTestExecution.faultsToInject.containsKey(distributedExecutionIndex);
            if (sawInConcreteTestExecution && failedInConcreteTestExecution && wasNotFaultInjected) {
                return true;
            }
        }
        return false;
    }

    public static boolean sawInConcreteTestExecution(ConcreteTestExecution sourceConcreteTestExecution, DistributedExecutionIndex distributedExecutionIndex) {
        if (sourceConcreteTestExecution != null) {
            return sourceConcreteTestExecution.executedRpcs.containsKey(distributedExecutionIndex);
        }
        return false;
    }
}

