/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.transformers;

import cloud.filibuster.exceptions.transformer.TransformerNullResultException;
import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;

public final class BitInByteArrTransformer
implements Transformer<byte[], List<AbstractMap.SimpleImmutableEntry<Integer, Integer>>> {
    private boolean hasNext = true;
    private byte[] result;
    private Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<Integer, Integer>>> accumulator;

    @CanIgnoreReturnValue
    public BitInByteArrTransformer transform(byte[] payload, Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<Integer, Integer>>> accumulator) {
        List<AbstractMap.SimpleImmutableEntry<Integer, Integer>> ctx = accumulator.getContext();
        AbstractMap.SimpleImmutableEntry<Integer, Integer> entryToMutate = ctx.get(ctx.size() - 1);
        byte myByte = payload[entryToMutate.getKey()];
        String myBits = String.format("%8s", Integer.toBinaryString(myByte & 0xFF)).replace(' ', '0');
        StringBuilder myMutatedBits = new StringBuilder(myBits);
        if (myMutatedBits.charAt(entryToMutate.getValue()) == '0') {
            if (entryToMutate.getValue() == 0) {
                myMutatedBits.setCharAt(0, '-');
            } else {
                myMutatedBits.setCharAt(entryToMutate.getValue(), '1');
            }
        } else {
            myMutatedBits.setCharAt(entryToMutate.getValue(), '0');
        }
        byte[] mutatedPayload = (byte[])payload.clone();
        mutatedPayload[entryToMutate.getKey().intValue()] = (byte)Integer.valueOf(myMutatedBits.toString(), 2).intValue();
        this.result = mutatedPayload;
        this.accumulator = accumulator;
        if (ctx.size() == payload.length * 8) {
            this.hasNext = false;
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Type getPayloadType() {
        return byte[].class;
    }

    @Override
    public byte[] getResult() {
        if (this.result == null) {
            throw new TransformerNullResultException("Result is null. getResult() was probably called before transform()!");
        }
        return this.result;
    }

    @Override
    public Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<Integer, Integer>>> getInitialAccumulator(byte[] referenceValue) {
        Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<Integer, Integer>>> accumulator = new Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<Integer, Integer>>>();
        ArrayList<AbstractMap.SimpleImmutableEntry<Integer, Integer>> ctx = new ArrayList<AbstractMap.SimpleImmutableEntry<Integer, Integer>>();
        ctx.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(0, 0));
        accumulator.setContext(ctx);
        this.result = referenceValue;
        accumulator.setReferenceValue(referenceValue);
        return accumulator;
    }

    @Override
    public Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<Integer, Integer>>> getNextAccumulator() {
        if (this.accumulator == null) {
            return this.getInitialAccumulator(this.getResult());
        }
        List<AbstractMap.SimpleImmutableEntry<Integer, Integer>> ctx = this.accumulator.getContext();
        AbstractMap.SimpleImmutableEntry<Integer, Integer> newEntry = BitInByteArrTransformer.getNextEntry(ctx.get(ctx.size() - 1));
        ctx.add(newEntry);
        this.accumulator.setContext(ctx);
        return this.accumulator;
    }

    @Override
    public Type getAccumulatorType() {
        Type byteArrType = TypeToken.get(byte[].class).getType();
        Type simpleEntryType = TypeToken.getParameterized(AbstractMap.SimpleImmutableEntry.class, (Type[])new Type[]{Integer.class, Integer.class}).getType();
        Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{simpleEntryType}).getType();
        return TypeToken.getParameterized(Accumulator.class, (Type[])new Type[]{byteArrType, listType}).getType();
    }

    private static AbstractMap.SimpleImmutableEntry<Integer, Integer> getNextEntry(AbstractMap.SimpleImmutableEntry<Integer, Integer> ctx) {
        int byteIdx = ctx.getValue() < 7 ? ctx.getKey() : ctx.getKey() + 1;
        int bitIdx = ctx.getValue() < 7 ? ctx.getValue() + 1 : 0;
        return new AbstractMap.SimpleImmutableEntry<Integer, Integer>(byteIdx, bitIdx);
    }
}

