/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.transformers;

import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public final class ByteArrByzantineValueTransformer
implements Transformer<byte[], Integer> {
    private boolean hasNext = true;
    private byte[] result;
    private Accumulator<byte[], Integer> accumulator;
    byte[][] possibleValues = new byte[][]{"".getBytes(StandardCharsets.UTF_8), "ThisIsATestString".getBytes(StandardCharsets.UTF_8), "abcd".getBytes(StandardCharsets.UTF_8), "1234!!".getBytes(StandardCharsets.UTF_8), "-11".getBytes(StandardCharsets.UTF_8), null};

    @CanIgnoreReturnValue
    public ByteArrByzantineValueTransformer transform(byte[] payload, Accumulator<byte[], Integer> accumulator) {
        this.result = this.possibleValues[accumulator.getContext()];
        this.accumulator = accumulator;
        if (accumulator.getContext() < this.possibleValues.length - 1) {
            accumulator.setContext(accumulator.getContext() + 1);
        } else {
            this.hasNext = false;
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Type getPayloadType() {
        return byte[].class;
    }

    @Override
    public byte[] getResult() {
        return this.result;
    }

    @Override
    public Type getAccumulatorType() {
        return TypeToken.getParameterized(Accumulator.class, (Type[])new Type[]{byte[].class, Integer.class}).getType();
    }

    @Override
    public Accumulator<byte[], Integer> getInitialAccumulator(byte[] referenceValue) {
        this.result = referenceValue;
        Accumulator<byte[], Integer> accumulator = new Accumulator<byte[], Integer>();
        accumulator.setReferenceValue(referenceValue);
        accumulator.setContext(0);
        return accumulator;
    }

    @Override
    public Accumulator<byte[], Integer> getNextAccumulator() {
        if (this.accumulator == null) {
            return this.getInitialAccumulator(this.getResult());
        }
        return this.accumulator;
    }
}

