/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.transformers;

import cloud.filibuster.exceptions.filibuster.FilibusterTransformerException;
import cloud.filibuster.exceptions.transformer.TransformerNullResultException;
import cloud.filibuster.junit.server.core.FilibusterCoreTransformerExtension;
import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.JsonUtils;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import cloud.filibuster.junit.server.core.transformers.selector.GatewayTransformer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public final class JsonObjectAsByteArrTransformer
implements Transformer<byte[], List<AbstractMap.SimpleImmutableEntry<String, String>>> {
    private boolean hasNext = true;
    private byte[] result;
    private Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<String, String>>> accumulator;
    private Transformer<?, ?> lastCtxEntryTransformationResult;
    private static final Gson gson = new Gson();

    @CanIgnoreReturnValue
    public JsonObjectAsByteArrTransformer transform(byte[] payload, Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<String, String>>> accumulator) {
        List<AbstractMap.SimpleImmutableEntry<String, String>> ctx = accumulator.getContext();
        String payloadStr = new String(payload, Charset.defaultCharset());
        JSONObject payloadJo = new JSONObject(payloadStr);
        payloadJo = JsonUtils.flatten(payloadJo);
        AbstractMap.SimpleImmutableEntry<String, String> lastCtxEntry = ctx.get(ctx.size() - 1);
        Object valueToTransform = payloadJo.get(lastCtxEntry.getKey());
        String transformerClassName = GatewayTransformer.getTransformerClassNameFromReferenceValue(valueToTransform);
        Transformer<?, ?> lastCtxEntryTransformer = FilibusterCoreTransformerExtension.getTransformerInstance(transformerClassName);
        Accumulator<?, ?> lastCtxEntryAccumulator = (Accumulator<?, ?>)gson.fromJson(lastCtxEntry.getValue(), lastCtxEntryTransformer.getAccumulatorType());
        try {
            Method transformMethod = lastCtxEntryTransformer.getClass().getMethod("transform", (Class)lastCtxEntryTransformer.getPayloadType(), Accumulator.class);
            this.lastCtxEntryTransformationResult = (Transformer)transformMethod.invoke(lastCtxEntryTransformer, lastCtxEntryAccumulator.getReferenceValue(), lastCtxEntryAccumulator);
            payloadJo.put(lastCtxEntry.getKey(), (Object)this.lastCtxEntryTransformationResult.getResult().toString());
            if (this.lastCtxEntryTransformationResult.hasNext()) {
                lastCtxEntryAccumulator = this.lastCtxEntryTransformationResult.getNextAccumulator();
                ctx.set(ctx.size() - 1, new AbstractMap.SimpleImmutableEntry<String, String>(lastCtxEntry.getKey(), gson.toJson(lastCtxEntryAccumulator)));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new FilibusterTransformerException("[JsonObjectAsStringTransformer]: An exception occurred while invoking transform method of transformer " + lastCtxEntryTransformer.getClass().getName(), e);
        }
        if (ctx.size() == payloadJo.keySet().size() && !this.lastCtxEntryTransformationResult.hasNext()) {
            this.hasNext = false;
        }
        this.result = JsonUtils.unflatten(payloadJo).toString().getBytes(Charset.defaultCharset());
        this.accumulator = accumulator;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Type getPayloadType() {
        return byte[].class;
    }

    @Override
    public byte[] getResult() {
        if (this.result == null) {
            throw new TransformerNullResultException("Result is null. getResult() was probably called before transform()!");
        }
        return this.result;
    }

    @Override
    public Type getAccumulatorType() {
        Type byteArrType = TypeToken.get(byte[].class).getType();
        Type simpleEntryType = TypeToken.getParameterized(AbstractMap.SimpleImmutableEntry.class, (Type[])new Type[]{String.class, String.class}).getType();
        Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{simpleEntryType}).getType();
        return TypeToken.getParameterized(Accumulator.class, (Type[])new Type[]{byteArrType, listType}).getType();
    }

    @Override
    public Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<String, String>>> getInitialAccumulator(byte[] referenceValue) {
        ArrayList<AbstractMap.SimpleImmutableEntry<String, String>> ctx = new ArrayList<AbstractMap.SimpleImmutableEntry<String, String>>();
        String referenceValueStr = new String(referenceValue, Charset.defaultCharset());
        JSONObject referenceJo = new JSONObject(referenceValueStr);
        if ((referenceJo = JsonUtils.flatten(referenceJo)).keySet().size() > 0) {
            String firstKey = (String)referenceJo.keySet().iterator().next();
            Object firstValue = referenceJo.get(firstKey);
            Accumulator<?, ?> initialAccumulator = JsonObjectAsByteArrTransformer.getInitialAccumulatorFromValue(firstValue);
            AbstractMap.SimpleImmutableEntry<String, String> entry = new AbstractMap.SimpleImmutableEntry<String, String>(firstKey, gson.toJson(initialAccumulator));
            ctx.add(entry);
        } else {
            this.hasNext = false;
        }
        Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<String, String>>> accumulator = new Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<String, String>>>();
        accumulator.setContext(ctx);
        accumulator.setReferenceValue(referenceValue);
        this.result = referenceValue;
        return accumulator;
    }

    private static Accumulator<?, ?> getInitialAccumulatorFromValue(Object value) {
        String transformerClassName = GatewayTransformer.getTransformerClassNameFromReferenceValue(value);
        Transformer<?, ?> transformer = FilibusterCoreTransformerExtension.getTransformerInstance(transformerClassName);
        Accumulator<?, ?> accumulator = transformer.getInitialAccumulator();
        accumulator.setReferenceValue(value);
        return accumulator;
    }

    @Override
    public Accumulator<byte[], List<AbstractMap.SimpleImmutableEntry<String, String>>> getNextAccumulator() {
        if (this.accumulator == null) {
            return this.getInitialAccumulator(this.getResult());
        }
        if (!this.lastCtxEntryTransformationResult.hasNext()) {
            List<AbstractMap.SimpleImmutableEntry<String, String>> ctx = this.accumulator.getContext();
            String referenceValueStr = new String(this.accumulator.getReferenceValue(), Charset.defaultCharset());
            JSONObject referenceJo = new JSONObject(referenceValueStr);
            referenceJo = JsonUtils.flatten(referenceJo);
            if (ctx.size() == referenceJo.keySet().size()) {
                this.hasNext = false;
            } else {
                try {
                    String nextKey = (String)new ArrayList(referenceJo.keySet()).get(ctx.size());
                    Object nextValue = referenceJo.get(nextKey);
                    Accumulator<?, ?> initialAccumulator = JsonObjectAsByteArrTransformer.getInitialAccumulatorFromValue(nextValue);
                    AbstractMap.SimpleImmutableEntry<String, String> entry = new AbstractMap.SimpleImmutableEntry<String, String>(nextKey, gson.toJson(initialAccumulator));
                    ctx.add(entry);
                    this.accumulator.setContext(ctx);
                }
                catch (RuntimeException e) {
                    throw new FilibusterTransformerException("[JsonObjectAsStringTransformer]: An exception occurred while getting next accumulator", e);
                }
            }
        }
        return this.accumulator;
    }
}

