/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.transformers;

import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public final class NullTransformer
implements Transformer<Object, Object> {
    @Nullable
    private Object result;

    @CanIgnoreReturnValue
    public NullTransformer transform(Object payload, Accumulator<Object, Object> accumulator) {
        this.result = null;
        return this;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public Type getPayloadType() {
        return Object.class;
    }

    @Override
    @Nullable
    public Object getResult() {
        return this.result;
    }

    @Override
    public Type getAccumulatorType() {
        return TypeToken.getParameterized(Accumulator.class, (Type[])new Type[]{Object.class, Object.class}).getType();
    }

    @Override
    public Accumulator<Object, Object> getInitialAccumulator(Object referenceValue) {
        this.result = referenceValue;
        Accumulator<Object, Object> accumulator = new Accumulator<Object, Object>();
        accumulator.setReferenceValue(referenceValue);
        return accumulator;
    }

    @Override
    public Accumulator<Object, Object> getNextAccumulator() {
        return this.getInitialAccumulator(this.getResult());
    }
}

