/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.transformers;

import cloud.filibuster.exceptions.transformer.TransformerNullResultException;
import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public final class StringAsByteArrTransformer
implements Transformer<byte[], Integer> {
    private boolean hasNext = true;
    private byte[] result;
    private Accumulator<byte[], Integer> accumulator;

    @CanIgnoreReturnValue
    public StringAsByteArrTransformer transform(byte[] payload, Accumulator<byte[], Integer> accumulator) {
        int idx = accumulator.getContext();
        String payloadStr = new String(payload, Charset.defaultCharset());
        StringBuilder newString = new StringBuilder(payloadStr);
        newString.setCharAt(idx, StringAsByteArrTransformer.getNextChar(newString.charAt(idx)));
        if (idx == payloadStr.length() - 1) {
            this.hasNext = false;
        }
        this.result = newString.toString().getBytes(Charset.defaultCharset());
        this.accumulator = accumulator;
        return this;
    }

    private static char getNextChar(char c) {
        if (c == '~') {
            return '!';
        }
        return (char)(c + '\u0001');
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Type getPayloadType() {
        return byte[].class;
    }

    @Override
    public byte[] getResult() {
        if (this.result == null) {
            throw new TransformerNullResultException("Result is null. getResult() was probably called before transform()!");
        }
        return this.result;
    }

    @Override
    public Type getAccumulatorType() {
        return TypeToken.getParameterized(Accumulator.class, (Type[])new Type[]{byte[].class, Integer.class}).getType();
    }

    @Override
    public Accumulator<byte[], Integer> getInitialAccumulator(byte[] referenceValue) {
        Accumulator<byte[], Integer> accumulator = new Accumulator<byte[], Integer>();
        accumulator.setContext(0);
        accumulator.setReferenceValue(referenceValue);
        this.result = referenceValue;
        return accumulator;
    }

    @Override
    public Accumulator<byte[], Integer> getNextAccumulator() {
        if (this.accumulator == null) {
            return this.getInitialAccumulator(this.getResult());
        }
        this.accumulator.setContext(this.accumulator.getContext() + 1);
        return this.accumulator;
    }
}

