/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.transformers;

import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;

public final class StringBasicByzantineValueTransformer
implements Transformer<String, Integer> {
    private boolean hasNext = true;
    private String result;
    private Accumulator<String, Integer> accumulator;
    private static final String[] possibleValues = new String[]{null, ""};

    @CanIgnoreReturnValue
    public StringBasicByzantineValueTransformer transform(String payload, Accumulator<String, Integer> accumulator) {
        this.result = possibleValues[accumulator.getContext()];
        this.accumulator = accumulator;
        if (accumulator.getContext() < possibleValues.length - 1) {
            accumulator.setContext(accumulator.getContext() + 1);
        } else {
            this.hasNext = false;
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Type getPayloadType() {
        return String.class;
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public Type getAccumulatorType() {
        return TypeToken.getParameterized(Accumulator.class, (Type[])new Type[]{String.class, Integer.class}).getType();
    }

    @Override
    public Accumulator<String, Integer> getInitialAccumulator(String referenceValue) {
        this.result = referenceValue;
        Accumulator<String, Integer> accumulator = new Accumulator<String, Integer>();
        accumulator.setReferenceValue(referenceValue);
        accumulator.setContext(0);
        return accumulator;
    }

    @Override
    public Accumulator<String, Integer> getNextAccumulator() {
        if (this.accumulator == null) {
            return this.getInitialAccumulator(this.getResult());
        }
        return this.accumulator;
    }
}

