/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.transformers.selector;

import cloud.filibuster.exceptions.filibuster.FilibusterTransformerException;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import cloud.filibuster.junit.server.core.transformers.selector.BooleanSelector;
import cloud.filibuster.junit.server.core.transformers.selector.ByteArraySelector;
import cloud.filibuster.junit.server.core.transformers.selector.ObjectSelector;
import cloud.filibuster.junit.server.core.transformers.selector.Selector;
import cloud.filibuster.junit.server.core.transformers.selector.StringSelector;
import cloud.filibuster.junit.server.core.transformers.selector.UnknownTypeSelector;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class GatewayTransformer
implements Transformer<Object, Object> {
    private static final Map<String, Function<Object, Class<? extends Transformer<?, ?>>>> payloadClassToTransformerSelectorMethod = new HashMap();
    private static final String UNKNOWN_PAYLOAD_TYPE = "UNKNOWN";

    private static <T extends Selector> Function<Object, Class<? extends Transformer<?, ?>>> getSelectorMethod(T selector) {
        return selector::select;
    }

    public static <T> String getTransformerClassNameFromReferenceValue(String payloadClass, T referenceValue) {
        try {
            return payloadClassToTransformerSelectorMethod.get(payloadClass).apply(referenceValue).getName();
        }
        catch (NullPointerException e) {
            throw new FilibusterTransformerException("No transformer found for payload class " + payloadClass + " and reference value " + referenceValue, e);
        }
    }

    public static <T> String getTransformerClassNameFromReferenceValue(T referenceValue) {
        return GatewayTransformer.getTransformerClassNameFromReferenceValue(UNKNOWN_PAYLOAD_TYPE, referenceValue);
    }

    static {
        payloadClassToTransformerSelectorMethod.put(String.class.getName(), GatewayTransformer.getSelectorMethod(new StringSelector()));
        payloadClassToTransformerSelectorMethod.put(Object.class.getName(), GatewayTransformer.getSelectorMethod(new ObjectSelector()));
        payloadClassToTransformerSelectorMethod.put(byte[].class.getName(), GatewayTransformer.getSelectorMethod(new ByteArraySelector()));
        payloadClassToTransformerSelectorMethod.put(Boolean.TYPE.getName(), GatewayTransformer.getSelectorMethod(new BooleanSelector()));
        payloadClassToTransformerSelectorMethod.put(Boolean.class.getName(), GatewayTransformer.getSelectorMethod(new BooleanSelector()));
        payloadClassToTransformerSelectorMethod.put(UNKNOWN_PAYLOAD_TYPE, GatewayTransformer.getSelectorMethod(new UnknownTypeSelector()));
    }
}

