/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.server.core.transformers.selector;

import cloud.filibuster.junit.server.core.transformers.Transformer;
import com.google.gson.Gson;
import java.util.function.Function;
import java.util.regex.Pattern;

abstract class Selector {
    private static final Pattern boolPattern = Pattern.compile("true|false", 2);
    private static final Gson gson = new Gson();

    Selector() {
    }

    abstract <T> Class<? extends Transformer<?, ?>> select(T var1);

    <CLASS, VALUE> boolean isApplicable(Class<CLASS> clazz, VALUE value, Function<CLASS, ?> func) {
        try {
            Object gsonValue = gson.fromJson(String.valueOf(value), clazz);
            func.apply(gsonValue);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected static boolean isBoolean(String value) {
        if (boolPattern.matcher(value).matches()) {
            return true;
        }
        throw new IllegalArgumentException("Value is not a boolean: " + value);
    }
}

