/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.statem;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestInternalRuntimeException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcAmbiguousFailureHandlingException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcAmbiguousThrowAndErrorPropagationException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcAssertOnFaultException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcAssertTestBlockFailedException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcAssertionUsedOutsideFailureBlockException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcAssertionsDidNotHoldUnderErrorResponseException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcAssertionsForAssertOnExceptionFailedException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcFailedRPCException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcInjectedFaultHasUnspecifiedFailureBehaviorException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcInvokedRPCUnimplementedException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcMissingAssertionForStatusCodeException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcMultipleFaultsInjectedException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcReadOnlyRPCUsedOutsideAssertOnExceptionAndAssertOnFaultException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcSideEffectingRPCUsedOutsideAssertOnExceptionAndAssertOnFaultException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcStubbedRPCHasNoAssertionsException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcSuppressedStatusCodeException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcThrownExceptionHasUnspecifiedFailureBehaviorException;
import cloud.filibuster.exceptions.filibuster.FilibusterUnsupportedAPIException;
import cloud.filibuster.instrumentation.datatypes.Pair;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.assertions.Helpers;
import cloud.filibuster.junit.server.core.FilibusterCore;
import cloud.filibuster.junit.statem.CompositeFaultSpecification;
import cloud.filibuster.junit.statem.GrpcMock;
import cloud.filibuster.junit.statem.GrpcTestUtils;
import cloud.filibuster.junit.statem.keys.CompositeFaultKey;
import cloud.filibuster.junit.statem.keys.FaultKey;
import cloud.filibuster.junit.statem.keys.SingleFaultKey;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.json.JSONObject;

public interface FilibusterGrpcTest {
    public static final AtomicReference<GeneratedMessageV3> response = new AtomicReference();
    public static final HashMap<Status.Code, Runnable> errorAssertions = new HashMap();
    public static final HashMap<FaultKey, Map.Entry<Status.Code, String>> faultKeysThatThrow = new HashMap();
    public static final List<FaultKey> faultKeysThatPropagate = new ArrayList<FaultKey>();
    public static final List<FaultKey> faultKeysWithNoImpact = new ArrayList<FaultKey>();
    public static final HashMap<FaultKey, Runnable> assertionsByFaultKey = new HashMap();

    default public void setResponse(GeneratedMessageV3 response) {
        FilibusterGrpcTest.response.set(response);
    }

    default public GeneratedMessageV3 getResponse() {
        return response.get();
    }

    public void failureBlock();

    public void setupBlock();

    public void stubBlock();

    public void executeTestBlock();

    public void assertTestBlock();

    public void assertStubBlock();

    public void teardownBlock();

    default public void assertOnException(Status.Code code, Runnable runnable) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertOnException");
        }
        errorAssertions.put(code, runnable);
    }

    default public void assertFaultThrows(CompositeFaultSpecification compositeFaultSpecification, Status.Code thrownCode, String thrownMessage) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultThrows");
        }
        faultKeysThatThrow.put(new CompositeFaultKey(compositeFaultSpecification), Pair.of(thrownCode, thrownMessage));
    }

    default public <ReqT, ResT> void assertFaultThrows(MethodDescriptor<ReqT, ResT> methodDescriptor, Status.Code thrownCode, String thrownMessage) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultThrows");
        }
        faultKeysThatThrow.put(new SingleFaultKey<ReqT, ResT>(methodDescriptor), Pair.of(thrownCode, thrownMessage));
    }

    default public <ReqT, ResT> void assertFaultThrows(MethodDescriptor<ReqT, ResT> methodDescriptor, Status.Code code, Status.Code thrownCode, String thrownMessage) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultThrows");
        }
        faultKeysThatThrow.put(new SingleFaultKey<Status.Code, ResT>(methodDescriptor, code), Pair.of(thrownCode, thrownMessage));
    }

    default public <ReqT, ResT> void assertFaultThrows(MethodDescriptor<ReqT, ResT> methodDescriptor, ReqT request, Status.Code thrownCode, String thrownMessage) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultThrows");
        }
        faultKeysThatThrow.put(new SingleFaultKey<ReqT, ResT>(methodDescriptor, request), Pair.of(thrownCode, thrownMessage));
    }

    default public <ReqT, ResT> void assertFaultThrows(MethodDescriptor<ReqT, ResT> methodDescriptor, Status.Code code, ReqT request, Status.Code thrownCode, String thrownMessage) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultThrows");
        }
        faultKeysThatThrow.put(new SingleFaultKey<ReqT, ResT>(methodDescriptor, code, request), Pair.of(thrownCode, thrownMessage));
    }

    default public <ReqT, ResT> void assertFaultPropagates(MethodDescriptor<ReqT, ResT> methodDescriptor) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultPropagates");
        }
        faultKeysThatPropagate.add(new SingleFaultKey<ReqT, ResT>(methodDescriptor));
    }

    default public <ReqT, ResT> void assertFaultHasNoImpact(MethodDescriptor<ReqT, ResT> methodDescriptor) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultHasNoImpact");
        }
        faultKeysWithNoImpact.add(new SingleFaultKey<ReqT, ResT>(methodDescriptor));
    }

    default public <ReqT, ResT> void assertFaultHasNoImpact(MethodDescriptor<ReqT, ResT> methodDescriptor, Status.Code code) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultHasNoImpact");
        }
        faultKeysWithNoImpact.add(new SingleFaultKey<Status.Code, ResT>(methodDescriptor, code));
    }

    default public <ReqT, ResT> void assertFaultHasNoImpact(MethodDescriptor<ReqT, ResT> methodDescriptor, ReqT request) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultHasNoImpact");
        }
        faultKeysWithNoImpact.add(new SingleFaultKey<ReqT, ResT>(methodDescriptor, request));
    }

    default public <ReqT, ResT> void assertFaultHasNoImpact(MethodDescriptor<ReqT, ResT> methodDescriptor, Status.Code code, ReqT request) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertFaultHasNoImpact");
        }
        faultKeysWithNoImpact.add(new SingleFaultKey<ReqT, ResT>(methodDescriptor, code, request));
    }

    default public <ReqT, ResT> void assertOnFault(MethodDescriptor<ReqT, ResT> methodDescriptor, Runnable runnable) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertOnFault");
        }
        assertionsByFaultKey.put(new SingleFaultKey<ReqT, ResT>(methodDescriptor), runnable);
    }

    default public <ReqT, ResT> void assertOnFault(MethodDescriptor<ReqT, ResT> methodDescriptor, Status.Code code, Runnable runnable) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertOnFault");
        }
        assertionsByFaultKey.put(new SingleFaultKey<Status.Code, ResT>(methodDescriptor, code), runnable);
    }

    default public <ReqT, ResT> void assertOnFault(MethodDescriptor<ReqT, ResT> methodDescriptor, ReqT request, Runnable runnable) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertOnFault");
        }
        assertionsByFaultKey.put(new SingleFaultKey<ReqT, ResT>(methodDescriptor, request), runnable);
    }

    default public <ReqT, ResT> void assertOnFault(MethodDescriptor<ReqT, ResT> methodDescriptor, Status.Code code, ReqT request, Runnable runnable) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertOnFault");
        }
        assertionsByFaultKey.put(new SingleFaultKey<ReqT, ResT>(methodDescriptor, code, request), runnable);
    }

    default public void assertOnFault(CompositeFaultSpecification compositeFaultSpecification, Runnable runnable) {
        if (!GrpcTestUtils.isInsideOfFailureBlock()) {
            throw new FilibusterGrpcAssertionUsedOutsideFailureBlockException("assertOnFault");
        }
        assertionsByFaultKey.put(new CompositeFaultKey(compositeFaultSpecification), runnable);
    }

    default public <ReqT, ResT> void readOnlyRpc(MethodDescriptor<ReqT, ResT> methodDescriptor) {
        if (!GrpcTestUtils.isInsideOfAssertOnExceptionBlock() && !GrpcTestUtils.isInsideOfAssertOnFaultBlock()) {
            throw new FilibusterGrpcReadOnlyRPCUsedOutsideAssertOnExceptionAndAssertOnFaultException();
        }
        GrpcMock.adjustExpectation(methodDescriptor, -1);
    }

    default public <ReqT, ResT> void readOnlyRpc(MethodDescriptor<ReqT, ResT> methodDescriptor, ReqT request) {
        if (!GrpcTestUtils.isInsideOfAssertOnExceptionBlock() && !GrpcTestUtils.isInsideOfAssertOnFaultBlock()) {
            throw new FilibusterGrpcReadOnlyRPCUsedOutsideAssertOnExceptionAndAssertOnFaultException();
        }
        GrpcMock.adjustExpectation(methodDescriptor, request, -1);
    }

    default public <ReqT, ResT> void sideEffectingRpc(MethodDescriptor<ReqT, ResT> methodDescriptor, int count) {
        if (!GrpcTestUtils.isInsideOfAssertOnExceptionBlock() && !GrpcTestUtils.isInsideOfAssertOnFaultBlock()) {
            throw new FilibusterGrpcSideEffectingRPCUsedOutsideAssertOnExceptionAndAssertOnFaultException();
        }
        GrpcMock.adjustExpectation(methodDescriptor, count);
    }

    default public <ReqT, ResT> void sideEffectingRpc(MethodDescriptor<ReqT, ResT> methodDescriptor, ReqT request, int count) {
        if (!GrpcTestUtils.isInsideOfAssertOnExceptionBlock() && !GrpcTestUtils.isInsideOfAssertOnFaultBlock()) {
            throw new FilibusterGrpcSideEffectingRPCUsedOutsideAssertOnExceptionAndAssertOnFaultException();
        }
        GrpcMock.adjustExpectation(methodDescriptor, request, count);
    }

    default public List<JSONObject> rpcsWhereFaultsInjected() {
        ArrayList<JSONObject> rpcsWhereFaultsInjected = new ArrayList<JSONObject>();
        Map<DistributedExecutionIndex, JSONObject> executedRpcs = this.getExecutedRpcs();
        if (executedRpcs == null) {
            throw new FilibusterGrpcTestInternalRuntimeException("executedRpcs is null: this could indicate a problem!");
        }
        Map<DistributedExecutionIndex, JSONObject> faultsInjected = this.getFaultsInjected();
        if (faultsInjected == null) {
            throw new FilibusterGrpcTestInternalRuntimeException("faultsInjected is null: this could indicate a problem!");
        }
        for (Map.Entry<DistributedExecutionIndex, JSONObject> executedRpc : executedRpcs.entrySet()) {
            if (!faultsInjected.containsKey(executedRpc.getKey())) continue;
            JSONObject faultInjected = faultsInjected.get(executedRpc.getKey());
            JSONObject finalExecutedRpc = executedRpc.getValue();
            if (faultInjected.has("forced_exception")) {
                JSONObject forcedExceptionObject = faultInjected.getJSONObject("forced_exception");
                finalExecutedRpc.put("forced_exception", (Object)forcedExceptionObject);
            }
            rpcsWhereFaultsInjected.add(finalExecutedRpc);
        }
        return rpcsWhereFaultsInjected;
    }

    default public boolean performSingleFaultChecking(JSONObject rpcWhereFaultInjected) {
        boolean shouldRunAssertionBlock = true;
        boolean searchComplete = false;
        for (FaultKey faultKey : SingleFaultKey.generateFaultKeysInDecreasingGranularity(rpcWhereFaultInjected)) {
            block9: {
                if (searchComplete) continue;
                if (assertionsByFaultKey.containsKey(faultKey)) {
                    searchComplete = true;
                    shouldRunAssertionBlock = false;
                    try {
                        Runnable runnable = assertionsByFaultKey.get(faultKey);
                        if (runnable != null) {
                            GrpcTestUtils.setInsideOfAssertOnFaultBlock(true);
                            runnable.run();
                            break block9;
                        }
                        throw new FilibusterGrpcTestInternalRuntimeException("runnable is null: this could indicate a problem!");
                    }
                    catch (Throwable t) {
                        throw new FilibusterGrpcAssertOnFaultException(t);
                    }
                    finally {
                        GrpcTestUtils.setInsideOfAssertOnFaultBlock(false);
                    }
                }
            }
            if (!faultKeysWithNoImpact.contains(faultKey)) continue;
            searchComplete = true;
            shouldRunAssertionBlock = true;
        }
        if (!searchComplete) {
            throw new FilibusterGrpcInjectedFaultHasUnspecifiedFailureBehaviorException();
        }
        return shouldRunAssertionBlock;
    }

    default public boolean performMultipleFaultChecking(List<JSONObject> rpcsWhereFaultsInjected) {
        ArrayList<JSONObject> rpcsWhereFaultsInjectedWithImpact;
        FaultKey faultKey = CompositeFaultKey.findMatchingFaultKey(assertionsByFaultKey, rpcsWhereFaultsInjected);
        if (faultKey != null) {
            block12: {
                try {
                    Runnable runnable = assertionsByFaultKey.get(faultKey);
                    if (runnable != null) {
                        GrpcTestUtils.setInsideOfAssertOnFaultBlock(true);
                        runnable.run();
                        break block12;
                    }
                    throw new FilibusterGrpcTestInternalRuntimeException("runnable is null: this could indicate a problem!");
                }
                catch (Throwable t) {
                    throw new FilibusterGrpcAssertOnFaultException(t);
                }
                finally {
                    GrpcTestUtils.setInsideOfAssertOnFaultBlock(true);
                }
            }
            return false;
        }
        HashSet<JSONObject> methodsWithFaultImpact = new HashSet<JSONObject>();
        for (JSONObject rpcWhereFaultInjected : rpcsWhereFaultsInjected) {
            boolean found = false;
            for (FaultKey faultKey2 : SingleFaultKey.generateFaultKeysInDecreasingGranularity(rpcWhereFaultInjected)) {
                if (!faultKeysWithNoImpact.contains(faultKey2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            methodsWithFaultImpact.add(rpcWhereFaultInjected);
        }
        if (methodsWithFaultImpact.size() == 0) {
            return true;
        }
        if (methodsWithFaultImpact.size() == 1) {
            rpcsWhereFaultsInjectedWithImpact = new ArrayList<JSONObject>(methodsWithFaultImpact);
            return this.performSingleFaultChecking((JSONObject)rpcsWhereFaultsInjectedWithImpact.get(0));
        }
        if (methodsWithFaultImpact.size() < rpcsWhereFaultsInjected.size()) {
            rpcsWhereFaultsInjectedWithImpact = new ArrayList(methodsWithFaultImpact);
            return this.performMultipleFaultChecking(rpcsWhereFaultsInjectedWithImpact);
        }
        throw new FilibusterGrpcAmbiguousFailureHandlingException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void execute() {
        block35: {
            List<JSONObject> rpcsWhereFaultsInjected;
            GrpcMock.resetAdjustedExpectations();
            GrpcMock.resetVerifyThatMapping();
            response.set(null);
            errorAssertions.clear();
            faultKeysThatThrow.clear();
            faultKeysThatPropagate.clear();
            faultKeysWithNoImpact.clear();
            assertionsByFaultKey.clear();
            Helpers.setupBlock(this::setupBlock);
            GrpcTestUtils.setInsideOfStubBlock(true);
            Helpers.setupBlock(this::stubBlock);
            GrpcTestUtils.setInsideOfStubBlock(false);
            GrpcTestUtils.setInsideOfFailureBlock(true);
            Helpers.setupBlock(this::failureBlock);
            GrpcTestUtils.setInsideOfFailureBlock(false);
            try {
                Helpers.testBlock(this::executeTestBlock);
                boolean shouldRunAssertionBlock = true;
                rpcsWhereFaultsInjected = this.rpcsWhereFaultsInjected();
                if (rpcsWhereFaultsInjected == null) {
                    throw new FilibusterGrpcTestInternalRuntimeException("rpcsWhereFaultsInjected is null: this could indicate a problem!");
                }
                if (rpcsWhereFaultsInjected.size() > 0) {
                    shouldRunAssertionBlock = rpcsWhereFaultsInjected.size() > 1 ? this.performMultipleFaultChecking(rpcsWhereFaultsInjected) : this.performSingleFaultChecking(rpcsWhereFaultsInjected.get(0));
                }
                if (shouldRunAssertionBlock) {
                    try {
                        Helpers.assertionBlock(this::assertTestBlock);
                    }
                    catch (Throwable t) {
                        if (rpcsWhereFaultsInjected.size() > 1) {
                            throw new FilibusterGrpcMultipleFaultsInjectedException(t);
                        }
                        throw new FilibusterGrpcAssertTestBlockFailedException(t);
                    }
                }
                GrpcTestUtils.setInsideOfAssertStubBlock(true);
                Helpers.assertionBlock(this::assertStubBlock);
            }
            catch (StatusRuntimeException statusRuntimeException) {
                List<FaultKey> faultKeysIndicatingThrownExceptionFromFault;
                rpcsWhereFaultsInjected = this.rpcsWhereFaultsInjected();
                if (rpcsWhereFaultsInjected == null) {
                    throw new FilibusterGrpcTestInternalRuntimeException("rpcsWhereFaultsInjected is null: this could indicate a problem!");
                }
                if (rpcsWhereFaultsInjected.size() == 0) {
                    throw statusRuntimeException;
                }
                if (rpcsWhereFaultsInjected.size() > 1) {
                    this.performMultipleExceptionChecking(rpcsWhereFaultsInjected, statusRuntimeException);
                    break block35;
                }
                JSONObject rpcWhereFaultInjected = rpcsWhereFaultsInjected.get(0);
                Status status = statusRuntimeException.getStatus();
                FaultKey faultKeyIndicatingPropagationOfFaults = this.didUserIndicatePropagationOfFault(rpcWhereFaultInjected);
                if (faultKeyIndicatingPropagationOfFaults != null) {
                    this.validatePropagationOfFault(rpcWhereFaultInjected, status);
                }
                if ((faultKeysIndicatingThrownExceptionFromFault = this.didUserIndicateThrownExceptionForFault(rpcWhereFaultInjected)).size() > 0) {
                    this.validateThrownException(faultKeysIndicatingThrownExceptionFromFault, statusRuntimeException);
                }
                if (faultKeyIndicatingPropagationOfFaults == null && faultKeysIndicatingThrownExceptionFromFault.size() == 0) {
                    throw new FilibusterGrpcThrownExceptionHasUnspecifiedFailureBehaviorException(statusRuntimeException);
                }
                if (faultKeyIndicatingPropagationOfFaults != null && faultKeysIndicatingThrownExceptionFromFault.size() > 0) {
                    throw new FilibusterGrpcAmbiguousThrowAndErrorPropagationException();
                }
                if (!errorAssertions.containsKey(statusRuntimeException.getStatus().getCode())) {
                    throw new FilibusterGrpcMissingAssertionForStatusCodeException(status.getCode());
                }
                for (Map.Entry<Status.Code, Runnable> errorAssertion : errorAssertions.entrySet()) {
                    if (!errorAssertion.getKey().equals((Object)statusRuntimeException.getStatus().getCode())) continue;
                    try {
                        GrpcTestUtils.setInsideOfAssertOnExceptionBlock(true);
                        errorAssertion.getValue().run();
                    }
                    catch (Throwable t) {
                        throw new FilibusterGrpcAssertionsForAssertOnExceptionFailedException(status.getCode(), t);
                    }
                    finally {
                        GrpcTestUtils.setInsideOfAssertOnExceptionBlock(false);
                    }
                }
                try {
                    GrpcTestUtils.setInsideOfAssertStubBlock(true);
                    Helpers.assertionBlock(this::assertStubBlock);
                }
                catch (Throwable t) {
                    throw new FilibusterGrpcAssertionsDidNotHoldUnderErrorResponseException(status.getCode(), t);
                }
                finally {
                    GrpcTestUtils.setInsideOfAssertStubBlock(false);
                }
                this.performSingleExceptionChecking(rpcsWhereFaultsInjected.get(0), statusRuntimeException);
            }
            finally {
                GrpcTestUtils.setInsideOfAssertStubBlock(false);
                Helpers.teardownBlock(this::teardownBlock);
            }
        }
        Map<DistributedExecutionIndex, JSONObject> failedRpcs = this.getFailedRpcs();
        if (failedRpcs == null) {
            throw new FilibusterGrpcTestInternalRuntimeException("failedRpcs is null: this could indicate a problem!");
        }
        Map<DistributedExecutionIndex, JSONObject> faultsInjected = this.getFaultsInjected();
        if (faultsInjected == null) {
            throw new FilibusterGrpcTestInternalRuntimeException("faultsInjected is null: this could indicate a problem!");
        }
        for (Map.Entry<DistributedExecutionIndex, JSONObject> entry : failedRpcs.entrySet()) {
            boolean faultInjected;
            DistributedExecutionIndex distributedExecutionIndex = entry.getKey();
            JSONObject jsonObject = entry.getValue();
            Status.Code statusCode = this.getStatusCode("exception", jsonObject);
            if (statusCode == null) {
                throw new FilibusterGrpcTestInternalRuntimeException("statusCode is null: this could indicate a problem!");
            }
            String code = statusCode.toString();
            if (!code.equals("UNIMPLEMENTED") || (faultInjected = faultsInjected.containsKey(distributedExecutionIndex))) continue;
            throw new FilibusterGrpcInvokedRPCUnimplementedException();
        }
        for (Map.Entry<Object, Object> entry : GrpcMock.getVerifyThatMapping().entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            throw new FilibusterGrpcStubbedRPCHasNoAssertionsException((String)entry.getKey());
        }
    }

    @Nullable
    default public Status.Code getStatusCode(String exceptionFieldName, JSONObject jsonObject) {
        if (jsonObject.has(exceptionFieldName)) {
            JSONObject exceptionJsonObject = jsonObject.getJSONObject(exceptionFieldName);
            if (exceptionJsonObject.has("metadata")) {
                JSONObject metadataExceptionJsonObject = exceptionJsonObject.getJSONObject("metadata");
                if (metadataExceptionJsonObject.has("code")) {
                    return Status.Code.valueOf((String)metadataExceptionJsonObject.getString("code"));
                }
                return null;
            }
            return null;
        }
        return null;
    }

    default public FaultKey didUserIndicatePropagationOfFault(JSONObject rpcWhereFaultInjected) {
        FaultKey foundFaultKey = null;
        for (FaultKey faultKey : SingleFaultKey.generateFaultKeysInDecreasingGranularity(rpcWhereFaultInjected)) {
            if (!faultKeysThatPropagate.contains(faultKey)) continue;
            foundFaultKey = faultKey;
            break;
        }
        return foundFaultKey;
    }

    default public List<FaultKey> didUserIndicateThrownExceptionForFault(JSONObject rpcWhereFaultInjected) {
        ArrayList<FaultKey> matchingFaultKeys = new ArrayList<FaultKey>();
        for (FaultKey faultKey : SingleFaultKey.generateFaultKeysInDecreasingGranularity(rpcWhereFaultInjected)) {
            if (!faultKeysThatThrow.containsKey(faultKey)) continue;
            matchingFaultKeys.add(faultKey);
            break;
        }
        return matchingFaultKeys;
    }

    default public void validatePropagationOfFault(JSONObject rpcWhereFaultInjected, Status actualStatus) {
        Status.Code injectedFaultStatusCode = this.getStatusCode("forced_exception", rpcWhereFaultInjected);
        if (injectedFaultStatusCode != null) {
            if (!actualStatus.getCode().equals((Object)injectedFaultStatusCode)) {
                throw new FilibusterGrpcSuppressedStatusCodeException();
            }
        } else {
            throw new FilibusterGrpcTestInternalRuntimeException("injectedFaultStatusCode is null; this could indicate a problem!");
        }
    }

    default public void validateThrownException(List<FaultKey> matchingFaultKeys, StatusRuntimeException statusRuntimeException) {
        Status actualStatus = statusRuntimeException.getStatus();
        boolean foundMatchingExpectedStatus = false;
        for (FaultKey matchingFaultKey : matchingFaultKeys) {
            Map.Entry<Status.Code, String> expectedException = faultKeysThatThrow.get(matchingFaultKey);
            if (expectedException == null) {
                throw new FilibusterGrpcTestInternalRuntimeException("expectedException is null; this could indicate a problem!");
            }
            Status expectedStatus = Status.fromCode((Status.Code)expectedException.getKey()).withDescription(expectedException.getValue());
            boolean codeMatches = expectedStatus.getCode().equals((Object)actualStatus.getCode());
            boolean descriptionMatches = Objects.equals(expectedStatus.getDescription(), actualStatus.getDescription());
            if (!codeMatches || !descriptionMatches) continue;
            foundMatchingExpectedStatus = true;
            break;
        }
        if (!foundMatchingExpectedStatus) {
            throw new FilibusterGrpcFailedRPCException(statusRuntimeException);
        }
    }

    default public void performMultipleExceptionChecking(List<JSONObject> rpcsWhereFaultsInjected, StatusRuntimeException statusRuntimeException) {
        ArrayList<JSONObject> rpcsWhereFaultsInjectedWithImpact;
        Status actualStatus = statusRuntimeException.getStatus();
        List<FaultKey> faultKeysIndicatingThrownExceptionFromFault = CompositeFaultKey.findMatchingFaultKeys(faultKeysThatThrow, rpcsWhereFaultsInjected, actualStatus.getCode());
        if (faultKeysIndicatingThrownExceptionFromFault == null) {
            throw new FilibusterGrpcTestInternalRuntimeException("faultKeysIndicatingThrownExceptionFromFault is null: this could indicate a problem!");
        }
        if (faultKeysIndicatingThrownExceptionFromFault.size() > 0) {
            this.validateThrownException(faultKeysIndicatingThrownExceptionFromFault, statusRuntimeException);
            this.verifyAssertionBlockForThrownException(statusRuntimeException);
            return;
        }
        HashSet<JSONObject> methodsWithFaultImpact = new HashSet<JSONObject>();
        for (JSONObject rpcWhereFaultInjected : rpcsWhereFaultsInjected) {
            boolean found = false;
            for (FaultKey faultKey : SingleFaultKey.generateFaultKeysInDecreasingGranularity(rpcWhereFaultInjected)) {
                if (!faultKeysWithNoImpact.contains(faultKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            methodsWithFaultImpact.add(rpcWhereFaultInjected);
        }
        if (methodsWithFaultImpact.size() == 0) {
            return;
        }
        if (methodsWithFaultImpact.size() == 1) {
            rpcsWhereFaultsInjectedWithImpact = new ArrayList<JSONObject>(methodsWithFaultImpact);
            this.performSingleExceptionChecking((JSONObject)rpcsWhereFaultsInjectedWithImpact.get(0), statusRuntimeException);
        } else if (methodsWithFaultImpact.size() < rpcsWhereFaultsInjected.size()) {
            rpcsWhereFaultsInjectedWithImpact = new ArrayList(methodsWithFaultImpact);
            this.performMultipleExceptionChecking(rpcsWhereFaultsInjectedWithImpact, statusRuntimeException);
        } else {
            throw new FilibusterGrpcAmbiguousFailureHandlingException(statusRuntimeException);
        }
    }

    default public void performSingleExceptionChecking(JSONObject rpcWhereFaultInjected, StatusRuntimeException statusRuntimeException) {
        List<FaultKey> faultKeysIndicatingThrownExceptionFromFault;
        Status actualStatus = statusRuntimeException.getStatus();
        FaultKey faultKeyIndicatingPropagationOfFaults = this.didUserIndicatePropagationOfFault(rpcWhereFaultInjected);
        if (faultKeyIndicatingPropagationOfFaults != null) {
            this.validatePropagationOfFault(rpcWhereFaultInjected, actualStatus);
        }
        if ((faultKeysIndicatingThrownExceptionFromFault = this.didUserIndicateThrownExceptionForFault(rpcWhereFaultInjected)).size() > 0) {
            this.validateThrownException(faultKeysIndicatingThrownExceptionFromFault, statusRuntimeException);
        }
        if (faultKeyIndicatingPropagationOfFaults == null && faultKeysIndicatingThrownExceptionFromFault.size() == 0) {
            throw new FilibusterGrpcThrownExceptionHasUnspecifiedFailureBehaviorException(statusRuntimeException);
        }
        if (faultKeyIndicatingPropagationOfFaults != null && faultKeysIndicatingThrownExceptionFromFault.size() > 0) {
            throw new FilibusterGrpcAmbiguousThrowAndErrorPropagationException();
        }
        this.verifyAssertionBlockForThrownException(statusRuntimeException);
    }

    default public void verifyAssertionBlockForThrownException(StatusRuntimeException statusRuntimeException) {
        Status actualStatus = statusRuntimeException.getStatus();
        if (!errorAssertions.containsKey(statusRuntimeException.getStatus().getCode())) {
            throw new FilibusterGrpcMissingAssertionForStatusCodeException(actualStatus.getCode());
        }
        for (Map.Entry<Status.Code, Runnable> errorAssertion : errorAssertions.entrySet()) {
            if (!errorAssertion.getKey().equals((Object)statusRuntimeException.getStatus().getCode())) continue;
            try {
                GrpcTestUtils.setInsideOfAssertOnExceptionBlock(true);
                errorAssertion.getValue().run();
            }
            catch (Throwable t) {
                throw new FilibusterGrpcAssertionsForAssertOnExceptionFailedException(actualStatus.getCode(), t);
            }
            finally {
                GrpcTestUtils.setInsideOfAssertOnExceptionBlock(false);
            }
        }
        try {
            GrpcTestUtils.setInsideOfAssertStubBlock(true);
            Helpers.assertionBlock(this::assertStubBlock);
        }
        catch (Throwable t) {
            throw new FilibusterGrpcAssertionsDidNotHoldUnderErrorResponseException(actualStatus.getCode(), t);
        }
        finally {
            GrpcTestUtils.setInsideOfAssertStubBlock(false);
        }
    }

    default public Map<DistributedExecutionIndex, JSONObject> getFailedRpcs() {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().failedRpcs();
            }
            return new HashMap<DistributedExecutionIndex, JSONObject>();
        }
        throw new FilibusterUnsupportedAPIException("This API is currently not supported. If applicable, please import the GRPC variant of this method instead.");
    }

    default public Map<DistributedExecutionIndex, JSONObject> getFaultsInjected() {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().faultsInjected();
            }
            return new HashMap<DistributedExecutionIndex, JSONObject>();
        }
        throw new FilibusterUnsupportedAPIException("This API is currently not supported. If applicable, please import the GRPC variant of this method instead.");
    }

    default public Map<DistributedExecutionIndex, JSONObject> getExecutedRpcs() {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().executedRpcs();
            }
            return new HashMap<DistributedExecutionIndex, JSONObject>();
        }
        throw new FilibusterUnsupportedAPIException("This API is currently not supported. If applicable, please import the GRPC variant of this method instead.");
    }
}

