/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.statem;

import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestInternalRuntimeException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcStubForUsedOutsideStubBlockException;
import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestRuntimeException.FilibusterGrpcVerifyThatUsedOutsideAssertStubException;
import cloud.filibuster.junit.assertions.protocols.GrpcAssertions;
import cloud.filibuster.junit.statem.GrpcTestUtils;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.MethodDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.stub.steps.MethodStubBuilder;
import org.grpcmock.definitions.stub.steps.UnaryMethodStubBuilderStep;
import org.grpcmock.definitions.verification.CountMatcher;
import org.grpcmock.definitions.verification.steps.RequestPatternBuilderStep;

public class GrpcMock {
    private static HashMap<String, Integer> adjustedExpectationsForMethods = new HashMap();
    private static HashMap<String, Integer> adjustedExpectationsForRequests = new HashMap();
    private static HashMap<String, Boolean> verifyThatMapping = new HashMap();

    public static void resetAdjustedExpectations() {
        adjustedExpectationsForMethods = new HashMap();
        adjustedExpectationsForRequests = new HashMap();
    }

    public static <ReqT> void adjustExpectation(@Nonnull MethodDescriptor<ReqT, ?> method, int count) {
        adjustedExpectationsForMethods.put(method.getFullMethodName(), count);
    }

    public static <ReqT> void adjustExpectation(@Nonnull MethodDescriptor<ReqT, ?> method, @Nonnull ReqT request, int count) {
        adjustedExpectationsForRequests.put(method.getFullMethodName() + request, count);
    }

    public static Map<String, Boolean> getVerifyThatMapping() {
        return verifyThatMapping;
    }

    public static void resetVerifyThatMapping() {
        verifyThatMapping = new HashMap();
    }

    public static <ReqT, RespT> void stubFor(@Nonnull MethodDescriptor<ReqT, RespT> method, @Nonnull ReqT request, @Nonnull RespT response) {
        if (!GrpcTestUtils.isInsideOfStubBlock()) {
            throw new FilibusterGrpcStubForUsedOutsideStubBlockException();
        }
        verifyThatMapping.put(method.getFullMethodName(), false);
        org.grpcmock.GrpcMock.stubFor((MethodStubBuilder)((MethodStubBuilder)((UnaryMethodStubBuilderStep)org.grpcmock.GrpcMock.unaryMethod(method).withRequest(request)).willReturn(response)));
    }

    public static <ReqT> void verifyThat(@Nonnull MethodDescriptor<ReqT, ?> method, int count) {
        if (GrpcTestUtils.getInsideOfAssertStubBlock()) {
            verifyThatMapping.put(method.getFullMethodName(), true);
            if (GrpcAssertions.wasFaultInjectedOnMethod(method) && count > 0) {
                --count;
            }
            if (adjustedExpectationsForMethods.containsKey(method.getFullMethodName())) {
                count = adjustedExpectationsForMethods.get(method.getFullMethodName());
            }
            if (count == -1) {
                org.grpcmock.GrpcMock.verifyThat((RequestPatternBuilderStep)org.grpcmock.GrpcMock.calledMethod(method), (CountMatcher)org.grpcmock.GrpcMock.atLeast((int)0));
            } else {
                org.grpcmock.GrpcMock.verifyThat((RequestPatternBuilderStep)org.grpcmock.GrpcMock.calledMethod(method), (CountMatcher)org.grpcmock.GrpcMock.times((int)count));
            }
        } else {
            throw new FilibusterGrpcVerifyThatUsedOutsideAssertStubException();
        }
    }

    public static <ReqT> void verifyThat(@Nonnull MethodDescriptor<ReqT, ?> method, @Nonnull ReqT request, int count) {
        if (GrpcTestUtils.getInsideOfAssertStubBlock()) {
            verifyThatMapping.put(method.getFullMethodName(), true);
            boolean wasFaultInjected = false;
            if (request instanceof GeneratedMessageV3) {
                wasFaultInjected = GrpcAssertions.wasFaultInjectedOnRequest((GeneratedMessageV3)request);
            } else if (request instanceof GeneratedMessage) {
                wasFaultInjected = GrpcAssertions.wasFaultInjectedOnRequest((GeneratedMessage)request);
            } else {
                throw new FilibusterGrpcTestInternalRuntimeException("Something went wrong, message isn't a GeneratedMessage or GeneratedMessageV3: " + request);
            }
            if (wasFaultInjected && count > 0) {
                --count;
            }
            for (Map.Entry<String, Integer> adjustedExpectationsForRequest : adjustedExpectationsForRequests.entrySet()) {
                if (!adjustedExpectationsForRequest.getKey().equals(method.getFullMethodName() + request)) continue;
                count = adjustedExpectationsForRequest.getValue();
            }
            if (count == -1) {
                org.grpcmock.GrpcMock.verifyThat((RequestPatternBuilderStep)((RequestPatternBuilderStep)org.grpcmock.GrpcMock.calledMethod(method).withRequest(request)), (CountMatcher)org.grpcmock.GrpcMock.atLeast((int)0));
            } else {
                org.grpcmock.GrpcMock.verifyThat((RequestPatternBuilderStep)((RequestPatternBuilderStep)org.grpcmock.GrpcMock.calledMethod(method).withRequest(request)), (CountMatcher)org.grpcmock.GrpcMock.times((int)count));
            }
        } else {
            throw new FilibusterGrpcVerifyThatUsedOutsideAssertStubException();
        }
    }
}

