/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.statem.keys;

import cloud.filibuster.exceptions.filibuster.FilibusterGrpcTestInternalRuntimeException;
import cloud.filibuster.junit.statem.CompositeFaultSpecification;
import cloud.filibuster.junit.statem.keys.FaultKey;
import cloud.filibuster.junit.statem.keys.SingleFaultKey;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class CompositeFaultKey
implements FaultKey {
    private final List<SingleFaultKey> faultKeys;

    public CompositeFaultKey(CompositeFaultSpecification compositeFaultSpecification) {
        this.faultKeys = compositeFaultSpecification.getFaultKeys();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CompositeFaultKey)) {
            return false;
        }
        CompositeFaultKey cfk = (CompositeFaultKey)other;
        if (this.faultKeys.size() != cfk.faultKeys.size()) {
            return false;
        }
        for (SingleFaultKey faultKey : this.faultKeys) {
            if (cfk.faultKeys.contains(faultKey)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder toStringResult = new StringBuilder();
        for (SingleFaultKey faultKey : this.faultKeys) {
            toStringResult.append(faultKey.toString());
        }
        return toStringResult.toString();
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    @Override
    public int size() {
        return this.faultKeys.size();
    }

    @Nullable
    public static FaultKey findMatchingFaultKey(Map<FaultKey, Runnable> assertionsByFaultKey, List<JSONObject> rpcsWhereFaultsInjected) {
        List<List<SingleFaultKey>> rpcsWhereFaultsInjectedFaultKeys = rpcsWhereFaultsInjected.stream().map(SingleFaultKey::generateFaultKeysInDecreasingGranularity).collect(Collectors.toList());
        ArrayList<FaultKey> previousIterationMatching = new ArrayList<FaultKey>();
        for (Map.Entry<FaultKey, Runnable> assertionByFaultKey : assertionsByFaultKey.entrySet()) {
            previousIterationMatching.add(assertionByFaultKey.getKey());
        }
        List<FaultKey> iterationMatching = CompositeFaultKey.performIterableMatching(previousIterationMatching, rpcsWhereFaultsInjectedFaultKeys, rpcsWhereFaultsInjected);
        if (iterationMatching.size() == 1) {
            return iterationMatching.get(0);
        }
        if (iterationMatching.size() > 1) {
            throw new FilibusterGrpcTestInternalRuntimeException("iterationMatching.size() > 1; this indicates there is a problem!");
        }
        return null;
    }

    @Nullable
    public static List<FaultKey> findMatchingFaultKeys(Map<FaultKey, Map.Entry<Status.Code, String>> assertionsByFaultKey, List<JSONObject> rpcsWhereFaultsInjected, Status.Code code) {
        List<List<SingleFaultKey>> rpcsWhereFaultsInjectedFaultKeys = rpcsWhereFaultsInjected.stream().map(SingleFaultKey::generateFaultKeysInDecreasingGranularity).collect(Collectors.toList());
        ArrayList<FaultKey> previousIterationMatching = new ArrayList<FaultKey>();
        for (Map.Entry<FaultKey, Map.Entry<Status.Code, String>> assertionByFaultKey : assertionsByFaultKey.entrySet()) {
            if (!assertionByFaultKey.getValue().getKey().equals((Object)code)) continue;
            previousIterationMatching.add(assertionByFaultKey.getKey());
        }
        return CompositeFaultKey.performIterableMatching(previousIterationMatching, rpcsWhereFaultsInjectedFaultKeys, rpcsWhereFaultsInjected);
    }

    public static List<FaultKey> performIterableMatching(List<FaultKey> previousIterationMatching, List<List<SingleFaultKey>> rpcsWhereFaultsInjectedFaultKeys, List<JSONObject> rpcsWhereFaultsInjected) {
        ArrayList<FaultKey> iterationMatching;
        for (List<SingleFaultKey> singleFaultKeys : rpcsWhereFaultsInjectedFaultKeys) {
            iterationMatching = new ArrayList();
            for (SingleFaultKey singleFaultKey : singleFaultKeys) {
                String sSingleFaultKey = singleFaultKey.toString();
                for (FaultKey assertionByFaultKey : previousIterationMatching) {
                    if (!assertionByFaultKey.toString().contains(sSingleFaultKey)) continue;
                    iterationMatching.add(assertionByFaultKey);
                }
            }
            previousIterationMatching = new ArrayList<FaultKey>(iterationMatching);
        }
        iterationMatching = new ArrayList<FaultKey>();
        for (FaultKey faultKey : previousIterationMatching) {
            if (faultKey.size() != rpcsWhereFaultsInjected.size()) continue;
            iterationMatching.add(faultKey);
        }
        return iterationMatching;
    }
}

