/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv2.TestUtils;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.modules.junit4.PowerMockRunnerDelegate;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;

@RunWith(value=PowerMockRunner.class)
@PowerMockRunnerDelegate(value=LocalstackTestRunner.class)
@PrepareForTest(value={KinesisAsyncClient.class, DynamoDbAsyncClient.class, SqsAsyncClient.class, SnsAsyncClient.class, SsmAsyncClient.class, SecretsManagerAsyncClient.class, S3AsyncClient.class, CloudWatchAsyncClient.class})
@PowerMockIgnore(value={"javax.crypto.*", "org.hamcrest.*", "javax.net.ssl.*", "com.sun.org.apache.xerces.*", "javax.xml.*", "org.xml.*", "javax.management.*", "javax.security.*", "org.w3c.*"})
public abstract class PowerMockLocalStack {
    public static void mockKinesisAsync() {
        KinesisAsyncClient mockService = TestUtils.getClientKinesisAsyncV2();
        PowerMockito.mockStatic(KinesisAsyncClient.class, (Class[])new Class[0]);
        Mockito.when((Object)KinesisAsyncClient.create()).thenReturn((Object)mockService);
    }

    public static void mockDynamoDBAsync() {
        DynamoDbAsyncClient mockService = TestUtils.getClientDyanamoAsyncV2();
        PowerMockito.mockStatic(DynamoDbAsyncClient.class, (Class[])new Class[0]);
        Mockito.when((Object)DynamoDbAsyncClient.create()).thenReturn((Object)mockService);
    }

    public static void mockSQSAsyncClient() {
        SqsAsyncClient mockService = TestUtils.getClientSQSAsyncV2();
        PowerMockito.mockStatic(SqsAsyncClient.class, (Class[])new Class[0]);
        Mockito.when((Object)SqsAsyncClient.create()).thenReturn((Object)mockService);
    }

    public static void mockSSMAsyncClient() {
        SsmAsyncClient mockService = TestUtils.getClientSSMAsyncV2();
        PowerMockito.mockStatic(SsmAsyncClient.class, (Class[])new Class[0]);
        Mockito.when((Object)SsmAsyncClient.create()).thenReturn((Object)mockService);
    }

    public static void mockSecretsManagerAsyncClient() {
        SecretsManagerAsyncClient mockService = TestUtils.getClientSecretsManagerAsyncV2();
        PowerMockito.mockStatic(SecretsManagerAsyncClient.class, (Class[])new Class[0]);
        Mockito.when((Object)SecretsManagerAsyncClient.create()).thenReturn((Object)mockService);
    }

    public static void mockS3AsyncClient() {
        S3AsyncClient mockService = TestUtils.getClientS3AsyncV2();
        PowerMockito.mockStatic(S3AsyncClient.class, (Class[])new Class[0]);
        Mockito.when((Object)S3AsyncClient.create()).thenReturn((Object)mockService);
    }

    public static void mockCloudWatchAsyncClient() {
        CloudWatchAsyncClient mockService = TestUtils.getClientCloudWatchAsyncV2();
        PowerMockito.mockStatic(CloudWatchAsyncClient.class, (Class[])new Class[0]);
        Mockito.when((Object)CloudWatchAsyncClient.create()).thenReturn((Object)mockService);
    }
}

