/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LambdaContext
implements Context {
    private static final int DEFAULT_MEMORY_SIZE_IN_MB = 256;
    private static final String DEFAULT_ACCOUNT_ID = "123456789012";
    private static final String DEFAULT_REGION = "us-east-1";
    private static final String DEFAULT_FUNCTION_NAME = "localstack";
    private static final String DEFAULT_FUNCTION_VERSION = "$LATEST";
    private static final String TODAY = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
    private static final String CONTAINER_ID = UUID.randomUUID().toString();
    private final Logger LOG = Logger.getLogger(LambdaContext.class.getName());
    private final String requestId;

    public LambdaContext(String requestId) {
        this.requestId = requestId;
    }

    public String getAwsRequestId() {
        return this.requestId;
    }

    public String getFunctionName() {
        String functionName = System.getenv("AWS_LAMBDA_FUNCTION_NAME");
        if (functionName == null) {
            functionName = DEFAULT_FUNCTION_NAME;
        }
        return functionName;
    }

    public String getFunctionVersion() {
        String functionVersion = System.getenv("AWS_LAMBDA_FUNCTION_VERSION");
        if (functionVersion == null) {
            functionVersion = DEFAULT_FUNCTION_VERSION;
        }
        return functionVersion;
    }

    public String getInvokedFunctionArn() {
        String region = System.getenv("AWS_REGION");
        if (region == null) {
            region = DEFAULT_REGION;
        }
        return String.format("arn:aws:%s:%s:function:%s:%s", region, DEFAULT_ACCOUNT_ID, this.getFunctionName(), this.getFunctionVersion());
    }

    public String getLogGroupName() {
        return String.format("/aws/lambda/%s", this.getFunctionName());
    }

    public String getLogStreamName() {
        return String.format("%s[%s]%s", TODAY, this.getFunctionVersion(), CONTAINER_ID);
    }

    public int getMemoryLimitInMB() {
        String memorySize = System.getenv("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
        if (memorySize == null) {
            return 256;
        }
        try {
            return Integer.parseInt(memorySize);
        }
        catch (NumberFormatException e) {
            return 256;
        }
    }

    public int getRemainingTimeInMillis() {
        return Integer.MAX_VALUE;
    }

    public LambdaLogger getLogger() {
        return new LambdaLogger(){

            public void log(String msg) {
                LambdaContext.this.LOG.log(Level.INFO, msg);
            }

            public void log(byte[] msg) {
                this.log(new String(msg));
            }
        };
    }

    public ClientContext getClientContext() {
        return null;
    }

    public CognitoIdentity getIdentity() {
        return null;
    }
}

