/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.Localstack;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkAsyncClientBuilder;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.qldb.QldbAsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.utils.AttributeMap;

public class TestUtils {
    public static KinesisAsyncClient getClientKinesisAsyncV2() {
        return (KinesisAsyncClient)TestUtils.wrapApiClientV2(KinesisAsyncClient.builder(), Localstack.INSTANCE.getEndpointKinesis()).build();
    }

    public static DynamoDbAsyncClient getClientDyanamoAsyncV2() {
        return (DynamoDbAsyncClient)TestUtils.wrapApiClientV2(DynamoDbAsyncClient.builder(), Localstack.INSTANCE.getEndpointDynamoDB()).build();
    }

    public static SqsAsyncClient getClientSQSAsyncV2() {
        return (SqsAsyncClient)TestUtils.wrapApiClientV2(SqsAsyncClient.builder(), Localstack.INSTANCE.getEndpointSQS()).build();
    }

    public static QldbAsyncClient getClientQLDBAsyncV2() {
        return (QldbAsyncClient)TestUtils.wrapApiClientV2(QldbAsyncClient.builder(), Localstack.INSTANCE.getEndpointQLDB()).build();
    }

    public static SnsAsyncClient getClientSNSAsyncV2() {
        return (SnsAsyncClient)TestUtils.wrapApiClientV2(SnsAsyncClient.builder(), Localstack.INSTANCE.getEndpointSNS()).build();
    }

    public static SsmAsyncClient getClientSSMAsyncV2() {
        return (SsmAsyncClient)TestUtils.wrapApiClientV2(SsmAsyncClient.builder(), Localstack.INSTANCE.getEndpointSSM()).build();
    }

    public static SecretsManagerAsyncClient getClientSecretsManagerAsyncV2() {
        return (SecretsManagerAsyncClient)TestUtils.wrapApiClientV2(SecretsManagerAsyncClient.builder(), Localstack.INSTANCE.getEndpointSSM()).build();
    }

    public static S3AsyncClient getClientS3AsyncV2() {
        return (S3AsyncClient)TestUtils.wrapApiClientV2(S3AsyncClient.builder(), Localstack.INSTANCE.getEndpointS3()).build();
    }

    public static CloudWatchAsyncClient getClientCloudWatchAsyncV2() {
        return (CloudWatchAsyncClient)TestUtils.wrapApiClientV2(CloudWatchAsyncClient.builder(), Localstack.INSTANCE.getEndpointCloudWatch()).build();
    }

    public static LambdaAsyncClient getClientLambdaAsyncV2() {
        return (LambdaAsyncClient)TestUtils.wrapApiClientV2(LambdaAsyncClient.builder(), Localstack.INSTANCE.getEndpointLambda()).build();
    }

    public static IamAsyncClient getClientIamAsyncV2() {
        return (IamAsyncClient)TestUtils.wrapApiClientV2(IamAsyncClient.builder(), Localstack.INSTANCE.getEndpointIAM()).build();
    }

    public static <T extends SdkAsyncClientBuilder> T wrapApiClientV2(T builder, String endpointURL) {
        try {
            return (T)((SdkAsyncClientBuilder)((AwsClientBuilder)builder.httpClient(NettyNioAsyncHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build()))).credentialsProvider(TestUtils.getCredentialsV2()).region(Region.of((String)Localstack.INSTANCE.getDefaultRegion())).endpointOverride(new URI(endpointURL)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static AwsCredentialsProvider getCredentialsV2() throws Exception {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"access", (String)"secret"));
    }
}

