/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.Localstack;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkAsyncClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.qldb.QldbAsyncClient;
import software.amazon.awssdk.services.qldb.QldbClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.utils.AttributeMap;

public class TestUtils {
    public static KinesisAsyncClient getClientKinesisAsyncV2() {
        return (KinesisAsyncClient)TestUtils.wrapApiAsyncClientV2(KinesisAsyncClient.builder(), Localstack.INSTANCE.getEndpointKinesis()).build();
    }

    public static KinesisClient getClientKinesisV2() {
        return (KinesisClient)TestUtils.wrapApiSyncClientV2(KinesisClient.builder(), Localstack.INSTANCE.getEndpointKinesis()).build();
    }

    public static DynamoDbAsyncClient getClientDyanamoAsyncV2() {
        return (DynamoDbAsyncClient)TestUtils.wrapApiAsyncClientV2(DynamoDbAsyncClient.builder(), Localstack.INSTANCE.getEndpointDynamoDB()).build();
    }

    public static DynamoDbClient getClientDyanamoV2() {
        return (DynamoDbClient)TestUtils.wrapApiSyncClientV2(DynamoDbClient.builder(), Localstack.INSTANCE.getEndpointDynamoDB()).build();
    }

    public static SqsAsyncClient getClientSQSAsyncV2() {
        return (SqsAsyncClient)TestUtils.wrapApiAsyncClientV2(SqsAsyncClient.builder(), Localstack.INSTANCE.getEndpointSQS()).build();
    }

    public static SqsClient getClientSQSV2() {
        return (SqsClient)TestUtils.wrapApiSyncClientV2(SqsClient.builder(), Localstack.INSTANCE.getEndpointSQS()).build();
    }

    public static QldbAsyncClient getClientQLDBAsyncV2() {
        return (QldbAsyncClient)TestUtils.wrapApiAsyncClientV2(QldbAsyncClient.builder(), Localstack.INSTANCE.getEndpointQLDB()).build();
    }

    public static QldbClient getClientQLDBV2() {
        return (QldbClient)TestUtils.wrapApiSyncClientV2(QldbClient.builder(), Localstack.INSTANCE.getEndpointQLDB()).build();
    }

    public static SnsAsyncClient getClientSNSAsyncV2() {
        return (SnsAsyncClient)TestUtils.wrapApiAsyncClientV2(SnsAsyncClient.builder(), Localstack.INSTANCE.getEndpointSNS()).build();
    }

    public static SnsClient getClientSNSV2() {
        return (SnsClient)TestUtils.wrapApiSyncClientV2(SnsClient.builder(), Localstack.INSTANCE.getEndpointSNS()).build();
    }

    public static SsmAsyncClient getClientSSMAsyncV2() {
        return (SsmAsyncClient)TestUtils.wrapApiAsyncClientV2(SsmAsyncClient.builder(), Localstack.INSTANCE.getEndpointSSM()).build();
    }

    public static SsmClient getClientSSMV2() {
        return (SsmClient)TestUtils.wrapApiSyncClientV2(SsmClient.builder(), Localstack.INSTANCE.getEndpointSSM()).build();
    }

    public static SecretsManagerAsyncClient getClientSecretsManagerAsyncV2() {
        return (SecretsManagerAsyncClient)TestUtils.wrapApiAsyncClientV2(SecretsManagerAsyncClient.builder(), Localstack.INSTANCE.getEndpointSSM()).build();
    }

    public static SecretsManagerClient getClientSecretsManagerV2() {
        return (SecretsManagerClient)TestUtils.wrapApiSyncClientV2(SecretsManagerClient.builder(), Localstack.INSTANCE.getEndpointSSM()).build();
    }

    public static S3AsyncClient getClientS3AsyncV2() {
        return (S3AsyncClient)TestUtils.wrapApiAsyncClientV2(S3AsyncClient.builder(), Localstack.INSTANCE.getEndpointS3()).build();
    }

    public static S3Client getClientS3V2() {
        return (S3Client)TestUtils.wrapApiSyncClientV2(S3Client.builder(), Localstack.INSTANCE.getEndpointS3()).build();
    }

    public static CloudWatchAsyncClient getClientCloudWatchAsyncV2() {
        return (CloudWatchAsyncClient)TestUtils.wrapApiAsyncClientV2(CloudWatchAsyncClient.builder(), Localstack.INSTANCE.getEndpointCloudWatch()).build();
    }

    public static CloudWatchClient getClientCloudWatchV2() {
        return (CloudWatchClient)TestUtils.wrapApiSyncClientV2(CloudWatchClient.builder(), Localstack.INSTANCE.getEndpointCloudWatch()).build();
    }

    public static LambdaAsyncClient getClientLambdaAsyncV2() {
        return (LambdaAsyncClient)TestUtils.wrapApiAsyncClientV2(LambdaAsyncClient.builder(), Localstack.INSTANCE.getEndpointLambda()).build();
    }

    public static LambdaClient getClientLambdaV2() {
        return (LambdaClient)TestUtils.wrapApiSyncClientV2(LambdaClient.builder(), Localstack.INSTANCE.getEndpointLambda()).build();
    }

    public static IamAsyncClient getClientIamAsyncV2() {
        return (IamAsyncClient)TestUtils.wrapApiAsyncClientV2(IamAsyncClient.builder(), Localstack.INSTANCE.getEndpointIAM()).build();
    }

    public static IamClient getClientIamV2() {
        return (IamClient)TestUtils.wrapApiSyncClientV2(IamClient.builder(), Localstack.INSTANCE.getEndpointIAM()).build();
    }

    public static <T extends SdkAsyncClientBuilder> T wrapApiAsyncClientV2(T builder, String endpointURL) {
        try {
            return (T)((SdkAsyncClientBuilder)((AwsClientBuilder)builder.httpClient(NettyNioAsyncHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build()))).credentialsProvider(TestUtils.getCredentialsV2()).region(Region.of((String)Localstack.INSTANCE.getDefaultRegion())).endpointOverride(new URI(endpointURL)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SdkSyncClientBuilder> T wrapApiSyncClientV2(T builder, String endpointURL) {
        try {
            return (T)((SdkSyncClientBuilder)((AwsClientBuilder)builder.httpClient(ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build()))).credentialsProvider(TestUtils.getCredentialsV2()).region(Region.of((String)Localstack.INSTANCE.getDefaultRegion())).endpointOverride(new URI(endpointURL)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static AwsCredentialsProvider getCredentialsV2() throws Exception {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"access", (String)"secret"));
    }
}

