/*
 * Decompiled with CFR 0.152.
 */
package cloud.noetica.jacocolog;

import cloud.noetica.jacocolog.JacocoCounters;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.tools.ExecFileLoader;

public class CountersExtractor {
    private final Log log;
    private final String includes;

    public CountersExtractor(Log log, String includes) {
        this.log = log;
        this.includes = includes;
    }

    JacocoCounters extract(MavenProject project) {
        if (!Files.exists(Paths.get(project.getBuild().getDirectory(), new String[0]), new LinkOption[0])) {
            this.log.debug((CharSequence)"Project is not yet built");
            return null;
        }
        DirectoryScanner ds = new DirectoryScanner();
        String[] includes = new String[]{this.includes};
        ds.setIncludes(includes);
        ds.setBasedir(project.getBuild().getDirectory());
        ds.scan();
        String[] files = ds.getIncludedFiles();
        this.log.debug((CharSequence)"Found Jacoco files:");
        for (int i = 0; i < files.length; ++i) {
            this.log.debug((CharSequence)("- " + files[i]));
        }
        if (files.length == 0) {
            return null;
        }
        ExecutionDataStore store = this.extract((File[])Arrays.stream(files).map(f -> Paths.get(project.getBuild().getDirectory(), f).toFile()).toArray(File[]::new));
        return JacocoCounters.of(this.buildCounters(new File(project.getBuild().getOutputDirectory()), store));
    }

    private ExecutionDataStore extract(File ... files) {
        ExecutionDataStore store = new ExecutionDataStore();
        for (File file : files) {
            ExecFileLoader loader = new ExecFileLoader();
            try {
                loader.load(file);
                loader.getExecutionDataStore().getContents().forEach(arg_0 -> ((ExecutionDataStore)store).put(arg_0));
            }
            catch (IOException e) {
                this.log.debug((CharSequence)("An exception occured while reading file : " + file), (Throwable)e);
            }
        }
        return store;
    }

    private IBundleCoverage buildCounters(File classDirectory, ExecutionDataStore data) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        if (classDirectory.isDirectory()) {
            Analyzer analyzer = new Analyzer(data, (ICoverageVisitor)coverageBuilder);
            try {
                analyzer.analyzeAll(classDirectory);
            }
            catch (IOException e) {
                this.log.debug((CharSequence)("An exception occured while analyzing files : " + e.getMessage()));
            }
        }
        return coverageBuilder.getBundle("Bundle");
    }
}

