/*
 * Decompiled with CFR 0.152.
 */
package cloud.noetica.jacocolog;

import cloud.noetica.jacocolog.JacocoCounters;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;

public class CountersLogger {
    private static final NumberFormat NUMBER_FORMAT_LOCALE = NumberFormat.getInstance(Locale.getDefault());
    private final Log log;
    private final int digits;
    private final Set<ICoverageNode.CounterEntity> counters;

    public CountersLogger(Log log, int digits, Set<ICoverageNode.CounterEntity> counters) {
        this.log = log;
        this.digits = digits;
        this.counters = counters;
    }

    public void log(JacocoCounters coverage) {
        this.log.info((CharSequence)"Test Coverage:");
        for (ICoverageNode.CounterEntity type : this.counters) {
            ICounter counter = coverage.getCounters().get(type);
            String value = Optional.of(counter).filter(c -> c.getTotalCount() > 0).map(c -> this.format(c.getCoveredRatio()) + "%").orElse("unknown");
            this.log.info((CharSequence)("    - " + this.toCounterString(type) + " Coverage: " + value));
            this.log.debug((CharSequence)("     Covered : " + counter.getCoveredCount() + ", Total : " + counter.getTotalCount()));
        }
    }

    private String format(double value) {
        return NUMBER_FORMAT_LOCALE.format(BigDecimal.valueOf(value * 100.0).setScale(this.digits, RoundingMode.FLOOR));
    }

    private String toCounterString(ICoverageNode.CounterEntity counter) {
        switch (counter) {
            case CLASS: {
                return "Class";
            }
            case METHOD: {
                return "Method";
            }
            case BRANCH: {
                return "Branch";
            }
            case LINE: {
                return "Line";
            }
            case INSTRUCTION: {
                return "Instruction";
            }
            case COMPLEXITY: {
                return "Complexity";
            }
        }
        return "Unknown";
    }
}

