/*
 * Decompiled with CFR 0.152.
 */
package cloud.noetica.jacocolog;

import cloud.noetica.jacocolog.CountersLogger;
import cloud.noetica.jacocolog.JacocoCounters;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;

@Named
@Singleton
public class CoverageAggregatorLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private Map<String, JacocoCounters> reports = new HashMap<String, JacocoCounters>();
    private Log log;
    private CountersLogger logger;
    private boolean enable = false;
    private Set<String> includes;

    public void setLog(Log log) {
        this.log = log;
    }

    public void setLogger(CountersLogger logger) {
        this.logger = logger;
    }

    public void enable() {
        this.enable = true;
    }

    public void setIncludes(Set<String> includes) {
        this.includes = includes;
    }

    public void record(String projectName, JacocoCounters report) {
        this.reports.put(projectName, report);
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        if (!this.enable) {
            return;
        }
        this.log.info((CharSequence)"--- Overall coverage ---");
        if (this.reports.size() <= 0) {
            this.log.info((CharSequence)"No reports to aggregate");
            return;
        }
        Set<String> projects = this.includes != null && !this.includes.isEmpty() ? this.reports.keySet().stream().filter(p -> this.includes.contains(p)).collect(Collectors.toSet()) : this.reports.keySet();
        this.includes.stream().filter(name -> !projects.contains(name)).forEach(projectName -> this.log.warn((CharSequence)("Project \"" + projectName + "\" not found in current build session")));
        projects.stream().map(p -> this.reports.get(p)).reduce((a, b) -> a.merge((JacocoCounters)b)).ifPresent(report -> this.logger.log((JacocoCounters)report));
        this.reports.clear();
    }
}

