/*
 * Decompiled with CFR 0.152.
 */
package cloud.noetica.jacocolog;

import cloud.noetica.jacocolog.CountersExtractor;
import cloud.noetica.jacocolog.CountersLogger;
import cloud.noetica.jacocolog.CoverageAggregatorLifecycleParticipant;
import cloud.noetica.jacocolog.JacocoCounters;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jacoco.core.analysis.ICoverageNode;

@Mojo(name="coverage", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, aggregator=true)
public class CoverageMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="overall")
    private OverallCoverageConfig overall;
    @Parameter(property="includes", defaultValue="**\\jacoco.exec")
    private String includes;
    @Parameter(property="counters", defaultValue="CLASS,METHOD,BRANCH,LINE,INSTRUCTION,COMPLEXITY")
    private List<ICoverageNode.CounterEntity> counters;
    @Parameter(property="digits", defaultValue="2")
    private int digits;
    @Inject
    private CoverageAggregatorLifecycleParticipant hook;

    public void execute() throws MojoExecutionException {
        CountersExtractor extractor;
        JacocoCounters report;
        CountersLogger logger = new CountersLogger(this.getLog(), this.digits, new LinkedHashSet<ICoverageNode.CounterEntity>(this.counters));
        if (this.project.isExecutionRoot() && this.overall.isEnable()) {
            this.hook.enable();
            this.hook.setLog(this.getLog());
            this.hook.setIncludes(this.overall.getIncludes());
            this.hook.setLogger(logger);
        }
        if ((report = (extractor = new CountersExtractor(this.getLog(), this.includes)).extract(this.project)) != null) {
            this.hook.record(this.project.getName(), report);
            logger.log(report);
        }
    }

    public static class OverallCoverageConfig {
        private boolean enable;
        private Set<String> includes = new LinkedHashSet<String>();

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public Set<String> getIncludes() {
            return this.includes;
        }

        public void setIncludes(Set<String> includes) {
            this.includes = includes;
        }
    }
}

