/*
 * Decompiled with CFR 0.152.
 */
package cloud.noetica.jacocolog;

import java.util.Arrays;
import java.util.EnumMap;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.internal.analysis.CounterImpl;

public class JacocoCounters {
    private EnumMap<ICoverageNode.CounterEntity, ICounter> counters = new EnumMap(ICoverageNode.CounterEntity.class);

    private JacocoCounters() {
    }

    public static JacocoCounters of(IBundleCoverage bundle) {
        JacocoCounters counters = new JacocoCounters();
        counters.counters.put(ICoverageNode.CounterEntity.CLASS, bundle.getInstructionCounter());
        counters.counters.put(ICoverageNode.CounterEntity.METHOD, bundle.getMethodCounter());
        counters.counters.put(ICoverageNode.CounterEntity.BRANCH, bundle.getBranchCounter());
        counters.counters.put(ICoverageNode.CounterEntity.LINE, bundle.getLineCounter());
        counters.counters.put(ICoverageNode.CounterEntity.INSTRUCTION, bundle.getInstructionCounter());
        counters.counters.put(ICoverageNode.CounterEntity.COMPLEXITY, bundle.getComplexityCounter());
        return counters;
    }

    public EnumMap<ICoverageNode.CounterEntity, ICounter> getCounters() {
        return this.counters;
    }

    public JacocoCounters merge(JacocoCounters other) {
        Arrays.stream(ICoverageNode.CounterEntity.values()).forEach(e -> this.counters.merge((ICoverageNode.CounterEntity)e, other.getCounters().get(e), (base, incoming) -> {
            if (base == null) {
                return incoming;
            }
            if (incoming == null) {
                return base;
            }
            int mergedMissed = base.getMissedCount() + incoming.getMissedCount();
            int mergedCovered = base.getCoveredCount() + incoming.getCoveredCount();
            return CounterImpl.getInstance((int)mergedMissed, (int)mergedCovered);
        }));
        return this;
    }
}

