/*
 * Decompiled with CFR 0.152.
 */
package cloud.pianola.cdk.fluent.assertion;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;

public abstract class AbstractCDKResourcesAssert<SELF extends AbstractCDKResourcesAssert<SELF, ACTUAL>, ACTUAL extends Map<String, Object>>
extends AbstractAssert<SELF, ACTUAL> {
    protected AbstractCDKResourcesAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF hasTag(String key, Object value) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        List tags = (List)properties.get("Tags");
        ((ListAssert)Assertions.assertThat((List)tags).isNotEmpty()).contains(new Object[]{Map.of("Key", key, "Value", value)});
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasDependency(String expected) {
        List actualDependency = (List)((Map)this.actual).get("DependsOn");
        Assertions.assertThat((List)actualDependency).isInstanceOf(List.class).anyMatch(s -> s.matches(expected));
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasUpdateReplacePolicy(String expected) {
        String actualUpdateReplacePolicy = (String)((Map)this.actual).get("UpdateReplacePolicy");
        ((AbstractStringAssert)Assertions.assertThat((String)actualUpdateReplacePolicy).isInstanceOf(String.class)).isEqualTo(expected);
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasDeletionPolicy(String expected) {
        String actualDeletionPolicy = (String)((Map)this.actual).get("DeletionPolicy");
        ((AbstractStringAssert)Assertions.assertThat((String)actualDeletionPolicy).isInstanceOf(String.class)).isEqualTo(expected);
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasEnvironmentVariable(String key, String value) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map environment = (Map)properties.get("Environment");
        Map variables = (Map)environment.get("Variables");
        ((ObjectAssert)Assertions.assertThat(variables.get(key)).isInstanceOf(String.class)).isEqualTo((Object)value);
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasDescription(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        String description = (String)properties.get("Description");
        ((AbstractStringAssert)Assertions.assertThat((String)description).isInstanceOf(String.class)).isEqualTo(expected);
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasMemorySize(Integer expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Integer memorySize = (Integer)properties.get("MemorySize");
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)memorySize).isInstanceOf(Integer.class)).isEqualTo((Object)expected);
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasRuntime(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        String runtime = (String)properties.get("Runtime");
        ((AbstractStringAssert)Assertions.assertThat((String)runtime).isInstanceOf(String.class)).isEqualTo(expected);
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasTimeout(Integer timeoutInSeconds) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Integer timeout = (Integer)properties.get("Timeout");
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)timeout).isInstanceOf(Integer.class)).isEqualTo((Object)timeoutInSeconds);
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }

    public SELF hasPolicy(String principal, String resource, String effect, String policyDocumentVersion, String action, Map<String, Object> policyDocument) {
        AbstractListAssert policyDocumentAssertMap = ((AbstractListAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(policyDocument).isNotNull()).isNotEmpty()).containsEntry((Object)"Version", (Object)policyDocumentVersion)).extracting("Statement").asList().isNotNull().isNotEmpty()).map(l -> (Map)l);
        policyDocumentAssertMap.anySatisfy(s -> ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)s).isNotNull()).isNotEmpty()).containsEntry((Object)"Effect", (Object)effect)).containsEntry((Object)"Action", (Object)action));
        if (StringUtils.isNotBlank((CharSequence)principal)) {
            policyDocumentAssertMap.anySatisfy(s -> Assertions.assertThat((Map)s).extracting("Principal").extracting("Service").matches(e -> e.toString().matches(principal)));
        }
        if (StringUtils.isNotBlank((CharSequence)resource)) {
            policyDocumentAssertMap.anySatisfy(s -> Assertions.assertThat((Map)s).extracting("Resource").extracting("Ref").matches(e -> e.toString().matches(resource)));
        }
        return (SELF)((Object)((AbstractCDKResourcesAssert)this.myself));
    }
}

