/*
 * Decompiled with CFR 0.152.
 */
package cloud.pianola.cdk.fluent.assertion;

import cloud.pianola.cdk.fluent.assertion.CdkResourceType;
import cloud.pianola.cdk.fluent.assertion.LambdaAssert;
import cloud.pianola.cdk.fluent.assertion.LambdaEventInvokeConfigAssert;
import cloud.pianola.cdk.fluent.assertion.LambdaPermissionAssert;
import cloud.pianola.cdk.fluent.assertion.PolicyAssert;
import cloud.pianola.cdk.fluent.assertion.QueueAssert;
import cloud.pianola.cdk.fluent.assertion.QueuePolicyAssert;
import cloud.pianola.cdk.fluent.assertion.RestApiAccountAssert;
import cloud.pianola.cdk.fluent.assertion.RestApiAssert;
import cloud.pianola.cdk.fluent.assertion.RestApiDeploymentAssert;
import cloud.pianola.cdk.fluent.assertion.RestApiMethodAssert;
import cloud.pianola.cdk.fluent.assertion.RestApiResourceAssert;
import cloud.pianola.cdk.fluent.assertion.RestApiStageAssert;
import cloud.pianola.cdk.fluent.assertion.RoleAssert;
import cloud.pianola.cdk.fluent.assertion.TopicAssert;
import cloud.pianola.cdk.fluent.assertion.TopicSubscriptionAssert;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import software.amazon.awscdk.assertions.Match;
import software.amazon.awscdk.assertions.Matcher;
import software.amazon.awscdk.assertions.Template;

public class CDKStackAssert
extends AbstractAssert<CDKStackAssert, Template> {
    private CDKStackAssert(Template actual) {
        super((Object)actual, CDKStackAssert.class);
    }

    public static CDKStackAssert assertThat(Template actual) {
        return new CDKStackAssert(actual);
    }

    public RestApiAssert containsRestApi(String expected) {
        Map<String, Map<String, Matcher>> properties = Map.of("Properties", Map.of("Name", Match.stringLikeRegexp((String)expected)));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.APIGATEWAY_RESTAPI.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return RestApiAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasRestApi(expected);
    }

    public RestApiAccountAssert containsRestApiAccountWithCloudWatchRoleArn(String cloudWatchRoleArn) {
        Map<String, Map<String, Map<String, List<String>>>> properties = Map.of("Properties", Map.of("CloudWatchRoleArn", Map.of("Fn::GetAtt", List.of(Match.stringLikeRegexp((String)cloudWatchRoleArn), "Arn"))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.APIGATEWAY_RESTAPI_ACCOUNT.getValue(), properties);
        Assertions.assertThat((Map)resources).isNotEmpty();
        return RestApiAccountAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasCloudWatchRole(cloudWatchRoleArn);
    }

    public RestApiDeploymentAssert containsRestApiDeployment(String expectedRestApiId) {
        Map<String, Map<String, Map<String, Matcher>>> properties = Map.of("Properties", Map.of("RestApiId", Map.of("Ref", Match.stringLikeRegexp((String)expectedRestApiId))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.APIGATEWAY_RESTAPI_DEPLOYMENT.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return RestApiDeploymentAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasRestApiId(expectedRestApiId);
    }

    public RestApiMethodAssert containsNonRootRestApiMethod(String method, String resourceId) {
        Map<String, Map<String, Map<String, Matcher>>> properties = Map.of("Properties", Map.of("HttpMethod", method, "ResourceId", Map.of("Ref", Match.stringLikeRegexp((String)resourceId))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.APIGATEWAY_RESTAPI_METHOD.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return RestApiMethodAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasNonRootResourceId(resourceId);
    }

    public RestApiMethodAssert containsRootRestApiMethod(String method, String resourceId) {
        Map<String, Map<String, Map<String, List<String>>>> properties = Map.of("Properties", Map.of("HttpMethod", method, "ResourceId", Map.of("Fn::GetAtt", List.of(Match.stringLikeRegexp((String)resourceId), "RootResourceId"))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.APIGATEWAY_RESTAPI_METHOD.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return RestApiMethodAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasRootResourceId(resourceId);
    }

    public RestApiStageAssert containsRestApiStage(String stageName) {
        Map<String, Map<String, Matcher>> properties = Map.of("Properties", Map.of("StageName", Match.stringLikeRegexp((String)stageName)));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.APIGATEWAY_RESTAPI_STAGE.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return RestApiStageAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasStageName(stageName);
    }

    public RestApiResourceAssert containsRestApiResource(String pathPart, String restApiId, Map<String, List<Object>> parentId) {
        Map<String, Map<String, Map<String, List<Object>>>> properties = Map.of("Properties", Map.of("PathPart", pathPart, "RestApiId", Map.of("Ref", Match.stringLikeRegexp((String)restApiId)), "ParentId", parentId));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.APIGATEWAY_RESTAPI_RESOURCE.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return RestApiResourceAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasPath(pathPart);
    }

    public PolicyAssert containsPolicy(String policyName) {
        Map<String, Map<String, Matcher>> properties = Map.of("Properties", Map.of("PolicyName", Match.stringLikeRegexp((String)policyName)));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.POLICY.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return PolicyAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasPolicy(policyName);
    }

    public RoleAssert containsRoleWithManagedPolicyArn(String managedPolicyArn) {
        Map<String, Map<String, List<Map<String, List<List<String>>>>>> properties = Map.of("Properties", Map.of("ManagedPolicyArns", List.of(Map.of("Fn::Join", List.of("", List.of("arn:", Map.of("Ref", "AWS::Partition"), managedPolicyArn))))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.ROLE.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return RoleAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasManagedPolicyArn(managedPolicyArn);
    }

    public LambdaAssert containsFunction(String expected) {
        Map<String, Map<String, String>> properties = Map.of("Properties", Map.of("FunctionName", expected));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.LAMBDA_FUNCTION.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return LambdaAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasFunction(expected);
    }

    public LambdaEventInvokeConfigAssert containsLambdaEventInvokeConfig(String functionName, String successEventDestination, String failureEventDestination) {
        Map<String, Map<String, Map<String, Map<String, Map<String, Matcher>>>>> properties = Map.of("Properties", Map.of("FunctionName", Map.of("Ref", Match.stringLikeRegexp((String)functionName)), "DestinationConfig", Map.of("OnFailure", Map.of("Destination", Map.of("Ref", Match.stringLikeRegexp((String)failureEventDestination))), "OnSuccess", Map.of("Destination", Map.of("Ref", Match.stringLikeRegexp((String)successEventDestination))))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.LAMBDA_EVENT_INVOKE_CONFIG.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return LambdaEventInvokeConfigAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasLambdaEventInvokeConfig(functionName, successEventDestination, failureEventDestination);
    }

    public LambdaEventInvokeConfigAssert containsLambdaEventInvokeConfig(String functionName) {
        Map<String, Map<String, Map<String, Matcher>>> properties = Map.of("Properties", Map.of("FunctionName", Map.of("Ref", Match.stringLikeRegexp((String)functionName))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.LAMBDA_EVENT_INVOKE_CONFIG.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return LambdaEventInvokeConfigAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasLambdaEventInvokeConfig(functionName, null, null);
    }

    public LambdaPermissionAssert containsLambdaPermission(String functionName, String action, String principal, List<Object> sourceArns) {
        Map<String, Map<String, Map<String, List<String>>>> properties = Map.of("Properties", Map.of("Action", action, "Principal", principal, "SourceArn", Map.of("Fn::Join", List.of("", sourceArns)), "FunctionName", Map.of("Fn::GetAtt", List.of(Match.stringLikeRegexp((String)functionName), "Arn"))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.LAMBDA_PERMISSION.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return LambdaPermissionAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasLambdaPermission(functionName, action, principal);
    }

    public QueuePolicyAssert containsQueuePolicy(String queueReference, String policyStatementAction, String policyStatementResource, String policyStatementPrincipalService) {
        Map<String, Map<String, Map<String, List<Map<String, Map<String, String>>>>>> properties = Map.of("Properties", Map.of("Queues", List.of(Map.of("Ref", Match.stringLikeRegexp((String)queueReference))), "PolicyDocument", Map.of("Version", "2012-10-17", "Statement", List.of(Map.of("Action", policyStatementAction, "Resource", Map.of("Fn::GetAtt", List.of(Match.stringLikeRegexp((String)policyStatementResource), "Arn")), "Principal", Map.of("Service", policyStatementPrincipalService))))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.QUEUE_POLICY.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return QueuePolicyAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasQueuePolicy(queueReference, policyStatementAction, policyStatementResource, policyStatementPrincipalService);
    }

    public QueueAssert containsQueue(String name) {
        Map resources = ((Template)this.actual).findResources(CdkResourceType.QUEUE.getValue(), Map.of("Properties", Map.of("QueueName", name)));
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return QueueAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasQueue(name);
    }

    public TopicAssert containsTopic(String name) {
        Map<String, Map<String, String>> properties = Map.of("Properties", Map.of("TopicName", name));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.TOPIC.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        return TopicAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasTopic(name);
    }

    public void containsTopicSubscription(String topicArn, String protocol, String endpoint) {
        Map<String, Map<String, Map<String, Matcher>>> properties = Map.of("Properties", Map.of("Endpoint", Map.of("Fn::GetAtt", List.of(Match.stringLikeRegexp((String)endpoint), "Arn")), "Protocol", protocol, "TopicArn", Map.of("Ref", Match.stringLikeRegexp((String)topicArn))));
        Map resources = ((Template)this.actual).findResources(CdkResourceType.TOPIC_SUBSCRIPTION.getValue(), properties);
        ((MapAssert)Assertions.assertThat((Map)resources).isNotEmpty()).hasSize(1);
        TopicSubscriptionAssert.assertThat((Map)resources.values().stream().findFirst().get()).hasTopicSubscription(topicArn, protocol, endpoint);
    }
}

