/*
 * Decompiled with CFR 0.152.
 */
package cloud.pianola.cdk.fluent.assertion;

import cloud.pianola.cdk.fluent.assertion.AbstractCDKResourcesAssert;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class LambdaEventInvokeConfigAssert
extends AbstractCDKResourcesAssert<LambdaEventInvokeConfigAssert, Map<String, Object>> {
    private LambdaEventInvokeConfigAssert(Map<String, Object> actual) {
        super(actual, LambdaEventInvokeConfigAssert.class);
    }

    public static LambdaEventInvokeConfigAssert assertThat(Map<String, Object> actual) {
        return new LambdaEventInvokeConfigAssert(actual);
    }

    public LambdaEventInvokeConfigAssert hasLambdaEventInvokeConfig(String expectedFunctionName, String expectedSuccessEventDestination, String expectedFailureEventDestination) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        String actualFunctionName = (String)((Map)properties.get("FunctionName")).get("Ref");
        ((AbstractStringAssert)Assertions.assertThat((String)actualFunctionName).isInstanceOf(String.class)).matches(actual -> actual.matches(expectedFunctionName));
        Map destinationConfig = (Map)properties.get("DestinationConfig");
        if (StringUtils.isNotBlank((CharSequence)expectedSuccessEventDestination)) {
            String actualSuccessDestinationConfig = this.getEventSuccessDestination(destinationConfig);
            ((AbstractStringAssert)Assertions.assertThat((String)actualSuccessDestinationConfig).isInstanceOf(String.class)).matches((CharSequence)expectedSuccessEventDestination);
        }
        if (StringUtils.isNotBlank((CharSequence)expectedFailureEventDestination)) {
            String actualFailureDestinationConfig = this.getEventFailureDestination(destinationConfig);
            ((AbstractStringAssert)Assertions.assertThat((String)actualFailureDestinationConfig).isInstanceOf(String.class)).matches((CharSequence)expectedFailureEventDestination);
        }
        return this;
    }

    public LambdaEventInvokeConfigAssert hasLambdaEventInvokeConfigMaximumRetryAttempts(Integer expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)properties.get("MaximumRetryAttempts"))).isInstanceOf(Integer.class)).isEqualTo((Object)expected);
        return this;
    }

    public LambdaEventInvokeConfigAssert hasLambdaEventInvokeConfigQualifier(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)properties.get("Qualifier"))).isInstanceOf(String.class)).matches(actual -> actual.equals(expected));
        return this;
    }

    private String getEventFailureDestination(Map<String, Object> destinationConfig) {
        return this.getLambdaEventDestination(destinationConfig, "OnFailure");
    }

    private String getEventSuccessDestination(Map<String, Object> destinationConfig) {
        return this.getLambdaEventDestination(destinationConfig, "OnSuccess");
    }

    private String getLambdaEventDestination(Map<String, Object> destinationConfig, String successFailureKey) {
        Map successFailureDestinationConfig = (Map)destinationConfig.get(successFailureKey);
        Map destination = (Map)successFailureDestinationConfig.get("Destination");
        return (String)destination.get("Ref");
    }
}

