/*
 * Decompiled with CFR 0.152.
 */
package cloud.pianola.cdk.fluent.assertion;

import cloud.pianola.cdk.fluent.assertion.AbstractCDKResourcesAssert;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;

public class PolicyAssert
extends AbstractCDKResourcesAssert<PolicyAssert, Map<String, Object>> {
    private PolicyAssert(Map<String, Object> actual) {
        super(actual, PolicyAssert.class);
    }

    public static PolicyAssert assertThat(Map<String, Object> actual) {
        return new PolicyAssert(actual);
    }

    public PolicyAssert hasPolicy(String expected) {
        String policyName = (String)((Map)((Map)this.actual).get("Properties")).get("PolicyName");
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)policyName).isNotNull()).isInstanceOf(String.class)).matches(actualPolicyName -> actualPolicyName.matches(expected));
        return this;
    }

    public PolicyAssert hasPolicyDocumentVersion(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map policyDocument = (Map)properties.get("PolicyDocument");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)policyDocument).isNotNull()).isNotEmpty()).containsEntry((Object)"Version", (Object)expected);
        return this;
    }

    public PolicyAssert hasPolicyDocumentStatement(String principal, String resource, String action, String effect, String policyDocumentVersion) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map policyDocument = (Map)properties.get("PolicyDocument");
        return (PolicyAssert)((Object)this.hasPolicy(principal, resource, effect, policyDocumentVersion, action, policyDocument));
    }

    public PolicyAssert isAssociatedWithRole(String expected) {
        List roles = (List)((Map)((Map)this.actual).get("Properties")).get("Roles");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)roles).isNotNull()).isNotEmpty()).allMatch(role -> ((String)((Map)role).get("Ref")).matches(expected));
        return this;
    }
}

