/*
 * Decompiled with CFR 0.152.
 */
package cloud.pianola.cdk.fluent.assertion;

import cloud.pianola.cdk.fluent.assertion.AbstractCDKResourcesAssert;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;

public class QueuePolicyAssert
extends AbstractCDKResourcesAssert<QueuePolicyAssert, Map<String, Object>> {
    private QueuePolicyAssert(Map<String, Object> actual) {
        super(actual, QueuePolicyAssert.class);
    }

    public static QueuePolicyAssert assertThat(Map<String, Object> actual) {
        return new QueuePolicyAssert(actual);
    }

    public QueuePolicyAssert hasQueuePolicy(String queueReference, String policyStatementAction, String policyStatementResource, String policyStatementPrincipalService) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        List queues = (List)properties.get("Queues");
        Map policyDocument = (Map)properties.get("PolicyDocument");
        List statements = (List)policyDocument.get("Statement");
        ((ObjectAssert)((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)queues).isNotNull()).isNotEmpty()).hasSize(1)).extracting("Ref").element(0)).matches(e -> ((String)e).matches(queueReference));
        boolean actionFound = false;
        boolean principalServiceFound = false;
        boolean resourceFound = false;
        for (Map statement : statements) {
            actionFound = statement.get("Action").equals(policyStatementAction);
            Map principal = (Map)statement.get("Principal");
            String service = (String)principal.get("Service");
            principalServiceFound = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{service}) && service.equals(policyStatementPrincipalService);
            List resources = (List)((Map)statement.get("Resource")).get("Fn::GetAtt");
            String resource = (String)resources.get(0);
            resourceFound = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resource}) && resource.matches(policyStatementResource);
        }
        ((ObjectAssert)Assertions.assertThat(policyDocument.get("Version")).isInstanceOf(String.class)).isEqualTo((Object)"2012-10-17");
        Assertions.assertThat((boolean)actionFound).isTrue();
        Assertions.assertThat((boolean)principalServiceFound).isTrue();
        Assertions.assertThat((boolean)resourceFound).isTrue();
        return this;
    }

    public QueuePolicyAssert hasEffect(String effect) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map policyDocument = (Map)properties.get("PolicyDocument");
        List statements = (List)policyDocument.get("Statement");
        boolean effectFound = false;
        for (Map statement : statements) {
            effectFound = statement.get("Effect").equals(effect);
        }
        Assertions.assertThat((boolean)effectFound).isTrue();
        return this;
    }

    public QueuePolicyAssert hasCondition(String policyStatementConditionType, String policyStatementConditionSourceType, String policyStatementConditionSourceArn) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map policyDocument = (Map)properties.get("PolicyDocument");
        List statements = (List)policyDocument.get("Statement");
        boolean conditionMatch = false;
        for (Map statement : statements) {
            Map condition = (Map)statement.get("Condition");
            Map conditionType = (Map)condition.get(policyStatementConditionType);
            Map conditionSourceType = (Map)conditionType.get(policyStatementConditionSourceType);
            conditionMatch = ((String)conditionSourceType.get("Ref")).matches(policyStatementConditionSourceArn);
        }
        Assertions.assertThat((boolean)conditionMatch).isTrue();
        return this;
    }
}

