/*
 * Decompiled with CFR 0.152.
 */
package cloud.pianola.cdk.fluent.assertion;

import cloud.pianola.cdk.fluent.assertion.AbstractCDKResourcesAssert;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;

public class RestApiMethodAssert
extends AbstractCDKResourcesAssert<RestApiMethodAssert, Map<String, Object>> {
    private RestApiMethodAssert(Map<String, Object> actual) {
        super(actual, RestApiMethodAssert.class);
    }

    public static RestApiMethodAssert assertThat(Map<String, Object> actual) {
        return new RestApiMethodAssert(actual);
    }

    public RestApiMethodAssert hasRestApiId(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map restApiId = (Map)properties.get("RestApiId");
        ((MapAssert)Assertions.assertThat((Map)restApiId).isNotEmpty()).extracting("Ref").matches(e -> e.toString().matches(expected));
        return this;
    }

    public RestApiMethodAssert hasAuthorizationType(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        String authorizationType = (String)properties.get("AuthorizationType");
        ((AbstractStringAssert)Assertions.assertThat((String)authorizationType).isNotBlank()).matches(e -> e.matches(expected));
        return this;
    }

    public RestApiMethodAssert hasHttpMethod(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        String httpMethod = (String)properties.get("HttpMethod");
        ((AbstractStringAssert)Assertions.assertThat((String)httpMethod).isNotBlank()).matches(e -> e.matches(expected));
        return this;
    }

    public RestApiMethodAssert hasIntegration(String method, String type) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map integration = (Map)properties.get("Integration");
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)integration).isNotEmpty()).containsEntry((Object)"IntegrationHttpMethod", (Object)method)).containsEntry((Object)"Type", (Object)type)).containsKey((Object)"Uri");
        return this;
    }

    public RestApiMethodAssert hasNonRootResourceId(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map resourceId = (Map)properties.get("ResourceId");
        ((MapAssert)Assertions.assertThat((Map)resourceId).isNotEmpty()).extracting("Ref").matches(e -> e.toString().matches(expected));
        return this;
    }

    public RestApiMethodAssert hasRootResourceId(String expected) {
        Map properties = (Map)((Map)this.actual).get("Properties");
        Map resourceId = (Map)properties.get("ResourceId");
        ((MapAssert)Assertions.assertThat((Map)resourceId).isNotEmpty()).extracting("Fn::GetAtt").asList().map(e -> (String)e).anySatisfy(e -> Assertions.assertThat((String)e).matches((CharSequence)expected));
        return this;
    }
}

