/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.pages.wasp;

import cloud.piranha.pages.wasp.WaspJspManager;
import cloud.piranha.webapp.api.JspManager;
import cloud.piranha.webapp.api.WebApplication;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.jsp.JspFactory;
import java.io.File;
import java.util.Set;
import org.apache.jasper.runtime.JspFactoryImpl;

public class WaspInitializer
implements ServletContainerInitializer {
    private static final System.Logger LOGGER = System.getLogger(WaspInitializer.class.getName());

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        LOGGER.log(System.Logger.Level.DEBUG, "Initializing Jasper integration");
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
        ServletRegistration.Dynamic registration = servletContext.addServlet("jsp", "org.apache.jasper.servlet.JspServlet");
        registration.addMapping(new String[]{"*.jsp"});
        String classpath = System.getProperty("jdk.module.path", System.getProperty("java.class.path")) + this.getClassesDirectory(servletContext) + this.getJarFiles(servletContext);
        LOGGER.log(System.Logger.Level.TRACE, () -> "WaSP classpath is: " + classpath);
        registration.setInitParameter("classpath", classpath);
        registration.setInitParameter("compilerSourceVM", "1.8");
        registration.setInitParameter("compilerTargetVM", "1.8");
        WebApplication webApplication = (WebApplication)servletContext;
        webApplication.setJspManager((JspManager)new WaspJspManager());
        servletContext.setAttribute("org.glassfish.wasp.useMultiJarScanAlgo", (Object)true);
        LOGGER.log(System.Logger.Level.DEBUG, "Initialized WaSP integration");
    }

    private String getClassesDirectory(ServletContext servletContext) {
        String classesDirectory = servletContext.getRealPath("/WEB-INF/classes");
        if (classesDirectory == null) {
            return "";
        }
        return File.pathSeparator + classesDirectory;
    }

    private String getJarFiles(ServletContext servletContext) {
        String[] files;
        File directory;
        StringBuilder jarFiles = new StringBuilder();
        String realPath = servletContext.getRealPath("/WEB-INF/lib");
        if (realPath != null && (directory = new File(realPath)).isDirectory() && (files = directory.list()) != null) {
            for (String file : files) {
                if (!file.toLowerCase().endsWith(".jar")) continue;
                jarFiles.append(File.pathSeparator);
                jarFiles.append(file);
            }
        }
        return jarFiles.toString();
    }

    static {
        if (WaspInitializer.class.getModule().isNamed()) {
            String oldExtDirs = System.getProperty("java.ext.dirs", "");
            System.setProperty("java.ext.dirs", System.getProperty("jdk.module.path") + File.pathSeparator + oldExtDirs);
        }
    }
}

